/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.model;

import lombok.NonNull;
import org.apache.commons.lang3.math.NumberUtils;
import uk.modl.ancestry.Ancestry;
import uk.modl.ancestry.Child;
import uk.modl.ancestry.Parent;
import uk.modl.model.Primitive;
import uk.modl.utils.IDSource;

public final class NumberPrimitive
implements Primitive,
Child {
    private final long id;
    @NonNull
    private final String value;

    public static NumberPrimitive of(Ancestry ancestry, Parent parent, String value) {
        NumberPrimitive child = NumberPrimitive.of(IDSource.nextId(), value);
        ancestry.add(parent, child);
        return child;
    }

    public String toString() {
        return this.value;
    }

    @Override
    public Number numericValue() {
        return NumberUtils.createNumber((String)this.value);
    }

    private NumberPrimitive(long id, @NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.id = id;
        this.value = value;
    }

    public static NumberPrimitive of(long id, @NonNull String value) {
        return new NumberPrimitive(id, value);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @NonNull
    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NumberPrimitive)) {
            return false;
        }
        NumberPrimitive other = (NumberPrimitive)o;
        return this.getId() == other.getId();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        return result;
    }
}

