/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.modl.ancestry.Ancestry;
import uk.modl.model.Modl;
import uk.modl.parser.ModlParsedVisitor;
import uk.modl.parser.antlr.MODLLexer;
import uk.modl.parser.antlr.MODLParser;
import uk.modl.parser.errors.ThrowingErrorListener;

public class Parser {
    private static final Logger log = LogManager.getLogger(Parser.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Modl apply(String input, Ancestry ancestry, long timeoutMilliseconds) {
        try {
            MODLParser.ModlContext modlCtx;
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            ByteArrayInputStream stream = new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));
            MODLLexer lexer = new MODLLexer(CharStreams.fromStream((InputStream)stream, (Charset)StandardCharsets.UTF_8));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            MODLParser parser = new MODLParser((TokenStream)tokens);
            parser.setBuildParseTree(true);
            lexer.addErrorListener((ANTLRErrorListener)ThrowingErrorListener.INSTANCE);
            parser.addErrorListener((ANTLRErrorListener)ThrowingErrorListener.INSTANCE);
            AtomicReference taskThread = new AtomicReference();
            Future<MODLParser.ModlContext> future = executorService.submit(() -> {
                taskThread.set(Thread.currentThread());
                return parser.modl();
            });
            try {
                modlCtx = future.get(timeoutMilliseconds, TimeUnit.MILLISECONDS);
            }
            finally {
                executorService.shutdownNow();
                try {
                    ((Thread)taskThread.get()).stop();
                }
                catch (Throwable throwable) {}
            }
            if (modlCtx != null) {
                return new ModlParsedVisitor(modlCtx, ancestry).getModl();
            }
            throw new TimeoutException();
        }
        catch (IOException | InterruptedException | TimeoutException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ParseCancellationException) {
                throw (ParseCancellationException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }
}

