/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.modl.ancestry.Ancestry;
import uk.modl.model.Modl;
import uk.modl.parser.ModlParsedVisitor;
import uk.modl.parser.antlr.MODLLexer;
import uk.modl.parser.antlr.MODLParser;
import uk.modl.parser.errors.ThrowingErrorListener;

public class Parser {
    private static final Logger log = LogManager.getLogger(Parser.class);

    public Modl apply(String input, Ancestry ancestry) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));
            MODLLexer lexer = new MODLLexer(CharStreams.fromStream((InputStream)stream, (Charset)StandardCharsets.UTF_8));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            MODLParser parser = new MODLParser((TokenStream)tokens);
            parser.setBuildParseTree(true);
            lexer.addErrorListener((ANTLRErrorListener)ThrowingErrorListener.INSTANCE);
            parser.addErrorListener((ANTLRErrorListener)ThrowingErrorListener.INSTANCE);
            MODLParser.ModlContext modlCtx = parser.modl();
            return new ModlParsedVisitor(modlCtx, ancestry).getModl();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

