/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.ancestry;

import io.vavr.control.Option;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import uk.modl.ancestry.Child;
import uk.modl.ancestry.Parent;
import uk.modl.model.Array;
import uk.modl.model.ArrayItem;
import uk.modl.model.Map;
import uk.modl.model.MapItem;
import uk.modl.model.Modl;
import uk.modl.model.Pair;
import uk.modl.model.Primitive;
import uk.modl.model.Structure;

public class Ancestry {
    private final java.util.Map<Child, Parent> ancestors = new LinkedHashMap<Child, Parent>();

    public void add(Parent parent, Child child) {
        if (child != null) {
            this.ancestors.put(child, parent);
        }
    }

    public void dump() {
        this.ancestors.entrySet().stream().map(e -> {
            Child child = (Child)e.getKey();
            Parent parent = (Parent)e.getValue();
            long childId = child.getId();
            String childHash = Integer.toHexString(System.identityHashCode(child));
            String childString = "" + childId + ":" + child.getClass().getSimpleName() + "\\n" + childHash;
            if (child instanceof Pair) {
                childString = childString + ":\\n" + ((Pair)child).getKey();
            }
            if (child instanceof Primitive) {
                childString = childString + ":\\n" + child.toString();
            }
            if (parent != null) {
                long parentId = parent.getId();
                String parentHash = Integer.toHexString(System.identityHashCode(parent));
                String parentString = "" + parentId + ":" + parent.getClass().getSimpleName() + "\\n" + parentHash;
                if (parent instanceof Pair) {
                    parentString = parentString + ":\\n" + ((Pair)parent).getKey();
                }
                if (parent instanceof Primitive) {
                    parentString = parentString + ":\\n" + parent.toString();
                }
                return "\"" + parentHash + "\"[label=\"" + parentString + "\"]\n\"" + childHash + "\"[label=\"" + childString + "\"]\n\"" + childHash + "\" -> \"" + parentHash + "\"";
            }
            return "missing[label=\"missing\"]\n\"" + childHash + "\"[label=\"" + childString + "\"]\n\"" + childHash + "\" -> missing";
        }).forEach(System.out::println);
    }

    public Option<Pair> findByKey(Child child, String key) {
        Option<Pair> result = this.findByKey(0, child, key);
        if (result.isDefined() && !((Pair)result.get()).equals(child)) {
            return result;
        }
        List roots = this.ancestors.entrySet().stream().filter(entry -> entry.getValue() == null).map(Map.Entry::getKey).collect(Collectors.toList());
        Pair found = null;
        for (Child root : roots) {
            if (!(root instanceof Modl)) continue;
            Modl modl = (Modl)root;
            for (Structure s : modl.getStructures()) {
                if (!(s instanceof Pair) || !((Pair)s).getKey().equals(key) || s.equals(child)) continue;
                found = (Pair)s;
            }
        }
        if (found != null) {
            return Option.of(found);
        }
        return Option.none();
    }

    private Option<Pair> findByKey(int depth, Child child, String key) {
        Parent parent;
        Pair found;
        if (depth > 0 && child instanceof Pair && ((Pair)child).getKey().equals(key)) {
            return Option.of((Object)((Pair)child));
        }
        if (child instanceof Array) {
            found = null;
            Array array = (Array)child;
            for (ArrayItem arrayItem : array.getArrayItems()) {
                if (!(arrayItem instanceof Pair) || !((Pair)arrayItem).getKey().equals(key)) continue;
                found = (Pair)arrayItem;
            }
            if (found != null) {
                return Option.of(found);
            }
        }
        if (child instanceof Map) {
            found = null;
            Map map = (Map)child;
            for (MapItem mapItem : map.getMapItems()) {
                if (!(mapItem instanceof Pair) || !((Pair)mapItem).getKey().equals(key)) continue;
                found = (Pair)mapItem;
            }
            if (found != null) {
                return Option.of(found);
            }
        }
        if (child instanceof Modl) {
            found = null;
            Modl modl = (Modl)child;
            for (Structure s : modl.getStructures()) {
                if (!(s instanceof Pair) || !((Pair)s).getKey().equals(key)) continue;
                found = (Pair)s;
            }
            if (found != null) {
                return Option.of(found);
            }
        }
        if ((parent = this.ancestors.get(child)) != null) {
            return this.findByKey(depth + 1, (Child)((Object)parent), key);
        }
        List roots = this.ancestors.entrySet().stream().filter(entry -> entry.getValue() == null).map(Map.Entry::getKey).collect(Collectors.toList());
        Pair found2 = null;
        for (Child root : roots) {
            if (!(root instanceof Modl)) continue;
            Modl modl = (Modl)root;
            for (Structure s : modl.getStructures()) {
                if (!(s instanceof Pair) || !((Pair)s).getKey().equals(key)) continue;
                found2 = (Pair)s;
            }
        }
        if (found2 != null) {
            return Option.of(found2);
        }
        return Option.none();
    }

    public void replaceChild(Child oldChild, Child newChild) {
        if (oldChild != null && newChild != null) {
            Parent parent = this.ancestors.remove(oldChild);
            List childrenOfOldChild = this.ancestors.entrySet().stream().filter(entry -> entry.getValue() != null && ((Parent)entry.getValue()).equals(oldChild)).map(Map.Entry::getKey).collect(Collectors.toList());
            for (Child childOfOldChild : childrenOfOldChild) {
                this.ancestors.remove(childOfOldChild);
                this.ancestors.put(childOfOldChild, (Parent)((Object)newChild));
            }
            this.ancestors.put(newChild, parent);
        }
    }

    private void prune(Parent parent) {
        List<Child> referencesToOldChild = this.ancestors.entrySet().stream().filter(entry -> entry.getValue() != null && ((Parent)entry.getValue()).equals(parent)).map(Map.Entry::getKey).collect(Collectors.toList());
        referencesToOldChild.forEach(this.ancestors::remove);
        referencesToOldChild.forEach(child -> this.prune((Parent)((Object)child)));
    }

    public void replaceSubTree(Child oldChild, Child newChild) {
        if (oldChild != null && newChild != null) {
            Parent parent = this.ancestors.remove(oldChild);
            this.prune((Parent)((Object)oldChild));
            this.ancestors.put(newChild, parent);
        }
    }
}

