/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.transforms;

import io.vavr.collection.Vector;
import uk.modl.ancestry.Parent;
import uk.modl.model.Array;
import uk.modl.model.ArrayItem;
import uk.modl.model.Map;
import uk.modl.model.MapItem;
import uk.modl.model.NullPrimitive;
import uk.modl.model.Pair;
import uk.modl.model.PairValue;
import uk.modl.model.StringPrimitive;
import uk.modl.model.Structure;
import uk.modl.transforms.StarClassTransform;
import uk.modl.transforms.StarMethodTransform;
import uk.modl.transforms.TransformationContext;

public class PercentStarInstructionTransform {
    public PairValue apply(TransformationContext ctx, Parent parent, PairValue vi) {
        String s;
        if (vi instanceof StringPrimitive && (s = ((StringPrimitive)vi).getValue()).startsWith("%*")) {
            return this.instructionToReferencedItems(ctx, parent, s);
        }
        return vi;
    }

    private Array instructionToReferencedItems(TransformationContext ctx, Parent parent, String ir) {
        Array arr = Array.of(ctx.getAncestry(), parent, (Vector<ArrayItem>)Vector.empty());
        if ("%*load".equals(ir)) {
            return arr.with(ctx.getAncestry(), (Vector<ArrayItem>)ctx.getFilesLoaded().map(f -> StringPrimitive.of(ctx.getAncestry(), arr, f)));
        }
        if ("%*class".equals(ir)) {
            return arr.with(ctx.getAncestry(), (Vector<ArrayItem>)ctx.getClasses().map(classInstruction -> this.classInstructionToArrayItem(ctx, parent, (StarClassTransform.ClassInstruction)classInstruction)).toVector());
        }
        if ("%*method".equals(ir)) {
            return arr.with(ctx.getAncestry(), (Vector<ArrayItem>)ctx.getMethods().map(methodInstruction -> this.methodInstructionToArrayItem(ctx, parent, (StarMethodTransform.MethodInstruction)methodInstruction)).toVector());
        }
        return arr;
    }

    private ArrayItem methodInstructionToArrayItem(TransformationContext ctx, Parent parent, StarMethodTransform.MethodInstruction m) {
        Vector mthdItems = Vector.empty();
        Map resultMap = Map.of(ctx.getAncestry(), parent, (Vector<MapItem>)Vector.empty());
        Pair pair = Pair.of(ctx.getAncestry(), resultMap, "", NullPrimitive.instance);
        Map map = Map.of(ctx.getAncestry(), pair, (Vector<MapItem>)Vector.empty());
        Pair transformPair = pair.with(ctx.getAncestry(), "transform", StringPrimitive.of(ctx.getAncestry(), pair, m.getTransform()));
        if (m.getName() != null) {
            Pair namePair = Pair.of(ctx.getAncestry(), map, "name", NullPrimitive.instance);
            Pair newNamePair = namePair.with(ctx.getAncestry(), "name", StringPrimitive.of(ctx.getAncestry(), namePair, m.getName()));
            mthdItems = mthdItems.append((Object)newNamePair);
        }
        mthdItems = mthdItems.append((Object)transformPair);
        return resultMap.with(ctx.getAncestry(), (Vector<MapItem>)Vector.of((Object)pair.with(ctx.getAncestry(), m.getId(), map.with(ctx.getAncestry(), (Vector<MapItem>)mthdItems))));
    }

    private ArrayItem classInstructionToArrayItem(TransformationContext ctx, Parent parent, StarClassTransform.ClassInstruction ci) {
        Pair p;
        Map resultMap = Map.of(ctx.getAncestry(), parent, (Vector<MapItem>)Vector.empty());
        Pair pair = Pair.of(ctx.getAncestry(), resultMap, "", NullPrimitive.instance);
        Vector clssItems = Vector.empty();
        if (ci.getName() != null) {
            p = Pair.of(ctx.getAncestry(), pair, "name", NullPrimitive.instance);
            clssItems = clssItems.append((Object)p.with(ctx.getAncestry(), "name", StringPrimitive.of(ctx.getAncestry(), p, ci.getName())));
        }
        p = Pair.of(ctx.getAncestry(), pair, "superclass", NullPrimitive.instance);
        clssItems = clssItems.append((Object)p.with(ctx.getAncestry(), "superclass", StringPrimitive.of(ctx.getAncestry(), p, ci.getSuperclass())));
        if (ci.getAssign().nonEmpty()) {
            p = Pair.of(ctx.getAncestry(), pair, "assign", NullPrimitive.instance);
            clssItems = clssItems.append((Object)p.with(ctx.getAncestry(), "assign", Array.of(ctx.getAncestry(), p, ci.getAssign())));
        }
        if (ci.getPairs() != null) {
            clssItems = clssItems.appendAll((Iterable)ci.getPairs().values());
        }
        return resultMap.with(ctx.getAncestry(), (Vector<MapItem>)Vector.of((Object)pair.with(ctx.getAncestry(), ci.getId(), Map.of(ctx.getAncestry(), pair, (Vector<MapItem>)clssItems))));
    }

    public Structure apply(TransformationContext ctx, Parent parent, Structure s) {
        Pair pair;
        PairValue newValue;
        if (s instanceof Pair && (newValue = this.apply(ctx, parent, (pair = (Pair)s).getValue())) != pair.getValue()) {
            return pair.with(ctx.getAncestry(), pair.getKey(), newValue);
        }
        return s;
    }
}

