/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.interpreter;

import java.io.UnsupportedEncodingException;
import java.net.IDN;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.text.WordUtils;

public class VariableMethods {
    private static Map<String, TaskRunner> methods = null;

    private static void initialiseMethods() {
        methods = new HashMap<String, TaskRunner>();
        VariableMethods.addTrimTask();
        VariableMethods.addUpperCaseTask();
        VariableMethods.addDownCaseTask();
        VariableMethods.addInitCapsTask();
        VariableMethods.addUrlEncodeTask();
        VariableMethods.addSentenceTask();
        VariableMethods.addReplaceTask();
        VariableMethods.addPunycodeTask();
    }

    private static void addTrimTask() {
        TaskRunner trimTask = new TaskRunner(){

            @Override
            public void run() {
                if (this.parameter == null) {
                    this.result = null;
                }
                String[] split = this.parameter.split(",");
                String subject = split[0];
                String trim = split[1];
                int indexOfTrim = subject.indexOf(trim);
                this.result = subject.substring(0, indexOfTrim);
            }
        };
        methods.put("t", trimTask);
        methods.put("trim", trimTask);
    }

    private static void addUpperCaseTask() {
        TaskRunner upperCaseTask = new TaskRunner(){

            @Override
            public void run() {
                if (this.parameter == null) {
                    this.result = null;
                }
                this.result = this.parameter.toUpperCase();
            }
        };
        methods.put("u", upperCaseTask);
    }

    private static void addSentenceTask() {
        TaskRunner sentenceTask = new TaskRunner(){

            @Override
            public void run() {
                if (this.parameter == null) {
                    this.result = null;
                }
                this.result = VariableMethods.makeSentence(this.parameter);
            }
        };
        methods.put("s", sentenceTask);
    }

    private static void addDownCaseTask() {
        TaskRunner downCaseTask = new TaskRunner(){

            @Override
            public void run() {
                if (this.parameter == null) {
                    this.result = null;
                }
                this.result = this.parameter.toLowerCase();
            }
        };
        methods.put("d", downCaseTask);
    }

    private static void addInitCapsTask() {
        TaskRunner task = new TaskRunner(){

            @Override
            public void run() {
                if (this.parameter == null) {
                    this.result = null;
                }
                this.result = WordUtils.capitalize((String)this.parameter);
            }
        };
        methods.put("i", task);
        methods.put("initcap", task);
    }

    private static void addReplaceTask() {
        TaskRunner task = new TaskRunner(){

            @Override
            public void run() {
                if (this.parameter == null) {
                    this.result = null;
                }
                String[] split = this.parameter.split(",");
                String subject = split[0];
                String search = split[1];
                String replace = "";
                if (split.length > 2) {
                    replace = split[2];
                }
                this.result = subject.replace(search, replace);
            }
        };
        methods.put("r", task);
        methods.put("replace", task);
    }

    private static void addUrlEncodeTask() {
        TaskRunner task = new TaskRunner(){

            @Override
            public void run() {
                if (this.parameter == null) {
                    this.result = null;
                }
                try {
                    this.result = URLEncoder.encode(this.parameter, StandardCharsets.UTF_8.toString());
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    this.result = null;
                }
            }
        };
        methods.put("e", task);
    }

    private static void addPunycodeTask() {
        TaskRunner task = new TaskRunner(){

            @Override
            public void run() {
                if (this.parameter == null) {
                    this.result = null;
                }
                this.result = VariableMethods.replacePunycode(this.parameter);
            }
        };
        methods.put("p", task);
    }

    public static String transform(String methodName, String input) {
        if (methods == null) {
            VariableMethods.initialiseMethods();
        }
        TaskRunner taskRunner = methods.get(methodName);
        try {
            taskRunner.setParameter(input);
            taskRunner.run();
            String result = taskRunner.getResult();
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Can't call variable method " + methodName + " : " + e);
        }
    }

    public static void addMethod(String shortName, TaskRunner taskRunner) {
        if (methods == null) {
            VariableMethods.initialiseMethods();
        }
        methods.put(shortName, taskRunner);
    }

    private static String makeSentence(String parameter) {
        String[] splits = parameter.split(" ");
        splits[0] = WordUtils.capitalize((String)splits[0]);
        String ret = "";
        int count = 0;
        for (String s : splits) {
            if (count > 0) {
                ret = ret + " ";
            }
            ++count;
            ret = ret + s;
        }
        return ret;
    }

    private static String replacePunycode(String stringToTransform) {
        if (stringToTransform == null) {
            return stringToTransform;
        }
        if (stringToTransform.startsWith("`") && stringToTransform.endsWith("`")) {
            stringToTransform = stringToTransform.substring(1, stringToTransform.length() - 1);
        }
        String originalString = stringToTransform;
        stringToTransform = "xn--" + stringToTransform;
        String newStringToTransform = IDN.toUnicode(stringToTransform);
        stringToTransform = newStringToTransform.equals(stringToTransform) ? originalString : newStringToTransform;
        return stringToTransform;
    }

    public static boolean isVariableMethod(String s) {
        if (methods == null) {
            VariableMethods.initialiseMethods();
        }
        return methods.get(s) != null;
    }

    public static abstract class TaskRunner
    implements Runnable {
        protected String parameter;
        protected String result;

        public void setParameter(String s) {
            this.parameter = s;
        }

        public String getResult() {
            return this.result;
        }
    }
}

