/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.interpreter;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import uk.modl.interpreter.Interpreter;
import uk.modl.interpreter.ModlClassLoader;
import uk.modl.interpreter.VariableMethods;
import uk.modl.modlObject.ModlObject;

public class VariableMethodLoader {
    public static void loadVariableMethod(ModlObject.Structure structure, Interpreter interpreter) {
        String methodString;
        String description;
        String methodName = ModlClassLoader.getPairValueFor(structure, "*id", interpreter);
        if (methodName == null) {
            methodName = ModlClassLoader.getPairValueFor(structure, "*i", interpreter);
        }
        if ((description = ModlClassLoader.getPairValueFor(structure, "*name", interpreter)) == null) {
            description = ModlClassLoader.getPairValueFor(structure, "*n", interpreter);
        }
        if (description == null) {
            description = methodName;
        }
        if ((methodString = ModlClassLoader.getPairValueFor(structure, "*transform", interpreter)) == null) {
            methodString = ModlClassLoader.getPairValueFor(structure, "*t", interpreter);
        }
        methodString = methodString.replace("`", "");
        VariableMethodLoader.createVariableMethod(methodName, methodString);
    }

    private static void createVariableMethod(String methodName, String methodString) {
        final List<Map<String, String>> methodsAndParams = VariableMethodLoader.getMethodsAndParams(methodString);
        VariableMethods.TaskRunner newTask = new VariableMethods.TaskRunner(){

            @Override
            public void run() {
                String intermediateResult = this.parameter;
                for (Map methodAndParam : methodsAndParams) {
                    String method;
                    String params = (String)methodAndParam.get(method = (String)methodAndParam.keySet().toArray()[0]);
                    if (params == null || params.length() == 0) {
                        intermediateResult = VariableMethods.transform(method, intermediateResult);
                        continue;
                    }
                    intermediateResult = VariableMethods.transform(method, intermediateResult + "," + params);
                }
                this.result = intermediateResult;
            }
        };
        VariableMethods.addMethod(methodName, newTask);
    }

    private static List<Map<String, String>> getMethodsAndParams(String methodString) {
        LinkedList<Map<String, String>> methodsAndParams = new LinkedList<Map<String, String>>();
        while (methodString.indexOf("(") > 0 || methodString.length() > 0) {
            int bracketIndex = methodString.indexOf("(");
            int dotIndex = methodString.indexOf(".");
            int endOfStringIndex = methodString.length();
            int actualIndex = bracketIndex;
            if (actualIndex < 0) {
                actualIndex = dotIndex;
            } else if (dotIndex > 0) {
                actualIndex = Math.min(dotIndex, bracketIndex);
            }
            if (actualIndex < 0) {
                actualIndex = endOfStringIndex;
            }
            String intermediateMethodName = methodString.substring(0, actualIndex);
            String params = null;
            int endIndex = endOfStringIndex;
            if (actualIndex == bracketIndex) {
                int closeBracketIndex = methodString.indexOf(")");
                params = methodString.substring(bracketIndex + 1, closeBracketIndex);
                endIndex = closeBracketIndex + 1;
                if (endIndex < methodString.length()) {
                    ++endIndex;
                }
            } else if (actualIndex == dotIndex) {
                endIndex = actualIndex + 1;
            }
            HashMap<String, String> methodAndParam = new HashMap<String, String>();
            methodAndParam.put(intermediateMethodName, params);
            methodsAndParams.add(methodAndParam);
            methodString = methodString.substring(endIndex, methodString.length());
        }
        return methodsAndParams;
    }
}

