/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.parser;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang3.tuple.ImmutablePair;
import uk.modl.parser.antlr.MODLParser;
import uk.modl.parser.antlr.MODLParserBaseListener;

public class ModlParsed
extends MODLParserBaseListener {
    List<Structure> structures = new LinkedList<Structure>();
    private static final Pattern gravedPattern = Pattern.compile("^`([^`]*)`$");

    @Override
    public void enterModl(MODLParser.ModlContext ctx) {
        for (MODLParser.Modl_structureContext str : ctx.modl_structure()) {
            Structure structure = new Structure();
            str.enterRule(structure);
            this.structures.add(structure);
        }
    }

    public List<Structure> getStructures() {
        return this.structures;
    }

    private static java.lang.String additionalStringProcessing(java.lang.String text) {
        Matcher matcher;
        if (text != null && (matcher = gravedPattern.matcher(text)).matches()) {
            return matcher.group(1);
        }
        return text;
    }

    private ArrayItem handleEmptyArrayItem() {
        ArrayItem arrayItem = new ArrayItem();
        arrayItem.arrayValueItem = new ArrayValueItem();
        arrayItem.arrayValueItem.nullVal = new Null();
        return arrayItem;
    }

    public class Null
    extends MODLParserBaseListener
    implements ValueObject {
    }

    public class False
    extends MODLParserBaseListener
    implements ValueObject {
    }

    public class True
    extends MODLParserBaseListener
    implements ValueObject {
    }

    public class ArrayItem
    extends MODLParserBaseListener
    implements AbstractArrayItem {
        ArrayValueItem arrayValueItem;
        ArrayConditional arrayConditional;

        @Override
        public void enterModl_array_item(MODLParser.Modl_array_itemContext ctx) {
            if (ctx.modl_array_conditional() != null) {
                this.arrayConditional = new ArrayConditional();
                ctx.modl_array_conditional().enterRule(this.arrayConditional);
            }
            if (ctx.modl_array_value_item() != null) {
                this.arrayValueItem = new ArrayValueItem();
                ctx.modl_array_value_item().enterRule(this.arrayValueItem);
            }
        }

        public ArrayValueItem getArrayValueItem() {
            return this.arrayValueItem;
        }

        public ArrayConditional getArrayConditional() {
            return this.arrayConditional;
        }
    }

    public class Array
    extends MODLParserBaseListener
    implements ValueObject {
        List<AbstractArrayItem> abstractArrayItems = new ArrayList<AbstractArrayItem>();

        @Override
        public void enterModl_array(MODLParser.Modl_arrayContext ctx) {
            this.abstractArrayItems = new LinkedList<AbstractArrayItem>();
            int i = 0;
            ParseTree previous = null;
            for (ParseTree pt : ctx.children) {
                if (pt instanceof MODLParser.Modl_array_itemContext) {
                    ArrayItem arrayItem = new ArrayItem();
                    ((MODLParser.Modl_array_itemContext)pt).enterRule(arrayItem);
                    this.abstractArrayItems.add(i++, arrayItem);
                } else if (pt instanceof MODLParser.Modl_nb_arrayContext) {
                    NbArray nbArray = new NbArray();
                    ((MODLParser.Modl_nb_arrayContext)pt).enterRule(nbArray);
                    this.abstractArrayItems.add(i++, nbArray);
                } else if (pt instanceof TerminalNode && previous != null && previous instanceof TerminalNode && pt instanceof TerminalNode) {
                    int prevSymbol = ((TerminalNode)previous).getSymbol().getType();
                    int currentSymbol = ((TerminalNode)pt).getSymbol().getType();
                    if (prevSymbol == 11 && currentSymbol == 12) continue;
                    if (prevSymbol != 5 && currentSymbol != 5) {
                        ArrayItem arrayItem = ModlParsed.this.handleEmptyArrayItem();
                        this.abstractArrayItems.add(i++, arrayItem);
                    }
                }
                previous = pt;
            }
        }

        public List<AbstractArrayItem> getAbstractArrayItems() {
            return this.abstractArrayItems;
        }
    }

    public static interface AbstractArrayItem
    extends ValueObject {
    }

    public class NbArray
    extends MODLParserBaseListener
    implements AbstractArrayItem {
        List<ArrayItem> arrayItems = new LinkedList<ArrayItem>();

        @Override
        public void enterModl_nb_array(MODLParser.Modl_nb_arrayContext ctx) {
            int i = 0;
            ParseTree previous = null;
            for (ParseTree pt : ctx.children) {
                if (pt instanceof MODLParser.Modl_array_itemContext) {
                    ArrayItem arrayItem = new ArrayItem();
                    ((MODLParser.Modl_array_itemContext)pt).enterRule(arrayItem);
                    this.arrayItems.add(i++, arrayItem);
                } else if (pt instanceof TerminalNode && previous != null && previous instanceof TerminalNode && pt instanceof TerminalNode) {
                    int prevSymbol = ((TerminalNode)previous).getSymbol().getType();
                    int currentSymbol = ((TerminalNode)pt).getSymbol().getType();
                    if (prevSymbol != 5 && currentSymbol != 5) {
                        ArrayItem arrayItem = ModlParsed.this.handleEmptyArrayItem();
                        this.arrayItems.add(i++, arrayItem);
                    }
                }
                previous = pt;
            }
        }

        public List<ArrayItem> getArrayItems() {
            return this.arrayItems;
        }
    }

    public class ValueConditional
    extends MODLParserBaseListener
    implements ValueObject {
        java.util.Map<ConditionTest, ValueConditionalReturn> valueConditionalReturns;

        @Override
        public void enterModl_value_conditional(MODLParser.Modl_value_conditionalContext ctx) {
            this.valueConditionalReturns = new LinkedHashMap<ConditionTest, ValueConditionalReturn>();
            for (int i = 0; i < ctx.modl_condition_test().size(); ++i) {
                ConditionTest conditionTest = new ConditionTest();
                ctx.modl_condition_test(i).enterRule(conditionTest);
                if (ctx.modl_value_conditional_return().size() > 0) {
                    ValueConditionalReturn conditionalReturn = new ValueConditionalReturn();
                    ctx.modl_value_conditional_return(i).enterRule(conditionalReturn);
                    this.valueConditionalReturns.put(conditionTest, conditionalReturn);
                    continue;
                }
                this.valueConditionalReturns.put(conditionTest, null);
            }
            if (ctx.modl_value_conditional_return().size() > ctx.modl_condition_test().size()) {
                ConditionTest conditionTest = new ConditionTest();
                ValueConditionalReturn conditionalReturn = new ValueConditionalReturn();
                ctx.modl_value_conditional_return(ctx.modl_value_conditional_return().size() - 1).enterRule(conditionalReturn);
                this.valueConditionalReturns.put(conditionTest, conditionalReturn);
            }
        }

        public java.util.Map<ConditionTest, ValueConditionalReturn> getValueConditionalReturns() {
            return this.valueConditionalReturns;
        }
    }

    public class ValueConditionalReturn
    extends MODLParserBaseListener
    implements ValueObject {
        List<ValueItem> valueItems = new LinkedList<ValueItem>();

        @Override
        public void enterModl_value_conditional_return(MODLParser.Modl_value_conditional_returnContext ctx) {
            if (ctx.modl_value_item().size() > 0) {
                for (MODLParser.Modl_value_itemContext vi : ctx.modl_value_item()) {
                    ValueItem valueItem = new ValueItem();
                    vi.enterRule(valueItem);
                    this.valueItems.add(valueItem);
                }
            }
        }

        public List<ValueItem> getValueItems() {
            return this.valueItems;
        }
    }

    public class ArrayConditional
    extends MODLParserBaseListener
    implements ValueObject {
        java.util.Map<ConditionTest, ArrayConditionalReturn> arrayConditionalReturns;

        @Override
        public void enterModl_array_conditional(MODLParser.Modl_array_conditionalContext ctx) {
            this.arrayConditionalReturns = new LinkedHashMap<ConditionTest, ArrayConditionalReturn>();
            for (int i = 0; i < ctx.modl_condition_test().size(); ++i) {
                ConditionTest conditionTest = new ConditionTest();
                ctx.modl_condition_test(i).enterRule(conditionTest);
                ArrayConditionalReturn conditionalReturn = new ArrayConditionalReturn();
                ctx.modl_array_conditional_return(i).enterRule(conditionalReturn);
                this.arrayConditionalReturns.put(conditionTest, conditionalReturn);
            }
            if (ctx.modl_array_conditional_return().size() > ctx.modl_condition_test().size()) {
                ConditionTest conditionTest = new ConditionTest();
                ArrayConditionalReturn conditionalReturn = new ArrayConditionalReturn();
                ctx.modl_array_conditional_return(ctx.modl_array_conditional_return().size() - 1).enterRule(conditionalReturn);
                this.arrayConditionalReturns.put(conditionTest, conditionalReturn);
            }
        }

        public java.util.Map<ConditionTest, ArrayConditionalReturn> getArrayConditionalReturns() {
            return this.arrayConditionalReturns;
        }
    }

    public class ArrayConditionalReturn
    extends MODLParserBaseListener
    implements ValueObject {
        List<ArrayItem> arrayItems = new LinkedList<ArrayItem>();

        @Override
        public void enterModl_array_conditional_return(MODLParser.Modl_array_conditional_returnContext ctx) {
            if (ctx.modl_array_item().size() > 0) {
                for (MODLParser.Modl_array_itemContext ai : ctx.modl_array_item()) {
                    ArrayItem arrayItem = new ArrayItem();
                    ai.enterRule(arrayItem);
                    this.arrayItems.add(arrayItem);
                }
            }
        }

        public List<ArrayItem> getArrayItems() {
            return this.arrayItems;
        }
    }

    public class TopLevelConditional
    extends MODLParserBaseListener
    implements ValueObject {
        java.util.Map<ConditionTest, TopLevelConditionalReturn> topLevelConditionalReturns;

        @Override
        public void enterModl_top_level_conditional(MODLParser.Modl_top_level_conditionalContext ctx) {
            this.topLevelConditionalReturns = new LinkedHashMap<ConditionTest, TopLevelConditionalReturn>();
            for (int i = 0; i < ctx.modl_condition_test().size(); ++i) {
                ConditionTest conditionTest = new ConditionTest();
                ctx.modl_condition_test(i).enterRule(conditionTest);
                TopLevelConditionalReturn conditionalReturn = new TopLevelConditionalReturn();
                ctx.modl_top_level_conditional_return(i).enterRule(conditionalReturn);
                this.topLevelConditionalReturns.put(conditionTest, conditionalReturn);
            }
            if (ctx.modl_top_level_conditional_return().size() > ctx.modl_condition_test().size()) {
                ConditionTest conditionTest = new ConditionTest();
                TopLevelConditionalReturn conditionalReturn = new TopLevelConditionalReturn();
                ctx.modl_top_level_conditional_return(ctx.modl_top_level_conditional_return().size() - 1).enterRule(conditionalReturn);
                this.topLevelConditionalReturns.put(conditionTest, conditionalReturn);
            }
        }

        public java.util.Map<ConditionTest, TopLevelConditionalReturn> getTopLevelConditionalReturns() {
            return this.topLevelConditionalReturns;
        }
    }

    public class TopLevelConditionalReturn
    extends MODLParserBaseListener
    implements ValueObject {
        List<Structure> structures = new LinkedList<Structure>();

        @Override
        public void enterModl_top_level_conditional_return(MODLParser.Modl_top_level_conditional_returnContext ctx) {
            if (ctx.modl_structure().size() > 0) {
                for (MODLParser.Modl_structureContext str : ctx.modl_structure()) {
                    Structure structure = new Structure();
                    str.enterRule(structure);
                    this.structures.add(structure);
                }
            }
        }

        public List<Structure> getStructures() {
            return this.structures;
        }
    }

    public class MapConditional
    extends MODLParserBaseListener
    implements ValueObject {
        java.util.Map<ConditionTest, MapConditionalReturn> mapConditionals;

        @Override
        public void enterModl_map_conditional(MODLParser.Modl_map_conditionalContext ctx) {
            this.mapConditionals = new LinkedHashMap<ConditionTest, MapConditionalReturn>();
            for (int i = 0; i < ctx.modl_condition_test().size(); ++i) {
                ConditionTest conditionTest = new ConditionTest();
                ctx.modl_condition_test(i).enterRule(conditionTest);
                MapConditionalReturn conditionalReturn = new MapConditionalReturn();
                ctx.modl_map_conditional_return(i).enterRule(conditionalReturn);
                this.mapConditionals.put(conditionTest, conditionalReturn);
            }
            if (ctx.modl_map_conditional_return().size() > ctx.modl_condition_test().size()) {
                ConditionTest conditionTest = new ConditionTest();
                MapConditionalReturn conditionalReturn = new MapConditionalReturn();
                ctx.modl_map_conditional_return(ctx.modl_map_conditional_return().size() - 1).enterRule(conditionalReturn);
                this.mapConditionals.put(conditionTest, conditionalReturn);
            }
        }

        public java.util.Map<ConditionTest, MapConditionalReturn> getMapConditionals() {
            return this.mapConditionals;
        }
    }

    public class MapConditionalReturn
    extends MODLParserBaseListener
    implements ValueObject {
        List<MapItem> mapItems = new LinkedList<MapItem>();

        @Override
        public void enterModl_map_conditional_return(MODLParser.Modl_map_conditional_returnContext ctx) {
            if (ctx.modl_map_item().size() > 0) {
                for (MODLParser.Modl_map_itemContext mi : ctx.modl_map_item()) {
                    MapItem mapItem = new MapItem();
                    mi.enterRule(mapItem);
                    this.mapItems.add(mapItem);
                }
            }
        }

        public List<MapItem> getMapItems() {
            return this.mapItems;
        }
    }

    public class Condition
    extends MODLParserBaseListener
    implements SubCondition {
        java.lang.String key;
        java.lang.String operator;
        List<Value> values = new LinkedList<Value>();

        @Override
        public void enterModl_condition(MODLParser.Modl_conditionContext ctx) {
            if (ctx.STRING() != null) {
                this.key = ctx.STRING().getText();
            }
            if (ctx.modl_operator() != null) {
                this.operator = ctx.modl_operator().getText();
            }
            for (MODLParser.Modl_valueContext v : ctx.modl_value()) {
                Value value = new Value();
                v.enterRule(value);
                this.values.add(value);
            }
        }
    }

    public class ConditionGroup
    extends MODLParserBaseListener
    implements SubCondition {
        List<ImmutablePair<ConditionTest, java.lang.String>> conditionsTestList = new LinkedList<ImmutablePair<ConditionTest, java.lang.String>>();

        @Override
        public void enterModl_condition_group(MODLParser.Modl_condition_groupContext ctx) {
            if (ctx.children.size() > 0) {
                java.lang.String lastOperator = null;
                for (ParseTree child : ctx.children) {
                    if (child instanceof MODLParser.Modl_condition_testContext) {
                        ConditionTest conditionTest = new ConditionTest();
                        ((MODLParser.Modl_condition_testContext)child).enterRule(conditionTest);
                        this.conditionsTestList.add((ImmutablePair<ConditionTest, java.lang.String>)new ImmutablePair((Object)conditionTest, (Object)lastOperator));
                        lastOperator = null;
                        continue;
                    }
                    if (child.getText().equals("{") || child.getText().equals("}")) continue;
                    lastOperator = child.getText();
                }
            }
        }
    }

    public static interface SubCondition
    extends ValueObject {
    }

    public class ConditionTest
    extends MODLParserBaseListener
    implements ValueObject {
        List<ImmutablePair<SubCondition, ImmutablePair<java.lang.String, Boolean>>> subConditionList = new LinkedList<ImmutablePair<SubCondition, ImmutablePair<java.lang.String, Boolean>>>();

        @Override
        public void enterModl_condition_test(MODLParser.Modl_condition_testContext ctx) {
            if (ctx.children.size() > 0) {
                java.lang.String lastOperator = null;
                boolean shouldNegate = false;
                for (ParseTree child : ctx.children) {
                    if (child instanceof MODLParser.Modl_condition_groupContext) {
                        ConditionGroup conditionGroup = new ConditionGroup();
                        ((MODLParser.Modl_condition_groupContext)child).enterRule(conditionGroup);
                        this.subConditionList.add((ImmutablePair<SubCondition, ImmutablePair<java.lang.String, Boolean>>)new ImmutablePair((Object)conditionGroup, (Object)new ImmutablePair((Object)lastOperator, (Object)shouldNegate)));
                        lastOperator = null;
                        shouldNegate = false;
                        continue;
                    }
                    if (child instanceof MODLParser.Modl_conditionContext) {
                        Condition condition = new Condition();
                        ((MODLParser.Modl_conditionContext)child).enterRule(condition);
                        this.subConditionList.add((ImmutablePair<SubCondition, ImmutablePair<java.lang.String, Boolean>>)new ImmutablePair((Object)condition, (Object)new ImmutablePair((Object)lastOperator, (Object)shouldNegate)));
                        lastOperator = null;
                        shouldNegate = false;
                        continue;
                    }
                    if (child.getText().equals("!")) {
                        shouldNegate = true;
                        continue;
                    }
                    lastOperator = child.getText();
                }
            }
        }
    }

    public class Quoted
    implements ValueObject {
        public java.lang.String string;

        public Quoted(java.lang.String string) {
            this.string = string;
        }
    }

    public class Number
    implements ValueObject {
        public java.lang.String string;

        public Number(java.lang.String string) {
            this.string = string;
        }
    }

    public class String
    implements ValueObject {
        public java.lang.String string;

        public String(java.lang.String string) {
            this.string = string;
        }
    }

    public class Pair
    extends MODLParserBaseListener
    implements ValueObject {
        java.lang.String key;
        Map map;
        Array array;
        ValueItem valueItem;

        @Override
        public void enterModl_pair(MODLParser.Modl_pairContext ctx) {
            if (ctx.STRING() != null) {
                this.key = ctx.STRING().toString();
            }
            if (ctx.QUOTED() != null) {
                this.key = ctx.QUOTED().toString();
                this.key = this.key.substring(1, this.key.length() - 1);
            }
            if (ctx.modl_array() != null) {
                this.array = new Array();
                ctx.modl_array().enterRule(this.array);
            } else if (ctx.modl_map() != null) {
                this.map = new Map();
                ctx.modl_map().enterRule(this.map);
            } else if (ctx.modl_value_item() != null) {
                this.valueItem = new ValueItem();
                ctx.modl_value_item().enterRule(this.valueItem);
            }
        }

        public ValueItem getValueItem() {
            return this.valueItem;
        }

        public java.lang.String getKey() {
            return this.key;
        }

        public Map getMap() {
            return this.map;
        }

        public Array getArray() {
            return this.array;
        }
    }

    public class ValueItem
    extends MODLParserBaseListener
    implements ValueObject {
        Value value;
        ValueConditional valueConditional;

        @Override
        public void enterModl_value_item(MODLParser.Modl_value_itemContext ctx) {
            if (ctx.modl_value_conditional() != null) {
                this.valueConditional = new ValueConditional();
                ctx.modl_value_conditional().enterRule(this.valueConditional);
            }
            if (ctx.modl_value() != null) {
                this.value = new Value();
                ctx.modl_value().enterRule(this.value);
            }
        }

        public Value getValue() {
            return this.value;
        }

        public ValueConditional getValueConditional() {
            return this.valueConditional;
        }
    }

    public class ArrayValueItem
    extends MODLParserBaseListener
    implements ValueObject {
        Map map;
        Array array;
        Pair pair;
        Quoted quoted;
        Number number;
        True trueVal;
        False falseVal;
        Null nullVal;
        String string;

        @Override
        public void enterModl_array_value_item(MODLParser.Modl_array_value_itemContext ctx) {
            if (ctx.NUMBER() != null) {
                this.number = new Number(ctx.NUMBER().getText());
            } else if (ctx.modl_map() != null) {
                this.map = new Map();
                ctx.modl_map().enterRule(this.map);
            } else if (ctx.modl_array() != null) {
                this.array = new Array();
                ctx.modl_array().enterRule(this.array);
            } else if (ctx.modl_pair() != null) {
                this.pair = new Pair();
                ctx.modl_pair().enterRule(this.pair);
            } else if (ctx.STRING() != null) {
                java.lang.String textValue = ModlParsed.additionalStringProcessing(ctx.STRING().getText());
                this.string = new String(textValue);
            } else if (ctx.QUOTED() != null) {
                java.lang.String textValue = ModlParsed.additionalStringProcessing(ctx.QUOTED().getText());
                this.quoted = new Quoted(textValue);
            } else if (ctx.NULL() != null) {
                this.nullVal = new Null();
            } else if (ctx.TRUE() != null) {
                this.trueVal = new True();
            } else if (ctx.FALSE() != null) {
                this.falseVal = new False();
            }
        }

        public Quoted getQuoted() {
            return this.quoted;
        }

        public Number getNumber() {
            return this.number;
        }

        public True getTrueVal() {
            return this.trueVal;
        }

        public False getFalseVal() {
            return this.falseVal;
        }

        public Null getNullVal() {
            return this.nullVal;
        }

        public String getString() {
            return this.string;
        }

        public Map getMap() {
            return this.map;
        }

        public Array getArray() {
            return this.array;
        }

        public Pair getPair() {
            return this.pair;
        }
    }

    public class Value
    extends MODLParserBaseListener
    implements ValueObject {
        Map map;
        Array array;
        NbArray nbArray;
        Pair pair;
        Quoted quoted;
        Number number;
        True trueVal;
        False falseVal;
        Null nullVal;
        String string;

        @Override
        public void enterModl_value(MODLParser.Modl_valueContext ctx) {
            if (ctx.NUMBER() != null) {
                this.number = new Number(ctx.NUMBER().getText());
            } else if (ctx.modl_map() != null) {
                this.map = new Map();
                ctx.modl_map().enterRule(this.map);
            } else if (ctx.modl_nb_array() != null) {
                this.nbArray = new NbArray();
                ctx.modl_nb_array().enterRule(this.nbArray);
            } else if (ctx.modl_array() != null) {
                this.array = new Array();
                ctx.modl_array().enterRule(this.array);
            } else if (ctx.modl_pair() != null) {
                this.pair = new Pair();
                ctx.modl_pair().enterRule(this.pair);
            } else if (ctx.STRING() != null) {
                java.lang.String textValue = ModlParsed.additionalStringProcessing(ctx.STRING().getText());
                this.string = new String(textValue);
            } else if (ctx.QUOTED() != null) {
                java.lang.String textValue = ModlParsed.additionalStringProcessing(ctx.QUOTED().getText());
                this.quoted = new Quoted(textValue);
            } else if (ctx.NULL() != null) {
                this.nullVal = new Null();
            } else if (ctx.TRUE() != null) {
                this.trueVal = new True();
            } else if (ctx.FALSE() != null) {
                this.falseVal = new False();
            }
        }

        public Quoted getQuoted() {
            return this.quoted;
        }

        public Number getNumber() {
            return this.number;
        }

        public True getTrueVal() {
            return this.trueVal;
        }

        public False getFalseVal() {
            return this.falseVal;
        }

        public Null getNullVal() {
            return this.nullVal;
        }

        public String getString() {
            return this.string;
        }

        public Map getMap() {
            return this.map;
        }

        public Array getArray() {
            return this.array;
        }

        public Pair getPair() {
            return this.pair;
        }

        public NbArray getNbArray() {
            return this.nbArray;
        }
    }

    public class MapItem
    extends MODLParserBaseListener
    implements ValueObject {
        Pair pair;
        MapConditional mapConditional;

        @Override
        public void enterModl_map_item(MODLParser.Modl_map_itemContext ctx) {
            if (ctx.modl_pair() != null) {
                this.pair = new Pair();
                ctx.modl_pair().enterRule(this.pair);
            }
            if (ctx.modl_map_conditional() != null) {
                this.mapConditional = new MapConditional();
                ctx.modl_map_conditional().enterRule(this.mapConditional);
            }
        }

        public Pair getPair() {
            return this.pair;
        }

        public MapConditional getMapConditional() {
            return this.mapConditional;
        }
    }

    public class Map
    extends MODLParserBaseListener
    implements ValueObject {
        List<MapItem> mapItems;

        @Override
        public void enterModl_map(MODLParser.Modl_mapContext ctx) {
            if (ctx.modl_map_item() != null) {
                this.mapItems = new LinkedList<MapItem>();
                for (MODLParser.Modl_map_itemContext mi : ctx.modl_map_item()) {
                    MapItem mapItem = new MapItem();
                    mi.enterRule(mapItem);
                    this.mapItems.add(mapItem);
                }
            }
        }

        public List<MapItem> getMapItems() {
            return this.mapItems;
        }
    }

    public class Structure
    extends MODLParserBaseListener
    implements ValueObject {
        Array array;
        Pair pair;
        TopLevelConditional topLevelConditional;
        Map map;

        @Override
        public void enterModl_structure(MODLParser.Modl_structureContext ctx) {
            if (ctx.modl_pair() != null) {
                this.pair = new Pair();
                ctx.modl_pair().enterRule(this.pair);
            } else if (ctx.modl_top_level_conditional() != null) {
                this.topLevelConditional = new TopLevelConditional();
                ctx.modl_top_level_conditional().enterRule(this.topLevelConditional);
            } else if (ctx.modl_map() != null) {
                this.map = new Map();
                ctx.modl_map().enterRule(this.map);
            } else if (ctx.modl_array() != null) {
                this.array = new Array();
                ctx.modl_array().enterRule(this.array);
            }
        }

        public Array getArray() {
            return this.array;
        }

        public Pair getPair() {
            return this.pair;
        }

        public TopLevelConditional getTopLevelConditional() {
            return this.topLevelConditional;
        }

        public Map getMap() {
            return this.map;
        }
    }

    private static interface ValueObject {
    }
}

