/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.interpreter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.MutablePair;
import uk.modl.interpreter.FileLoader;
import uk.modl.interpreter.InstructionProcessor;
import uk.modl.interpreter.ModlClassLoader;
import uk.modl.interpreter.RequireRestart;
import uk.modl.interpreter.StringEscapeReplacer;
import uk.modl.interpreter.StringTransformer;
import uk.modl.interpreter.VariableLoader;
import uk.modl.interpreter.VariableMethodLoader;
import uk.modl.interpreter.VariableMethods;
import uk.modl.modlObject.ModlObject;
import uk.modl.modlObject.ModlValue;
import uk.modl.parser.ModlObjectCreator;
import uk.modl.parser.RawModlObject;
import uk.modl.parser.errors.InterpreterError;
import uk.modl.parser.printers.JsonPrinter;

public class Interpreter {
    public static final int MAX_CLASS_HIERARCHY_DEPTH = 50;
    public static VariableMethods variableMethods = null;
    private Map<String, Map<String, Object>> klasses = new LinkedHashMap<String, Map<String, Object>>();
    private Map<String, ModlValue> variables = new LinkedHashMap<String, ModlValue>();
    private Map<Integer, ModlValue> numberedVariables = new LinkedHashMap<Integer, ModlValue>();
    private Set<String> uppercaseInstructions = new HashSet<String>();
    private List<String> loadedFiles;
    private List<VariableMethodLoader.MethodDescriptor> methodList = new ArrayList<VariableMethodLoader.MethodDescriptor>();
    private Set<String> pairNames;
    private Map<String, ModlValue> valuePairs;
    private List<String> PRIMITIVES = Arrays.asList("num", "str", "map", "arr", "bool", "null");

    public Interpreter(List<String> loadedFiles) {
        this.loadedFiles = loadedFiles;
    }

    public static String parseToJson(String input, List<String> loadedFiles) throws IOException {
        ModlObject modlObject = Interpreter.interpret(input, loadedFiles);
        return JsonPrinter.printModl(modlObject);
    }

    public static ModlObject interpret(String input) throws IOException {
        RawModlObject rawModlObject = ModlObjectCreator.processModlParsed(input);
        return Interpreter.interpret(rawModlObject, new ArrayList<String>());
    }

    public static ModlObject interpret(String input, List<String> loadedFiles) throws IOException {
        RawModlObject rawModlObject = ModlObjectCreator.processModlParsed(input);
        return Interpreter.interpret(rawModlObject, loadedFiles);
    }

    public static ModlObject interpret(RawModlObject rawModlObject, List<String> loadedFiles) {
        Interpreter interpreter = new Interpreter(loadedFiles);
        variableMethods = new VariableMethods();
        ModlObject modlObject = null;
        while (modlObject == null) {
            try {
                modlObject = interpreter.interpretPrivate(rawModlObject);
            }
            catch (RequireRestart requireRestart) {}
        }
        StringEscapeReplacer.replaceAll(modlObject);
        return modlObject;
    }

    private static List<MutablePair<RawModlObject.ConditionTest, String>> getOrderedConditionalTestList(RawModlObject.ConditionGroup conditionGroup) {
        LinkedList<MutablePair<RawModlObject.ConditionTest, String>> orderedConditionalTestList = new LinkedList<MutablePair<RawModlObject.ConditionTest, String>>();
        int nullCount = 0;
        for (MutablePair<RawModlObject.ConditionTest, String> conditionalTestEntry : conditionGroup.getConditionsTestList()) {
            String operator = (String)conditionalTestEntry.getValue();
            if (operator == null) {
                orderedConditionalTestList.add(nullCount++, conditionalTestEntry);
                continue;
            }
            if (operator.equals("|")) {
                orderedConditionalTestList.add(conditionalTestEntry);
                continue;
            }
            if (!operator.equals("&")) continue;
            orderedConditionalTestList.add(nullCount, conditionalTestEntry);
        }
        return orderedConditionalTestList;
    }

    private static void validatePairKey(String newKey) {
        boolean keyIsAllDigits = true;
        char invalidCharacter = '\u0000';
        int i = 0;
        for (char c : newKey.toCharArray()) {
            if (!Character.isDigit(c)) {
                if (i == 0 && c == '_') continue;
                keyIsAllDigits = false;
            }
            if ("!$@-+'#^*\u00a3&".contains("" + c) && (i != 0 || c != '*')) {
                invalidCharacter = c;
            }
            ++i;
        }
        if (keyIsAllDigits) {
            String k = newKey;
            if (k.startsWith("_")) {
                k = k.substring(1);
            }
            throw new RuntimeException("Interpreter Error: Invalid key - \"" + k + "\" - entirely numeric keys are not allowed: " + newKey);
        }
        if (invalidCharacter != '\u0000') {
            throw new RuntimeException("Interpreter Error: Invalid key - \"" + invalidCharacter + "\" character not allowed: " + newKey);
        }
    }

    private ModlObject interpretPrivate(RawModlObject rawModlObject) throws RequireRestart {
        ModlObject modlObject = new ModlObject();
        this.pairNames = new HashSet<String>();
        this.valuePairs = new LinkedHashMap<String, ModlValue>();
        String versionString = null;
        boolean versionNumberIsWrong = false;
        boolean needRestart = false;
        RawModlObject loadedRawModlObject = null;
        String importFileValue = null;
        try {
            int i = 0;
            for (ModlObject.Structure rawStructure : rawModlObject.getStructures()) {
                List<ModlObject.Structure> structures;
                if (rawStructure instanceof ModlObject.Pair && ((ModlObject.Pair)rawStructure).getKey() != null && ((ModlObject.Pair)rawStructure).getKey().string != null && (((ModlObject.Pair)rawStructure).getKey().string.toLowerCase().equals("*v") || ((ModlObject.Pair)rawStructure).getKey().string.toLowerCase().equals("*version"))) {
                    this.addToUpperCaseInstructions(((ModlObject.Pair)rawStructure).getKey().string, "ERROR MESSAGE: %s");
                    if (((ModlObject.Pair)rawStructure).getModlValue() instanceof ModlObject.Number) {
                        versionString = ((ModlObject.Number)((ModlObject.Pair)rawStructure).getModlValue()).number;
                    } else if (((ModlObject.Pair)rawStructure).getModlValue() instanceof ModlObject.String) {
                        versionString = ((ModlObject.String)((ModlObject.Pair)rawStructure).getModlValue()).string;
                    }
                    float versionNumber = 0.0f;
                    try {
                        versionNumber = Float.valueOf(versionString).floatValue();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Interpreter Error: Invalid MODL version: " + versionString);
                    }
                    if ((double)versionNumber < 1.0 || versionNumber != Math.abs(versionNumber)) {
                        throw new RuntimeException("Interpreter Error: Invalid MODL version: " + versionString);
                    }
                    if (!versionString.equals(String.valueOf(ModlObjectCreator.MODL_VERSION))) {
                        versionNumberIsWrong = true;
                    }
                    if (i == 0) continue;
                    throw new RuntimeException("Interpreter Error: MODL version should be on the first line if specified.");
                }
                if (rawStructure instanceof ModlObject.Pair && ((ModlObject.Pair)rawStructure).getKey() != null && ((ModlObject.Pair)rawStructure).getKey().string != null && (((ModlObject.Pair)rawStructure).getKey().string.toLowerCase().equals("*l") || ((ModlObject.Pair)rawStructure).getKey().string.toLowerCase().equals("*load"))) {
                    this.addToUpperCaseInstructions(((ModlObject.Pair)rawStructure).getKey().string, "Interpreter Error: Cannot load multiple files after *LOAD instruction");
                    if (((ModlObject.Pair)rawStructure).getModlValue() instanceof ModlObject.String) {
                        importFileValue = ((ModlObject.String)((ModlObject.Pair)rawStructure).getModlValue()).string;
                        loadedRawModlObject = this.loadConfigFile(importFileValue);
                        needRestart = true;
                        break;
                    }
                    if (!(((ModlObject.Pair)rawStructure).getModlValue() instanceof ModlObject.Number)) continue;
                    importFileValue = ((ModlObject.Number)((ModlObject.Pair)rawStructure).getModlValue()).number;
                    loadedRawModlObject = this.loadConfigFile(importFileValue);
                    needRestart = true;
                    break;
                }
                if (rawStructure instanceof ModlObject.Pair && ((ModlObject.Pair)rawStructure).getKey() != null && ((ModlObject.Pair)rawStructure).getKey().string != null && (((ModlObject.Pair)rawStructure).getKey().string.toLowerCase().equals("*class") || ((ModlObject.Pair)rawStructure).getKey().string.toLowerCase().equals("*c") || ((ModlObject.Pair)rawStructure).getKey().string.toLowerCase().equals("*m") || ((ModlObject.Pair)rawStructure).getKey().string.toLowerCase().equals("*method") || ((ModlObject.Pair)rawStructure).getKey().string.toLowerCase().equals("?"))) {
                    ModlObject.Pair pair = (ModlObject.Pair)rawStructure;
                    if (pair.getKey().string.toLowerCase().equals("*class") || pair.getKey().string.toLowerCase().equals("*c")) {
                        this.addToUpperCaseInstructions(pair.getKey().string, "Interpreter Error: Already defined %s as final.");
                        ModlClassLoader.loadClass(rawStructure, this.klasses, this);
                        continue;
                    }
                    if (pair.getKey().string.toLowerCase().equals("*method") || pair.getKey().string.toLowerCase().equals("*m")) {
                        this.addToUpperCaseInstructions(pair.getKey().string, "Interpreter Error: Already defined %s as final.");
                        VariableMethodLoader.loadVariableMethod(this.methodList, pair, this);
                        continue;
                    }
                    if (pair.getKey().string.equals("?")) {
                        VariableLoader.loadConfigNumberedVariables(pair.getModlValue(), this.numberedVariables);
                    } else if (pair.getKey().string.startsWith("_")) {
                        VariableLoader.loadConfigVar(pair.getKey().string.replaceFirst("_", ""), pair, this.variables);
                    } else if (pair.getKey().string.startsWith("*")) {
                        throw new RuntimeException("Interpreter Error: Invalid keyword: " + pair.getKey());
                    }
                } else if (!(rawStructure instanceof ModlObject.Pair) || ((ModlObject.Pair)rawStructure).getKey() == null || ((ModlObject.Pair)rawStructure).getKey().string == null || !((ModlObject.Pair)rawStructure).getKey().string.toLowerCase().equals("*v") && !((ModlObject.Pair)rawStructure).getKey().string.toLowerCase().equals("*version") ? rawStructure instanceof ModlObject.Pair && ((ModlObject.Pair)rawStructure).getKey() != null && ((ModlObject.Pair)rawStructure).getKey().string != null && ((ModlObject.Pair)rawStructure).getKey().string.startsWith("*") : rawStructure instanceof ModlObject.Pair && ((ModlObject.Pair)rawStructure).getKey() != null && ((ModlObject.Pair)rawStructure).getKey().string != null && ((ModlObject.Pair)rawStructure).getKey().string.startsWith("*")) {
                    throw new RuntimeException("Interpreter Error: Invalid keyword: " + ((ModlObject.Pair)rawStructure).getKey().string);
                }
                if ((structures = this.interpret(modlObject, rawStructure)) != null) {
                    for (ModlObject.Structure structure : structures) {
                        modlObject.addStructure(structure);
                    }
                }
                ++i;
            }
            if (needRestart) {
                rawModlObject.replaceFirstImport(importFileValue, loadedRawModlObject);
                throw new RequireRestart();
            }
            HashSet<String> keys = new HashSet<String>();
            HashSet<ModlObject.Structure> newStructures = new HashSet<ModlObject.Structure>();
            ModlObject.Map adopter = new ModlObject.Map();
            for (ModlObject.Structure structure : modlObject.getStructures()) {
                if (structure.isPair()) {
                    ModlObject.Pair pair = (ModlObject.Pair)structure;
                    adopter.addPair(pair);
                    String keyStr = pair.getKey().string;
                    if (keys.contains(keyStr)) {
                        throw new RuntimeException("Duplicate top-level keys are not allowed.");
                    }
                    keys.add(keyStr);
                    continue;
                }
                newStructures.add(structure);
            }
            if (adopter.getPairs().size() > 1 && newStructures.isEmpty()) {
                modlObject.getStructures().clear();
                modlObject.getStructures().add(adopter);
            } else if (adopter.getPairs().isEmpty() && !newStructures.isEmpty()) {
                modlObject.getStructures().clear();
                modlObject.getStructures().addAll(newStructures);
            } else if (adopter.getPairs().size() != 1 && (adopter.getPairs().size() != 0 || newStructures.size() != 0)) {
                throw new RuntimeException("Mixed top-level types are not allowed.");
            }
            return modlObject;
        }
        catch (Exception e) {
            if (versionNumberIsWrong) {
                RuntimeException exception = new RuntimeException(e.getMessage() + " - MODL Version 1 interpreter cannot process this MODL Version " + versionString + " file.", e);
                throw exception;
            }
            throw e;
        }
    }

    void addToUpperCaseInstructions(String instruction, String errorFormat) {
        if (this.uppercaseInstructions.contains(instruction.toUpperCase())) {
            throw new RuntimeException(String.format(errorFormat, instruction));
        }
        if (instruction.toUpperCase().equals(instruction)) {
            this.uppercaseInstructions.add(instruction);
        }
    }

    private RawModlObject loadConfigFile(String location) {
        ModlValue value = this.transformString(location);
        if (!(value instanceof ModlObject.String)) {
            throw new RuntimeException("Was expecting String for location, but got " + value.getClass());
        }
        location = ((ModlObject.String)value).string;
        return FileLoader.loadFile(this.loadedFiles, StringEscapeReplacer.replace(location));
    }

    private List<ModlObject.Structure> interpret(ModlObject modlObject, ModlObject.Structure rawStructure) {
        if (rawStructure == null) {
            return null;
        }
        LinkedList<ModlObject.Structure> structures = new LinkedList();
        if (!(rawStructure instanceof RawModlObject.TopLevelConditional)) {
            ModlObject.Pair pair;
            ModlObject.Structure structure;
            if (rawStructure instanceof ModlObject.Map && (structure = this.interpret(modlObject, (ModlObject.Map)rawStructure, null)) != null) {
                structures.add(structure);
            }
            if (rawStructure instanceof ModlObject.Array && (structure = this.interpret(modlObject, (ModlObject.Array)rawStructure, null)) != null) {
                structures.add(structure);
            }
            if (rawStructure instanceof ModlObject.Pair && (pair = (ModlObject.Pair)(structure = this.interpret(modlObject, (ModlObject.Pair)rawStructure, null))) != null && pair.getKey() != null && pair.getKey().string != null && !pair.getKey().string.startsWith("_") && !pair.getKey().string.startsWith("*") && !pair.getKey().string.equals("?")) {
                structures.add(pair);
            }
        } else {
            structures = this.interpret(modlObject, (RawModlObject.TopLevelConditional)rawStructure);
        }
        return structures;
    }

    private ModlObject.Pair interpret(ModlObject modlObject, ModlObject.Pair rawPair, Object parentPair) {
        return this.interpret(modlObject, rawPair, parentPair, true);
    }

    private ModlObject.Pair interpret(ModlObject modlObject, ModlObject.Pair rawPair, Object parentPair, boolean addToValuePairs) {
        if (rawPair == null) {
            return null;
        }
        if (rawPair.getKey() != null && rawPair.getKey().string != null) {
            if (rawPair.getKey().string.equals("?")) {
                this.numberedVariables = new LinkedHashMap<Integer, ModlValue>();
                VariableLoader.loadConfigNumberedVariables(rawPair.getModlValue(), this.numberedVariables);
                return null;
            }
            if (rawPair.getKey().string.contains("%") || rawPair.getKey().string.contains("`.")) {
                StringTransformer stringTransformer = new StringTransformer(this.valuePairs, this.variables, this.numberedVariables);
                ModlValue result = stringTransformer.transformString(rawPair.getKey().string);
                String newString = result.toString();
                if (newString.matches("^[0-9]*$")) {
                    throw new RuntimeException("Pair name " + rawPair.getKey().string + " is illegal");
                }
                rawPair.setKey(new ModlObject.String(newString));
            }
        }
        if (rawPair.getKey() == null) {
            return null;
        }
        String originalKey = rawPair.getKey().string;
        if (originalKey == null) {
            throw new RuntimeException("Interpreter Error: Invalid key - 'null'");
        }
        String newKey = originalKey;
        if (this.haveModlClass(originalKey)) {
            newKey = this.transformKey(originalKey);
            rawPair = this.transformValue(rawPair);
        }
        if (newKey != null) {
            Interpreter.validatePairKey(newKey);
            if (newKey.toUpperCase().equals(newKey) && this.pairNames.contains(newKey) && addToValuePairs) {
                throw new RuntimeException("Interpreter Error: Already defined " + newKey + " as final.");
            }
        }
        if (!this.pairNames.contains("_" + newKey) && newKey != null) {
            if (parentPair == null && !newKey.startsWith("%") && addToValuePairs) {
                this.pairNames.add(newKey);
            }
            this.transformPairKey(modlObject, rawPair, newKey, parentPair);
        }
        ModlObject.Pair pair = new ModlObject.Pair();
        if (newKey.startsWith("*")) {
            pair.setKey(new ModlObject.String(newKey));
            if (pair.getModlValue() instanceof ModlObject.Array) {
                for (ModlValue value : ((ModlObject.Array)rawPair.getModlValue()).getValues()) {
                    this.addValueFromPair(modlObject, rawPair, parentPair, pair, value);
                }
            } else {
                this.addValueFromPair(modlObject, rawPair, parentPair, pair, rawPair.getModlValue());
            }
            if (newKey.toLowerCase().equals("*l") || newKey.toLowerCase().equals("*load")) {
                this.addToUpperCaseInstructions(newKey, "Cannot load multiple files after *LOAD instruction");
                String importFileValue = null;
                RawModlObject loadedRawModlObject = null;
                if (pair.getModlValue() instanceof ModlObject.String) {
                    importFileValue = ((ModlObject.String)pair.getModlValue()).string;
                    loadedRawModlObject = this.loadConfigFile(importFileValue);
                    return this.makePairFromLoadedFile(loadedRawModlObject);
                }
                if (pair.getModlValue() instanceof ModlObject.Number) {
                    importFileValue = ((ModlObject.Number)pair.getModlValue()).number;
                    loadedRawModlObject = this.loadConfigFile(importFileValue);
                    return this.makePairFromLoadedFile(loadedRawModlObject);
                }
            }
            return null;
        }
        if (newKey != null && (newKey.startsWith("_") || newKey.equals("?"))) {
            return null;
        }
        if (this.haveModlClass(originalKey)) {
            if (rawPair.getModlValue() instanceof ModlObject.Array && this.hasAssignStatementWhereAllEntriesAreClassesWithAssigns(0, originalKey)) {
                ModlObject.Array rawArray = (ModlObject.Array)rawPair.getModlValue();
                Map<String, Object> rootClass = this.klasses.get(originalKey);
                if (rootClass != null) {
                    pair.setKey(new ModlObject.String(newKey));
                    ModlObject.Array array = new ModlObject.Array();
                    pair.addModlValue(array);
                    int size = rawArray.getValues().size();
                    String key = "*params" + size;
                    Object classNamesForArrayObject = rootClass.get(key);
                    if (classNamesForArrayObject == null) {
                        classNamesForArrayObject = rootClass.get("*params1");
                    }
                    if (classNamesForArrayObject instanceof List) {
                        String repeatedClassName;
                        List classNamesForArray = (List)classNamesForArrayObject;
                        if (classNamesForArray.size() == 1 && (repeatedClassName = ((ModlObject.String)classNamesForArray.get((int)0)).string).endsWith("*")) {
                            classNamesForArray.clear();
                            for (int i = 0; i < size; ++i) {
                                classNamesForArray.add(new ModlObject.String(repeatedClassName.substring(0, repeatedClassName.length() - 1)));
                            }
                        }
                        if (classNamesForArray.size() != size) {
                            throw new InterpreterError("Length of '" + classNamesForArray + "' does not match length of '" + rawArray.getValues() + "'");
                        }
                        for (int i = 0; i < size; ++i) {
                            ModlValue originalArrayItem = rawArray.getValues().get(i);
                            ModlObject.String targetClassName = (ModlObject.String)classNamesForArray.get(i);
                            if (originalArrayItem instanceof ModlObject.Array) {
                                List<ModlValue> originalArrayItemValues = ((ModlObject.Array)originalArrayItem).getValues();
                                int paramsSize = originalArrayItemValues.size();
                                Map<String, Object> targetClassMap = this.klasses.get(targetClassName.string);
                                List list = (List)targetClassMap.get("*params" + paramsSize);
                                if (list != null) {
                                    ModlObject.Map targetObjectMap = new ModlObject.Map();
                                    int j = 0;
                                    for (ModlObject.String param : list) {
                                        ModlValue itemValue = originalArrayItemValues.get(j);
                                        if (itemValue instanceof ModlObject.String) {
                                            itemValue = this.transformString(((ModlObject.String)itemValue).string);
                                        }
                                        ModlObject.Pair newPair = new ModlObject.Pair(param, itemValue);
                                        newKey = this.transformKey(param.string);
                                        newPair = this.transformValue(newPair);
                                        newPair.setKey(new ModlObject.String(newKey));
                                        targetObjectMap.addPair(newPair);
                                        ++j;
                                    }
                                    array.addValue(targetObjectMap);
                                    continue;
                                }
                                if (originalArrayItem instanceof ModlObject.Array || targetClassMap.get("*superclass").equals("arr")) {
                                    ModlObject.String name = null;
                                    Object possibleName = targetClassMap.get("*name");
                                    if (possibleName != null) {
                                        if (possibleName instanceof String) {
                                            name = new ModlObject.String((String)possibleName);
                                        } else if (possibleName instanceof ModlObject.String) {
                                            name = (ModlObject.String)possibleName;
                                        }
                                    } else {
                                        name = targetClassName;
                                    }
                                    array.addValue(new ModlObject.Pair(name, originalArrayItem));
                                    continue;
                                }
                                throw new InterpreterError("No *assign value of length " + paramsSize + " for class " + targetClassName);
                            }
                            ModlObject.Pair tmpPair = new ModlObject.Pair(targetClassName, originalArrayItem);
                            ModlObject.Pair value = this.interpret(modlObject, tmpPair, null);
                            if (value == null) continue;
                            for (ModlValue modlValue : ((ModlValue)value).getModlValues()) {
                                array.addValue(modlValue);
                            }
                        }
                        return pair;
                    }
                    throw new InterpreterError("Invalid *assign for *class '" + originalKey + "'");
                }
            } else if (this.generateModlClassObject(modlObject, rawPair, pair, originalKey, newKey, parentPair)) {
                return pair;
            }
        }
        pair.setKey(new ModlObject.String(newKey));
        if (pair.getModlValue() instanceof ModlObject.Array) {
            for (ModlValue value : ((ModlObject.Array)rawPair.getModlValue()).getValues()) {
                this.addValueFromPair(modlObject, rawPair, parentPair, pair, value);
            }
        } else {
            this.addValueFromPair(modlObject, rawPair, parentPair, pair, rawPair.getModlValue());
        }
        return pair;
    }

    private ModlObject.Pair makePairFromLoadedFile(ModlObject rawModlObject) {
        ModlObject.Structure structure;
        List<ModlObject.Structure> structures = rawModlObject.getStructures();
        if (structures != null && structures.size() > 0 && structures.size() == 1 && (structure = structures.get(0)) instanceof ModlObject.Pair) {
            ModlObject.Pair pair = (ModlObject.Pair)structure;
            String key = pair.getKey().string;
            if (key.startsWith("_")) {
                this.valuePairs.put(key.substring(1), pair.getModlValue());
                return null;
            }
            this.valuePairs.put(key, pair.getModlValue());
            return pair;
        }
        return null;
    }

    private void addValueFromPair(ModlObject modlObject, ModlObject.Pair rawPair, Object parentPair, ModlObject.Pair pair, ModlValue value) {
        if (value instanceof ModlObject.Pair && ((ModlObject.Pair)value).getKey().string.startsWith("%")) {
            String key = ((ModlObject.Pair)value).getKey().string;
            ModlValue newValue = null;
            if (this.pairNames.contains(key.replaceFirst("%", "_"))) {
                ModlValue storedValue = this.valuePairs.get(key.replaceFirst("%", ""));
                if (storedValue instanceof ModlObject.Map) {
                    pair.addModlValue(rawPair.getModlValue());
                    return;
                }
                if (storedValue instanceof ModlObject.Array) {
                    List<ModlValue> list = ((ModlObject.Array)storedValue).getValues();
                    int index = ((ModlObject.Pair)value).getModlValue() instanceof ModlObject.Number ? Integer.valueOf(((ModlObject.Number)((ModlObject.Pair)value).getModlValue()).number).intValue() : Integer.valueOf(((ModlObject.Number)((ModlObject.Pair)value).getModlValue().get((Integer)Integer.valueOf((int)0))).number).intValue();
                    newValue = list.get(index);
                }
            } else {
                newValue = this.transformString(((ModlObject.Pair)value).getKey().string);
            }
            pair.addModlValue(newValue);
        } else {
            pair.addModlValue(this.interpret(modlObject, value, parentPair));
        }
    }

    private boolean generateModlClassObject(ModlObject modlObject, ModlObject.Pair rawPair, ModlObject.Pair pair, String originalKey, String newKey, Object parentPair) {
        boolean hasParams;
        pair.setKey(new ModlObject.String(newKey));
        int numParams = 0;
        if (rawPair.getModlValue() != null && (rawPair.getModlValue() instanceof ModlObject.Array || rawPair.getModlValue() == null || !(rawPair.getModlValue() instanceof ModlObject.Map))) {
            numParams = rawPair.getModlValue() instanceof ModlObject.Array ? ((ModlObject.Array)rawPair.getModlValue()).getValues().size() : 1;
        }
        numParams = this.getNumParams(rawPair, numParams);
        String paramsKeyString = "*params" + numParams;
        Object obj = this.findParamsObject(rawPair, paramsKeyString);
        if (obj == null && rawPair.getModlValue() instanceof ModlObject.Array && this.hasAssignStatement(1, originalKey)) {
            throw new RuntimeException("Interpreter Error: No key list of the correct length in class t - looking for one of length " + numParams);
        }
        boolean bl = hasParams = obj != null;
        if (this.anyClassContainsPairs(1, originalKey) || this.mapPairAlready(rawPair) || hasParams) {
            pair.setKey(new ModlObject.String(newKey));
            List<Object> pairs = null;
            boolean wasArray = false;
            if (rawPair.getModlValue() instanceof ModlObject.Array) {
                try {
                    pairs = this.getPairsFromArray(modlObject, (ModlObject.Array)rawPair.getModlValue(), parentPair);
                    if (pairs.size() > 0) {
                        wasArray = true;
                    } else {
                        pairs = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.mapPairAlready(rawPair)) {
                pairs = new LinkedList();
                this.addMapItemsToPair(modlObject, ((ModlObject.Map)rawPair.getModlValue()).getPairs(), pairs, parentPair);
            }
            if (pairs != null) {
                this.makeNewMapPair(pair, pairs, wasArray);
            }
            if (!(rawPair.getModlValue() instanceof ModlObject.Pair) && !(rawPair.getModlValue() instanceof ModlObject.Map)) {
                if (!hasParams) {
                    ModlValue value = this.interpret(modlObject, rawPair.getModlValue(), parentPair);
                    pair.addModlValue(value);
                } else {
                    int paramNum = 0;
                    List params = (List)obj;
                    String currentClass = null;
                    LinkedList<ModlValue> values = new LinkedList<ModlValue>();
                    ModlValue pairVal = rawPair.getModlValue();
                    if (pairVal instanceof ModlObject.Array) {
                        for (ModlValue vl : ((ModlObject.Array)pairVal).getValues()) {
                            if (vl instanceof RawModlObject.ArrayConditional) {
                                List<ModlValue> vs = this.interpret(modlObject, (RawModlObject.ArrayConditional)vl, parentPair);
                                if (vs == null) continue;
                                values.addAll(vs);
                                continue;
                            }
                            values.add(vl);
                        }
                    } else {
                        values.add(pairVal);
                    }
                    for (ModlValue valueItem : values) {
                        if (params.get(paramNum) instanceof ModlObject.String) {
                            currentClass = ((ModlObject.String)params.get((int)paramNum)).string;
                        }
                        if (valueItem instanceof ModlObject.Array) {
                            Map<String, Object> modlClassObj = this.getModlClass(currentClass);
                            if (modlClassObj == null) {
                                this.addNewClassParamValue(modlObject, pair, parentPair, currentClass, valueItem);
                            } else {
                                int innerParamNum = 0;
                                ModlObject.Pair innerPair = new ModlObject.Pair();
                                ModlObject.Pair valuePair = new ModlObject.Pair();
                                String fullClassName = currentClass;
                                try {
                                    String nameString = ((ModlObject.String)this.getModlClass((String)currentClass).get((Object)"*name")).string;
                                    if (nameString == null) {
                                        nameString = ((ModlObject.String)this.getModlClass((String)currentClass).get((Object)"*n")).string;
                                    }
                                    fullClassName = nameString;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                valuePair.setKey(new ModlObject.String(fullClassName));
                                for (ModlValue vi : ((ModlObject.Array)valueItem).getValues()) {
                                    Map<String, Object> modlClassMap = this.getModlClass(currentClass);
                                    String superclass = (String)modlClassMap.get("*superclass");
                                    if (superclass.equals("arr")) {
                                        ModlValue v = this.interpret(modlObject, vi, parentPair);
                                        ModlObject.Array array = (ModlObject.Array)valuePair.getModlValue();
                                        if (array == null) {
                                            array = new ModlObject.Array();
                                            valuePair.addModlValue(array);
                                        }
                                        array.addValue(v);
                                        continue;
                                    }
                                    if (superclass.equals("map")) {
                                        ModlObject.String innerClassName = (ModlObject.String)((LinkedList)((LinkedHashMap)modlClassObj).get(paramsKeyString)).get(innerParamNum++);
                                        ModlObject.Pair newRawPair = new ModlObject.Pair();
                                        newRawPair.setKey(innerClassName);
                                        newRawPair.addModlValue(vi);
                                        ModlObject.Pair v = this.interpret(modlObject, newRawPair, parentPair);
                                        valuePair.addModlValue(v);
                                        innerPair.addModlValue(valuePair);
                                        continue;
                                    }
                                    throw new RuntimeException("Superclass " + superclass + " of " + fullClassName + " is not known!");
                                }
                                pair.addModlValue(valuePair);
                            }
                        } else {
                            this.addNewClassParamValue(modlObject, pair, parentPair, currentClass, valueItem);
                        }
                        ++paramNum;
                    }
                }
                this.addAllParentPairs(modlObject, pair, originalKey);
                return true;
            }
            this.addAllParentPairs(modlObject, pair, originalKey);
            return true;
        }
        return false;
    }

    private Object findParamsObject(ModlObject.Pair rawPair, String paramsKeyString) {
        Map<String, Object> klass = this.getModlClass(rawPair.getKey().string);
        Object result = klass.get(paramsKeyString);
        if (result == null) {
            String superclass = (String)klass.get("*superclass");
            while (superclass != null) {
                Map<String, Object> sk = this.getModlClass(superclass);
                if (sk != null) {
                    result = sk.get(paramsKeyString);
                    if (result != null) break;
                    superclass = (String)sk.get("*superclass");
                    continue;
                }
                superclass = null;
            }
        }
        return result;
    }

    private void addNewClassParamValue(ModlObject modlObject, ModlObject.Pair pair, Object parentPair, String currentClass, ModlValue valueItem) {
        Object nameObject;
        ModlValue newValue = this.interpret(modlObject, valueItem, parentPair);
        ModlObject.Pair valuePair = new ModlObject.Pair();
        String fullClassName = currentClass;
        Map<String, Object> aClass = this.getModlClass(currentClass);
        if (aClass != null && (nameObject = aClass.get("*name")) instanceof ModlObject.String) {
            fullClassName = ((ModlObject.String)nameObject).string;
        }
        valuePair.setKey(new ModlObject.String(fullClassName));
        String classType = null;
        if (aClass != null) {
            classType = this.getSuperclassPrimitive((String)aClass.get("*superclass"));
        }
        if ("str".equals(classType)) {
            valuePair.addModlValue(this.makeValueString(newValue));
        } else if ("num".equals(classType)) {
            valuePair.addModlValue(this.makeValueNumber(newValue));
        } else if ("arr".equals(classType)) {
            valuePair.addModlValue(this.makeValueArray(newValue));
        } else if ("mao".equals(classType)) {
            valuePair.addModlValue(this.makeValueMap(newValue));
        } else {
            valuePair.addModlValue(newValue);
        }
        pair.addModlValue(valuePair);
    }

    private int getNumParams(ModlObject.Pair originalPair, int numParams) {
        if (originalPair.getModlValue() instanceof ModlObject.Map) {
            numParams = ((ModlObject.Map)originalPair.getModlValue()).getPairs().size();
        } else if (originalPair.getModlValue() instanceof ModlObject.Array) {
            numParams = ((ModlObject.Array)originalPair.getModlValue()).getValues().size();
        } else if (originalPair.getModlValue() != null) {
            numParams = 1;
        }
        return numParams;
    }

    private ModlValue transformPairKey(ModlObject rawModlObject, ModlObject.Pair originalPair, String newKey, Object parentPair) {
        String transformedKey = newKey;
        if (transformedKey.startsWith("_")) {
            transformedKey = transformedKey.replaceFirst("_", "");
        }
        if (parentPair == null) {
            if (newKey.startsWith("_")) {
                if (originalPair.getModlValue() instanceof ModlObject.Map) {
                    LinkedHashMap newMap = new LinkedHashMap();
                    this.interpret(rawModlObject, (ModlObject.Map)originalPair.getModlValue(), newMap);
                }
                if (originalPair.getModlValue() instanceof ModlObject.Array) {
                    LinkedList newList = new LinkedList();
                    this.interpret(rawModlObject, (ModlObject.Array)originalPair.getModlValue(), newList);
                }
            }
            if (originalPair.getModlValue() instanceof ModlObject.String) {
                ModlValue transformedValue = this.transformString(((ModlObject.String)originalPair.getModlValue()).string);
                this.valuePairs.put(transformedKey, transformedValue);
                return transformedValue;
            }
            this.valuePairs.put(transformedKey, originalPair.getModlValue());
            return originalPair.getModlValue();
        }
        if (parentPair instanceof Map) {
            String str = this.getStringFromValue(originalPair);
            Map theMap = (Map)parentPair;
            theMap.put(transformedKey, str);
        } else if (parentPair instanceof List) {
            String str = this.getStringFromValue(originalPair);
            List theList = (List)parentPair;
            theList.add(str);
        } else {
            throw new RuntimeException("Expecting Map or Array as parentPair!");
        }
        return originalPair.getModlValue();
    }

    private String getStringFromValue(ModlObject.Pair originalPair) {
        String str = null;
        ModlValue v = originalPair.getModlValue();
        if (v instanceof ModlObject.Array) {
            v = v.get(0);
        }
        if (v instanceof ModlObject.String) {
            str = ((ModlObject.String)v).string;
        }
        if (v instanceof ModlObject.Number) {
            str = ((ModlObject.Number)v).number;
        }
        return str;
    }

    private void makeNewMapPair(ModlObject.Pair pair, List<ModlObject.Pair> rawPairs, boolean wasArray) {
        for (ModlObject.Pair originalMapPair : rawPairs) {
            if (originalMapPair == null) continue;
            if (wasArray) {
                if (originalMapPair.getKey().string.startsWith("_")) continue;
                ModlObject.Pair value = originalMapPair;
                pair.addModlValue(value);
                continue;
            }
            if (originalMapPair.getKey().string.startsWith("_")) continue;
            boolean knownItem = false;
            ModlObject.Map map = null;
            if (pair.getModlValue() != null) {
                map = (ModlObject.Map)pair.getModlValue();
            }
            if (map == null) {
                map = new ModlObject.Map();
                pair.addModlValue(map);
            }
            if (map.get(originalMapPair.getKey()) != null) {
                knownItem = true;
            }
            if (knownItem) continue;
            map.addPair(originalMapPair);
        }
    }

    private ModlObject.Array makeValueArray(ModlValue value) {
        if (value == null) {
            return null;
        }
        if (value instanceof ModlObject.Map) {
            throw new RuntimeException("Interpreter Error: Cannot convert map to array: " + value.toString());
        }
        ModlObject.Array result = new ModlObject.Array();
        result.addValue(value);
        return result;
    }

    private ModlObject.Map makeValueMap(ModlValue value) {
        if (value == null) {
            return null;
        }
        if (value instanceof ModlObject.Array) {
            throw new RuntimeException("Interpreter Error: Cannot convert array to map: " + value.toString());
        }
        ModlObject.Map result = new ModlObject.Map();
        result.addPair(new ModlObject.Pair(new ModlObject.String("value"), value));
        return result;
    }

    private ModlObject.Number makeValueNumber(ModlValue value) {
        if (value == null) {
            throw new RuntimeException("Interpreter Error: Cannot convert null to a num.");
        }
        String newNumber = null;
        if (value instanceof ModlObject.String) {
            newNumber = Float.toString(Float.parseFloat(((ModlObject.String)value).string));
        }
        if (value instanceof ModlObject.Number) {
            newNumber = ((ModlObject.Number)value).number;
        }
        if (value instanceof ModlObject.True) {
            newNumber = "1";
        }
        if (value instanceof ModlObject.False) {
            newNumber = "0";
        }
        if (value instanceof ModlObject.Null) {
            newNumber = null;
        }
        if (newNumber == null) {
            throw new RuntimeException("Interpreter Error: Cannot convert null to a num.");
        }
        return new ModlObject.Number(newNumber);
    }

    private ModlObject.String makeValueString(ModlValue value) {
        if (value == null) {
            throw new RuntimeException("Interpreter Error: Cannot convert null value to string.");
        }
        String newString = null;
        if (value instanceof ModlObject.String) {
            newString = ((ModlObject.String)value).string;
        }
        if (value instanceof ModlObject.Number) {
            newString = ((ModlObject.Number)value).number;
        }
        if (value instanceof ModlObject.True) {
            newString = "true";
        }
        if (value instanceof ModlObject.False) {
            newString = "false";
        }
        if (value instanceof ModlObject.Null) {
            newString = null;
        }
        if (newString == null) {
            throw new RuntimeException("Interpreter Error: Cannot convert null value to string.");
        }
        return new ModlObject.String(newString);
    }

    private void addMapItemsToPair(ModlObject modlObject, List<ModlObject.Pair> mapItems, List<ModlObject.Pair> pairs, Object parentPair) {
        if (mapItems == null) {
            return;
        }
        for (ModlObject.Pair mapItem : mapItems) {
            if (mapItem instanceof RawModlObject.MapConditional) {
                List<ModlObject.Pair> newPairs = this.interpret(modlObject, (RawModlObject.MapConditional)mapItem, parentPair);
                if (newPairs == null) continue;
                pairs.addAll(newPairs);
                continue;
            }
            if (mapItem == null) continue;
            pairs.add(this.interpret(modlObject, mapItem, parentPair, false));
        }
    }

    private ModlValue interpret(ModlObject modlObject, ModlValue rawValueItem, Object parentPair) {
        if (rawValueItem == null) {
            return null;
        }
        if (rawValueItem instanceof RawModlObject.ValueConditional) {
            return this.interpret(modlObject, (RawModlObject.ValueConditional)rawValueItem, parentPair);
        }
        if (!(rawValueItem instanceof ModlObject.Array)) {
            return this.interpretValue(modlObject, rawValueItem, parentPair);
        }
        ModlObject.Array array = new ModlObject.Array();
        for (ModlValue vi : ((ModlObject.Array)rawValueItem).getValues()) {
            if (vi instanceof RawModlObject.ArrayConditional) {
                List<ModlValue> newValues = this.interpret(modlObject, (RawModlObject.ArrayConditional)vi, parentPair);
                if (newValues == null) continue;
                for (ModlValue viNew : newValues) {
                    array.addValue(this.interpret(modlObject, viNew, parentPair));
                }
                continue;
            }
            array.addValue(this.interpret(modlObject, vi, parentPair));
        }
        return array;
    }

    private Map<String, Object> getModlClass(String key) {
        for (Map.Entry<String, Map<String, Object>> entry : this.klasses.entrySet()) {
            for (Map.Entry<String, Object> valueEntry : entry.getValue().entrySet()) {
                if (valueEntry.getValue() == null || !valueEntry.getKey().equals("*name") && !valueEntry.getKey().equals("*n") && !valueEntry.getKey().equals("*id") && !valueEntry.getKey().equals("*i") || !(valueEntry.getValue() instanceof String ? valueEntry.getValue().equals(key) : ((ModlObject.String)valueEntry.getValue()).string.equals(key))) continue;
                return entry.getValue();
            }
        }
        return this.klasses.get(key);
    }

    private boolean haveModlClass(String originalKey) {
        return this.getModlClass(originalKey) != null;
    }

    private List<ModlObject.Pair> getPairsFromArray(ModlObject modlObject, ModlObject.Array array, Object parentPair) {
        return this.getPairsFromArray(modlObject, array.getValues(), parentPair);
    }

    private List<ModlObject.Pair> getPairsFromArray(ModlObject modlObject, List<ModlValue> arrayItems, Object parentPair) {
        LinkedList<ModlObject.Pair> pairs = new LinkedList<ModlObject.Pair>();
        if (arrayItems != null) {
            for (ModlValue arrayItem : arrayItems) {
                if (arrayItem instanceof RawModlObject.ArrayConditional) {
                    List<ModlValue> newArrayItems = this.interpret(modlObject, (RawModlObject.ArrayConditional)arrayItem, parentPair);
                    if (newArrayItems == null) continue;
                    for (ModlValue v : newArrayItems) {
                        if (!(v instanceof ModlObject.Pair)) continue;
                        pairs.add((ModlObject.Pair)v);
                    }
                    continue;
                }
                if (!(arrayItem instanceof ModlObject.Pair)) continue;
                pairs.add(this.interpret(modlObject, (ModlObject.Pair)arrayItem, parentPair));
            }
        }
        return pairs;
    }

    private void addAllParentPairs(ModlObject modlObject, ModlObject.Pair pair, String originalKey) {
        Map<String, Object> klass = this.getModlClass(originalKey);
        if (klass != null) {
            for (Map.Entry<String, Object> entry : klass.entrySet()) {
                if (entry.getKey().startsWith("_") || entry.getKey().startsWith("*") && !entry.getKey().equals("?") || this.pairHasKey(pair, entry.getKey())) continue;
                ModlObject.Pair newPair = new ModlObject.Pair();
                newPair.setKey(new ModlObject.String(entry.getKey()));
                newPair.addModlValue(this.interpret(modlObject, (ModlValue)entry.getValue(), null));
                if (pair.getModlValue() != null && pair.getModlValue() instanceof ModlObject.Map) {
                    ((ModlObject.Map)pair.getModlValue()).addPair(newPair);
                    continue;
                }
                pair.addModlValue(newPair);
            }
            this.addAllParentPairs(modlObject, pair, (String)klass.get("*superclass"));
        }
    }

    private boolean pairHasKey(ModlObject.Pair pair, String key) {
        if (pair.getModlValue() == null) {
            return false;
        }
        if (pair.getModlValue() instanceof ModlObject.Pair) {
            return key.equals(((ModlObject.Pair)pair.getModlValue()).getKey().string);
        }
        if (pair.getModlValue() instanceof ModlObject.Map) {
            return ((ModlObject.Map)pair.getModlValue()).get(new ModlObject.String(key)) != null;
        }
        return false;
    }

    private boolean mapPairAlready(ModlObject.Pair originalPair) {
        return originalPair.getModlValue() instanceof ModlObject.Map;
    }

    private boolean anyClassContainsPairs(int depth, String originalKey) {
        if (depth > 50) {
            throw new RuntimeException("Interpreter Error: Reached max class hierarchy depth: 50");
        }
        Map<String, Object> klass = this.getModlClass(originalKey);
        if (klass != null) {
            for (String key : klass.keySet()) {
                if (key.startsWith("_") || key.startsWith("*") || key.equals("?")) continue;
                return true;
            }
            String superclass = (String)klass.get("*superclass");
            if (superclass != null) {
                return this.anyClassContainsPairs(depth + 1, superclass);
            }
        }
        return false;
    }

    private boolean hasAssignStatement(int depth, String originalKey) {
        if (depth > 50) {
            throw new RuntimeException("Interpreter Error: Reached max class hierarchy depth: 50");
        }
        Map<String, Object> klass = this.getModlClass(originalKey);
        if (klass != null) {
            for (String k : klass.keySet()) {
                if (!k.startsWith("*params")) continue;
                return true;
            }
            String superclass = (String)klass.get("*superclass");
            if (superclass != null) {
                return this.hasAssignStatement(depth + 1, superclass);
            }
        }
        return false;
    }

    private boolean hasAssignStatementWhereAllEntriesAreClassesWithAssigns(int depth, String originalKey) {
        if (depth > 50) {
            throw new RuntimeException("Interpreter Error: Reached max class hierarchy depth: 50");
        }
        ArrayList<String> allParams = new ArrayList<String>();
        Map<String, Object> klass = this.getModlClass(originalKey);
        if (klass != null) {
            for (String k : klass.keySet()) {
                if (!k.startsWith("*params")) continue;
                List params = (List)klass.get(k);
                for (ModlObject.String param : params) {
                    if (param.string.endsWith("*")) {
                        allParams.add(param.string.substring(0, param.string.length() - 1));
                        continue;
                    }
                    allParams.add(param.string);
                }
            }
        }
        for (String param : allParams) {
            if (this.hasAssignStatement(0, param)) continue;
            return false;
        }
        return !allParams.isEmpty() && this.klasses.keySet().containsAll(allParams);
    }

    private String transformKey(String originalKey) {
        Map<String, Object> map = this.getModlClass(originalKey);
        if (map != null) {
            if (map.get("*name") != null && map.get("*name") instanceof ModlObject.String) {
                return ((ModlObject.String)map.get((Object)"*name")).string;
            }
            if (map.get("*n") != null && map.get("*n") instanceof ModlObject.String) {
                return ((ModlObject.String)map.get((Object)"*n")).string;
            }
        }
        return originalKey;
    }

    private ModlObject.Pair transformValue(ModlObject.Pair originalPair) {
        Map<String, Object> classMap = this.getModlClass(originalPair.getKey().string);
        if (classMap != null) {
            if (classMap.get("*name") != null && (classMap.get("*name").equals("_v") || classMap.get("*name").equals("var")) || classMap.get("*n") != null && (classMap.get("*n").equals("_v") || classMap.get("*n").equals("var"))) {
                VariableLoader.loadConfigNumberedVariables(originalPair.getModlValue(), this.numberedVariables);
            } else {
                Object nameOrId;
                String superclassName = (String)classMap.get("*superclass");
                boolean hasSuperclass = superclassName != null;
                Object object = nameOrId = classMap.get("*name") != null ? classMap.get("*name") : classMap.get("*id");
                if (!hasSuperclass && this.anyClassContainsPairs(1, nameOrId.toString())) {
                    classMap.put("*superclass", "map");
                } else {
                    if (!hasSuperclass && this.hasAssignStatement(0, (String)classMap.get("*id"))) {
                        if (originalPair.getModlValue() instanceof ModlObject.Array) {
                            classMap.put("*superclass", "arr");
                            return originalPair;
                        }
                        classMap.put("*superclass", "map");
                        ModlObject.Pair pair = new ModlObject.Pair();
                        pair.setKey(originalPair.getKey());
                        pair.addModlValue(originalPair.getModlValue());
                        return pair;
                    }
                    if (!hasSuperclass) {
                        if (originalPair.getModlValue() instanceof ModlObject.Number) {
                            classMap.put("*superclass", "num");
                        } else if (originalPair.getModlValue() instanceof ModlObject.String) {
                            classMap.put("*superclass", "str");
                        } else if (originalPair.getModlValue() instanceof ModlObject.Array) {
                            classMap.put("*superclass", "arr");
                        } else if (originalPair.getModlValue() instanceof ModlObject.True) {
                            classMap.put("*superclass", "bool");
                        } else if (originalPair.getModlValue() instanceof ModlObject.False) {
                            classMap.put("*superclass", "bool");
                        } else if (originalPair.getModlValue() instanceof ModlObject.Null) {
                            classMap.put("*superclass", "null");
                        } else if (originalPair.getModlValue() instanceof ModlObject.Map) {
                            classMap.put("*superclass", "map");
                        } else {
                            throw new RuntimeException("Interpreter Error: Unhandled object type: " + originalPair.getModlValue().getClass().getName());
                        }
                    }
                }
                String superclassString = classMap.get("*superclass") instanceof String ? (String)classMap.get("*superclass") : ((ModlObject.String)classMap.get((Object)"*superclass")).string;
                String mostSuperClass = this.getSuperclassPrimitive(superclassString);
                if (originalPair.getModlValue() == null) {
                    return originalPair;
                }
                ModlObject.Pair pair = new ModlObject.Pair();
                pair.setKey(originalPair.getKey());
                if ("str".equals(mostSuperClass)) {
                    if (originalPair.getModlValue() instanceof ModlObject.String) {
                        return originalPair;
                    }
                    ModlObject.String s = this.makeValueString(originalPair.getModlValue());
                    pair.addModlValue(s);
                    return pair;
                }
                if ("num".equals(mostSuperClass)) {
                    if (originalPair.getModlValue() instanceof ModlObject.Number) {
                        return originalPair;
                    }
                    try {
                        ModlObject.Number number = this.makeValueNumber(originalPair.getModlValue());
                        pair.addModlValue(number);
                    }
                    catch (Exception e) {
                        Object v = originalPair.getModlValue().getValue();
                        if (v == null) {
                            v = "";
                        }
                        throw new RuntimeException(String.format("Superclass of \"%s\" is num - cannot assign value \"%s\"", classMap.get("*id"), v));
                    }
                    return pair;
                }
                if ("bool".equals(mostSuperClass)) {
                    return originalPair;
                }
                if ("null".equals(mostSuperClass)) {
                    return originalPair;
                }
                if ("arr".equals(mostSuperClass)) {
                    if (originalPair.getModlValue() instanceof ModlObject.Array) {
                        return originalPair;
                    }
                    ModlObject.Array array = this.makeValueArray(originalPair.getModlValue());
                    pair.addModlValue(array);
                    return pair;
                }
                if ("map".equals(mostSuperClass)) {
                    if (originalPair.getModlValue() instanceof ModlObject.Map) {
                        return originalPair;
                    }
                    if (this.hasAssignStatement(0, (String)classMap.get("*id"))) {
                        return originalPair;
                    }
                    ModlObject.Map map = this.makeValueMap(originalPair.getModlValue());
                    pair.addModlValue(map);
                    return pair;
                }
                throw new RuntimeException("Interpreter Error: Invalid superclass: " + superclassString);
            }
        }
        return originalPair;
    }

    private String getSuperclassPrimitive(String originalSuperClass) {
        String currentSuperclass = originalSuperClass;
        while (!this.PRIMITIVES.contains(currentSuperclass)) {
            if ((currentSuperclass = this.getNextSuperclassUp(currentSuperclass)) != null) continue;
            return null;
        }
        if (this.PRIMITIVES.contains(currentSuperclass)) {
            return currentSuperclass;
        }
        return null;
    }

    private String getNextSuperclassUp(String currentSuperclass) {
        Map<String, Object> classMap = this.getModlClass(currentSuperclass);
        if (classMap != null) {
            if (classMap.get("*superclass") instanceof String) {
                return (String)classMap.get("*superclass");
            }
            return ((ModlObject.String)classMap.get((Object)"*superclass")).string;
        }
        return null;
    }

    private ModlValue interpretValue(ModlObject modlObject, ModlValue rawValue, Object parentPair) {
        if (rawValue == null) {
            return null;
        }
        if (rawValue instanceof ModlObject.Pair) {
            return this.interpret(modlObject, (ModlObject.Pair)rawValue, parentPair);
        }
        if (rawValue instanceof ModlObject.Map) {
            return this.interpret(modlObject, (ModlObject.Map)rawValue, parentPair);
        }
        if (rawValue instanceof ModlObject.Array) {
            return this.interpret(modlObject, (ModlObject.Array)rawValue, parentPair);
        }
        if (rawValue instanceof ModlObject.Number) {
            return this.interpret((ModlObject.Number)rawValue);
        }
        if (rawValue instanceof ModlObject.True) {
            return this.interpret((ModlObject.True)rawValue);
        }
        if (rawValue instanceof ModlObject.False) {
            return this.interpret((ModlObject.False)rawValue);
        }
        if (rawValue instanceof ModlObject.Null) {
            return this.interpret((ModlObject.Null)rawValue);
        }
        if (rawValue instanceof ModlObject.String) {
            return this.interpret((ModlObject.String)rawValue);
        }
        return null;
    }

    private ModlObject.Map interpret(ModlObject modlObject, ModlObject.Map originalMap, Object parentPair) {
        if (originalMap == null) {
            return null;
        }
        ModlObject.Map map = new ModlObject.Map();
        if (originalMap.getPairs() != null) {
            for (ModlObject.Pair originalMapItem : originalMap.getPairs()) {
                List<ModlObject.Pair> pairs = this.interpretMapPair(modlObject, originalMapItem, parentPair);
                if (pairs == null) continue;
                for (ModlObject.Pair pair : pairs) {
                    if (pair == null || pair.getKey().string.startsWith("_") || pair.getKey().string.startsWith("*") || pair.getKey().string.equals("?")) continue;
                    map.addPair(pair);
                }
            }
        }
        return map;
    }

    private List<ModlObject.Pair> interpretMapPair(ModlObject modlObject, ModlObject.Pair originalMapItem, Object parentPair) {
        ModlObject.Pair pair;
        if (originalMapItem == null) {
            return null;
        }
        LinkedList<ModlObject.Pair> pairs = new LinkedList();
        if (originalMapItem instanceof RawModlObject.MapConditional) {
            pairs = this.interpret(modlObject, (RawModlObject.MapConditional)originalMapItem, parentPair);
        }
        if ((pair = this.interpret(modlObject, originalMapItem, parentPair)) != null && !pair.getKey().string.startsWith("_")) {
            pairs.add(pair);
        }
        return pairs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ModlObject.Array interpret(ModlObject modlObject, ModlObject.Array rawArray, Object parentPair) {
        if (rawArray == null) {
            return null;
        }
        ModlObject.Array array = new ModlObject.Array();
        if (rawArray.getValues() == null) return array;
        Map<String, Object> rootClass = this.klasses.get("root");
        if (parentPair == null && rootClass != null) {
            String repeatedClassName;
            Object params1 = rootClass.get("*params1");
            if (!(params1 instanceof List)) throw new InterpreterError("Invalid *assign for *class 'root'");
            ModlObject.String classNameForRootArray = (ModlObject.String)((List)params1).get(0);
            Map<String, Object> classForRootArray = this.klasses.get(classNameForRootArray.string);
            int size = rawArray.getValues().size();
            String key = "*params" + size;
            Object classNamesForArrayObject = classForRootArray.get(key);
            if (classNamesForArrayObject == null) {
                classNamesForArrayObject = classForRootArray.get("*params1");
            }
            if (!(classNamesForArrayObject instanceof List)) throw new InterpreterError("Invalid *assign for *class '" + classNameForRootArray.string + "'");
            List classNamesForArray = (List)classNamesForArrayObject;
            if (classNamesForArray.size() == 1 && (repeatedClassName = ((ModlObject.String)classNamesForArray.get((int)0)).string).endsWith("*")) {
                classNamesForArray.clear();
                for (int i = 0; i < size; ++i) {
                    classNamesForArray.add(new ModlObject.String(repeatedClassName.substring(0, repeatedClassName.length() - 1)));
                }
            }
            if (classNamesForArray.size() != size) {
                throw new InterpreterError("Length of '" + classNamesForArray + "' does not match length of '" + rawArray.getValues() + "'");
            }
            for (int i = 0; i < size; ++i) {
                ModlValue originalArrayItem = rawArray.getValues().get(i);
                ModlObject.String targetClassName = (ModlObject.String)classNamesForArray.get(i);
                ModlObject.Pair tmpPair = new ModlObject.Pair(targetClassName, originalArrayItem);
                ModlObject.Pair value = this.interpret(modlObject, tmpPair, null);
                if (value == null) continue;
                for (ModlValue modlValue : ((ModlValue)value).getModlValues()) {
                    array.addValue(modlValue);
                }
            }
            return array;
        } else {
            for (ModlValue originalArrayItem : rawArray.getValues()) {
                ModlValue value = this.interpret(modlObject, originalArrayItem, parentPair);
                if (value == null) continue;
                array.addValue(value);
                if (parentPair == null) continue;
                List theList = (List)parentPair;
                theList.add(value);
            }
        }
        return array;
    }

    private List<ModlValue> interpretArrayItem(ModlObject modlObject, ModlValue rawArrayItem, Object parentPair) {
        if (rawArrayItem == null) {
            return null;
        }
        List<Object> values = new LinkedList();
        if (rawArrayItem instanceof RawModlObject.ArrayConditional) {
            values = this.interpret(modlObject, (RawModlObject.ArrayConditional)rawArrayItem, parentPair);
        } else {
            ModlValue value = this.interpret(modlObject, rawArrayItem, parentPair);
            values.add(value);
        }
        return values;
    }

    private ModlValue interpret(ModlObject modlObject, RawModlObject.ValueConditional originalConditional, Object parentPair) {
        if (originalConditional == null) {
            return null;
        }
        for (Map.Entry<RawModlObject.ConditionTest, RawModlObject.ValueConditionalReturn> originalConditionalEntry : originalConditional.getConditionals().entrySet()) {
            RawModlObject.ConditionTest conditionalTest = originalConditionalEntry.getKey();
            if (this.evaluates(conditionalTest)) {
                if (originalConditionalEntry.getValue() == null) {
                    return new ModlObject.True();
                }
                if (originalConditionalEntry.getValue().getValues().size() == 1) {
                    return this.interpret(modlObject, originalConditionalEntry.getValue().getValues().get(0), parentPair);
                }
                ModlObject.Array returnValue = new ModlObject.Array();
                for (ModlValue valueItem : originalConditionalEntry.getValue().getValues()) {
                    ModlValue v = this.interpret(modlObject, valueItem, parentPair);
                    returnValue.addValue(v);
                }
                return returnValue;
            }
            if (originalConditionalEntry.getValue() != null) continue;
            return new ModlObject.False();
        }
        return null;
    }

    private List<ModlValue> interpret(ModlObject modlObject, RawModlObject.ArrayConditional rawConditional, Object parentPair) {
        if (rawConditional == null) {
            return null;
        }
        if (rawConditional.getConditionals() != null) {
            for (Map.Entry<RawModlObject.ConditionTest, RawModlObject.ArrayConditionalReturn> originalConditionalEntry : rawConditional.getConditionals().entrySet()) {
                RawModlObject.ConditionTest conditionalTest = originalConditionalEntry.getKey();
                if (!this.evaluates(conditionalTest)) continue;
                LinkedList<ModlValue> returnValues = new LinkedList<ModlValue>();
                for (ModlValue arrayItem : originalConditionalEntry.getValue().getValues()) {
                    List<ModlValue> values = this.interpretArrayItem(modlObject, arrayItem, parentPair);
                    if (values == null) continue;
                    returnValues.addAll(values);
                }
                return returnValues;
            }
        }
        return null;
    }

    private List<ModlObject.Pair> interpret(ModlObject modlObject, RawModlObject.MapConditional originalConditional, Object parentPair) {
        if (originalConditional == null) {
            return null;
        }
        for (Map.Entry<RawModlObject.ConditionTest, ModlObject.Map> originalConditionalEntry : originalConditional.getConditionals().entrySet()) {
            RawModlObject.ConditionTest conditionalTest = originalConditionalEntry.getKey();
            if (!this.evaluates(conditionalTest)) continue;
            LinkedList<ModlObject.Pair> returnPairs = new LinkedList<ModlObject.Pair>();
            for (ModlObject.Pair mapItem : originalConditionalEntry.getValue().getPairs()) {
                List<ModlObject.Pair> mapItems = this.interpretMapPair(modlObject, mapItem, parentPair);
                if (mapItems == null) continue;
                returnPairs.addAll(mapItems);
            }
            return returnPairs;
        }
        return null;
    }

    private List<ModlObject.Structure> interpret(ModlObject modlObject, RawModlObject.TopLevelConditional originalConditional) {
        if (originalConditional == null) {
            return null;
        }
        for (Map.Entry<RawModlObject.ConditionTest, RawModlObject.TopLevelConditionalReturn> originalConditionalEntry : originalConditional.getConditionals().entrySet()) {
            RawModlObject.ConditionTest conditionalTest = originalConditionalEntry.getKey();
            if (!this.evaluates(conditionalTest)) continue;
            LinkedList<ModlObject.Structure> returnStructures = new LinkedList<ModlObject.Structure>();
            for (ModlObject.Structure rawStructure : originalConditionalEntry.getValue().getStructures()) {
                List<ModlObject.Structure> structures = this.interpret(modlObject, rawStructure);
                if (structures == null) continue;
                returnStructures.addAll(structures);
            }
            return returnStructures;
        }
        return null;
    }

    private boolean evaluates(RawModlObject.ConditionTest conditionalTest) {
        int nullCount = 0;
        LinkedList<Map.Entry<RawModlObject.SubCondition, MutablePair<String, Boolean>>> conditionalTestOrderedList = new LinkedList<Map.Entry<RawModlObject.SubCondition, MutablePair<String, Boolean>>>();
        for (Map.Entry<RawModlObject.SubCondition, MutablePair<String, Boolean>> conditionalTestEntry : conditionalTest.getSubConditionMap().entrySet()) {
            String string = (String)conditionalTestEntry.getValue().getLeft();
            if (string == null) {
                conditionalTestOrderedList.add(nullCount++, conditionalTestEntry);
                continue;
            }
            if (string.equals("|")) {
                conditionalTestOrderedList.add(conditionalTestEntry);
                continue;
            }
            if (!string.equals("&")) continue;
            conditionalTestOrderedList.add(nullCount, conditionalTestEntry);
        }
        boolean result = true;
        for (Map.Entry entry : conditionalTestOrderedList) {
            RawModlObject.SubCondition subCondition = (RawModlObject.SubCondition)entry.getKey();
            MutablePair conditionTestOperatorPair = (MutablePair)entry.getValue();
            String conditionTestOperator = (String)conditionTestOperatorPair.getLeft();
            Boolean shouldNegate = (Boolean)conditionTestOperatorPair.getRight();
            boolean subConditionReturn = true;
            if (subCondition instanceof RawModlObject.ConditionGroup) {
                subConditionReturn = this.evaluates((RawModlObject.ConditionGroup)subCondition);
            } else if (subCondition instanceof RawModlObject.Condition) {
                subConditionReturn = this.evaluates((RawModlObject.Condition)subCondition);
            }
            if (shouldNegate.booleanValue()) {
                boolean bl = subConditionReturn = !subConditionReturn;
            }
            if (conditionTestOperator == null) {
                result = subConditionReturn;
                continue;
            }
            if (conditionTestOperator.equals("&")) {
                result = result && subConditionReturn;
                continue;
            }
            if (!conditionTestOperator.equals("|")) continue;
            result = result || subConditionReturn;
        }
        return result;
    }

    private boolean evaluates(RawModlObject.ConditionGroup conditionGroup) {
        List<MutablePair<RawModlObject.ConditionTest, String>> orderedConditionalTestList = Interpreter.getOrderedConditionalTestList(conditionGroup);
        boolean result = true;
        for (MutablePair<RawModlObject.ConditionTest, String> conditionTestPair : orderedConditionalTestList) {
            RawModlObject.ConditionTest ct = (RawModlObject.ConditionTest)conditionTestPair.getLeft();
            String conditionGroupOperator = (String)conditionTestPair.getRight();
            boolean ctReturn = this.evaluates(ct);
            if (conditionGroupOperator == null) {
                result = ctReturn;
                continue;
            }
            if (conditionGroupOperator.equals("&")) {
                result = result && ctReturn;
                continue;
            }
            if (!conditionGroupOperator.equals("|")) continue;
            result = result || ctReturn;
        }
        return result;
    }

    private boolean evaluates(RawModlObject.Condition condition) {
        String valObj;
        String origKeyString;
        String keyString = condition.getKey();
        List<ModlValue> values = condition.getValues();
        ModlValue valueAtIndex0 = values.get(0);
        if (keyString == null) {
            if (valueAtIndex0 instanceof ModlObject.True) {
                return true;
            }
            if (valueAtIndex0 instanceof ModlObject.False) {
                return false;
            }
            if (valueAtIndex0 instanceof ModlObject.String) {
                ModlObject.String lhsValue = (ModlObject.String)valueAtIndex0;
                ModlValue transformedName = this.transformString(lhsValue.string);
                if (transformedName instanceof ModlObject.True) {
                    return true;
                }
                if (transformedName instanceof ModlObject.False) {
                    return false;
                }
                if (this.valuePairs.get(lhsValue.string) == null) {
                    return false;
                }
                ModlValue valueEntry = this.valuePairs.get(lhsValue.string);
                if (valueEntry instanceof ModlObject.True) {
                    return true;
                }
                return !(valueEntry instanceof ModlObject.False);
            }
            if (valueAtIndex0 instanceof ModlObject.Pair) {
                ModlObject.Pair p = (ModlObject.Pair)valueAtIndex0;
                keyString = p.getKey().string;
            } else {
                keyString = "__undefined__";
            }
        }
        while (keyString != null && (keyString.startsWith("_") || keyString.startsWith("%"))) {
            keyString = keyString.substring(1);
        }
        String key = this.transformConditionalArgument(keyString);
        String conditionOperator = condition.getOperator();
        if (values.size() > 1) {
            for (ModlValue value : values) {
                String val = this.getObjectFromValueForCondition(value);
                if (!conditionOperator.equals("=") || !this.conditionalEquals(key, val)) continue;
                return true;
            }
            return false;
        }
        String val = origKeyString = (valObj = this.getObjectFromValueForCondition(valueAtIndex0));
        if (origKeyString != null && origKeyString.startsWith("%")) {
            origKeyString = origKeyString.substring(1);
            val = this.transformConditionalArgument(origKeyString);
        } else {
            String tmpVal = val;
            if (val != null && val.startsWith("`")) {
                val = tmpVal = val.replaceAll("`", "");
            }
        }
        if (conditionOperator != null && conditionOperator.equals("=")) {
            return this.conditionalEquals(key, val);
        }
        if (conditionOperator != null && conditionOperator.equals("!=")) {
            return !this.conditionalEquals(key, val);
        }
        if (val != null) {
            Float valFloat = Float.valueOf(val);
            Float keyFloat = Float.valueOf(key);
            if (conditionOperator.equals(">")) {
                return keyFloat.compareTo(valFloat) > 0;
            }
            if (conditionOperator.equals("<")) {
                return keyFloat.compareTo(valFloat) < 0;
            }
            if (conditionOperator.equals("<=")) {
                return keyFloat.compareTo(valFloat) <= 0;
            }
            if (conditionOperator.equals(">=")) {
                return keyFloat.compareTo(valFloat) >= 0;
            }
        }
        return false;
    }

    private boolean conditionalEquals(String key, Object val) {
        if (val != null && val.toString().contains("*")) {
            return this.conditionalWildcardEquals(key, val.toString());
        }
        if (val == null) {
            return key == null;
        }
        return key.equals(StringEscapeReplacer.replace(val.toString()));
    }

    private boolean conditionalWildcardEquals(String key, Object val) {
        StringBuilder regex = !val.toString().startsWith("*") ? new StringBuilder("^") : new StringBuilder(".*");
        String[] splits = val.toString().split("\\*");
        int i = 0;
        for (String split : splits) {
            if (split.equals("")) continue;
            if (i++ > 0) {
                regex.append(".*");
            }
            regex.append(split);
        }
        if (!val.toString().endsWith("*")) {
            regex.append("$");
        } else {
            regex.append(".*");
        }
        return key.matches(regex.toString());
    }

    private String getObjectFromValueForCondition(ModlValue value) {
        if (value instanceof ModlObject.String) {
            return ((ModlObject.String)value).string;
        }
        if (value instanceof ModlObject.Number) {
            return ((ModlObject.Number)value).number;
        }
        return null;
    }

    private String transformConditionalArgument(String origKeyString) {
        StringTransformer stringTransformer = new StringTransformer(this.valuePairs, this.variables, this.numberedVariables);
        ModlValue objectRef = stringTransformer.runObjectReferencing("%" + origKeyString, "%" + origKeyString, false);
        if (objectRef instanceof ModlObject.String) {
            String keyString = ((ModlObject.String)objectRef).string;
            if (keyString.equals("%" + origKeyString) && origKeyString.startsWith("%")) {
                objectRef = stringTransformer.runObjectReferencing(origKeyString, origKeyString, false);
                if (objectRef instanceof ModlObject.String) {
                    keyString = ((ModlObject.String)objectRef).string;
                    if (keyString.equals("%" + origKeyString)) {
                        return origKeyString;
                    }
                    return keyString;
                }
                if (objectRef instanceof ModlObject.Number) {
                    keyString = ((ModlObject.Number)objectRef).number;
                    return keyString;
                }
            }
            return StringEscapeReplacer.replace(keyString);
        }
        if (objectRef instanceof ModlObject.Number) {
            return ((ModlObject.Number)objectRef).number;
        }
        if (objectRef instanceof ModlObject.Array || objectRef instanceof ModlObject.Map) {
            return objectRef.toString();
        }
        return origKeyString;
    }

    private ModlObject.False interpret(ModlObject.False falseVal) {
        if (falseVal != null) {
            return new ModlObject.False();
        }
        return null;
    }

    private ModlObject.Null interpret(ModlObject.Null val) {
        if (val != null) {
            return new ModlObject.Null();
        }
        return null;
    }

    private ModlObject.True interpret(ModlObject.True trueVal) {
        if (trueVal != null) {
            return new ModlObject.True();
        }
        return null;
    }

    private ModlObject.Number interpret(ModlObject.Number originalNumber) {
        if (originalNumber != null) {
            return new ModlObject.Number(originalNumber.number);
        }
        return null;
    }

    private ModlValue interpret(ModlObject.String string) {
        if (string != null) {
            ModlValue value = this.transformString(string.string);
            if (string.string.startsWith("%*")) {
                if (string.string.equals("%*class")) {
                    value = InstructionProcessor.processClassInstruction(this.klasses);
                }
                if (string.string.equals("%*load")) {
                    value = InstructionProcessor.processLoadInstruction(this.loadedFiles);
                }
                if (string.string.equals("%*method")) {
                    value = InstructionProcessor.processMethodInstruction(this.methodList);
                }
            }
            return value;
        }
        return null;
    }

    private ModlValue transformString(String s) {
        StringTransformer stringTransformer = new StringTransformer(this.valuePairs, this.variables, this.numberedVariables);
        return stringTransformer.transformString(s);
    }
}

