/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.interpreter;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import uk.modl.interpreter.ModlCacheEntry;
import uk.modl.parser.ModlObjectCreator;
import uk.modl.parser.RawModlObject;

class FileLoader {
    private static Map<String, ModlCacheEntry> cache = new LinkedHashMap<String, ModlCacheEntry>();

    FileLoader() {
    }

    static RawModlObject loadFile(List<String> filesLoaded, String location) {
        RawModlObject rawModlObject;
        String contents;
        boolean forceReload = false;
        if (location.endsWith("!")) {
            forceReload = true;
            location = location.substring(0, location.length() - 1);
        }
        if (!location.endsWith(".modl") && !location.endsWith(".txt")) {
            location = location + ".modl";
        }
        if (!forceReload && cache.get(location) != null && !cache.get(location).expired()) {
            filesLoaded.add(location);
            return FileLoader.cache.get((Object)location).rawModlObject;
        }
        if (location.startsWith("http")) {
            try {
                contents = new Scanner(new URL(location).openStream(), StandardCharsets.UTF_8.name()).useDelimiter("\\A").next();
            }
            catch (IOException e) {
                if (cache.get(location) != null) {
                    return FileLoader.cache.get((Object)location).rawModlObject;
                }
                throw new RuntimeException("Could not make URI : " + location + ", error : " + e);
            }
        }
        try {
            contents = new String(Files.readAllBytes(Paths.get(location, new String[0])));
        }
        catch (IOException e) {
            if (cache.get(location) != null) {
                return FileLoader.cache.get((Object)location).rawModlObject;
            }
            throw new RuntimeException("Could not open file : " + location + ", error : " + e);
        }
        try {
            rawModlObject = ModlObjectCreator.processModlParsed(contents);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not interpret " + location + ", error : " + e);
        }
        long endTime = System.currentTimeMillis() / 1000L + 3600L;
        ModlCacheEntry modlCacheEntry = new ModlCacheEntry(endTime, rawModlObject);
        cache.put(location, modlCacheEntry);
        filesLoaded.add(location);
        return rawModlObject;
    }
}

