/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.interpreter;

class UnicodeEscapeReplacer {
    private static final String BACKSLASH_U = "\\u";
    private static final String TILDE_U = "~u";
    private static final char TILDE = '~';
    private static final char BACKSLASH = '\\';
    private static final int ESCAPE_SEQUENCE_LENGHT = 6;
    private static final int HEX = 16;

    UnicodeEscapeReplacer() {
    }

    static String convertUnicodeSequences(String str) {
        int start = 0;
        String result = str;
        while (result != null) {
            int unicodeStrIdx;
            int backslashUIndex = result.indexOf(BACKSLASH_U, start);
            int tildeUIndex = result.indexOf(TILDE_U, start);
            if (tildeUIndex < 0 && backslashUIndex < 0 || (unicodeStrIdx = tildeUIndex < 0 ? backslashUIndex : (backslashUIndex < 0 ? tildeUIndex : Math.min(backslashUIndex, tildeUIndex))) + 6 > result.length()) break;
            start = unicodeStrIdx + 1;
            if (unicodeStrIdx > 0 && (result.charAt(unicodeStrIdx - 1) == '~' || result.charAt(unicodeStrIdx - 1) == '\\')) continue;
            int codePoint = Integer.parseInt(result.substring(unicodeStrIdx + 2, unicodeStrIdx + 6), 16);
            result = UnicodeEscapeReplacer.replace(result, (char)codePoint, unicodeStrIdx);
        }
        return result;
    }

    private static String replace(String s, char value, int unicodeStrIdx) {
        String left = s.substring(0, unicodeStrIdx);
        String right = s.substring(unicodeStrIdx + 6);
        return left + value + right;
    }
}

