/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.interpreter;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.text.WordUtils;

public class VariableMethods {
    public static Function<String, String> trim = parameter -> {
        if (parameter == null) {
            return null;
        }
        String[] split = parameter.split(",");
        String subject = split[0];
        String trim = split[1];
        int indexOfTrim = subject.indexOf(trim);
        return subject.substring(0, indexOfTrim);
    };
    public static Function<String, String> replace = parameter -> {
        if (parameter == null) {
            return null;
        }
        String[] split = parameter.split(",");
        String subject = split[0];
        String search = split[1];
        String replace = "";
        if (split.length > 2) {
            replace = split[2];
        }
        return subject.replace(search, replace);
    };
    public static Function<String, String> upperCase = parameter -> {
        if (parameter == null) {
            return null;
        }
        return parameter.toUpperCase();
    };
    public static Function<String, String> downCase = parameter -> {
        if (parameter == null) {
            return null;
        }
        return parameter.toLowerCase();
    };
    public static Function<String, String> sentence = parameter -> {
        if (parameter == null) {
            return null;
        }
        return VariableMethods.makeSentence(parameter);
    };
    public static Function<String, String> urlEncode = parameter -> {
        if (parameter == null) {
            return null;
        }
        try {
            return URLEncoder.encode(parameter, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    };
    public static Function<String, String> initCaps = parameter -> {
        if (parameter == null) {
            return null;
        }
        return WordUtils.capitalize((String)parameter);
    };
    private static Map<String, Function<String, String>> constantVariableMethods;

    public static Map<String, Function<String, String>> getConstantVariableMethods() {
        if (constantVariableMethods != null) {
            return constantVariableMethods;
        }
        VariableMethods.initialiseConstantVariableMethods();
        return constantVariableMethods;
    }

    private static void initialiseConstantVariableMethods() {
        constantVariableMethods = new HashMap<String, Function<String, String>>();
        constantVariableMethods.put("u", upperCase);
        constantVariableMethods.put("d", downCase);
        constantVariableMethods.put("i", initCaps);
        constantVariableMethods.put("initcap", initCaps);
        constantVariableMethods.put("ue", urlEncode);
        constantVariableMethods.put("s", sentence);
        constantVariableMethods.put("t", trim);
        constantVariableMethods.put("trim", trim);
        constantVariableMethods.put("r", replace);
        constantVariableMethods.put("replace", replace);
    }

    private static String makeSentence(String parameter) {
        CharSequence[] splits = parameter.split(" ");
        splits[0] = WordUtils.capitalize((String)splits[0]);
        String ret = "";
        return String.join((CharSequence)" ", splits);
    }
}

