/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.interpreter;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import uk.modl.interpreter.ModlAndTtl;
import uk.modl.parser.ModlObjectCreator;
import uk.modl.parser.RawModlObject;

public class FileLoader {
    private static Map<String, ModlAndTtl> cache = new HashMap<String, ModlAndTtl>();

    public static RawModlObject loadFile(String location) {
        String contents = null;
        boolean forceReload = false;
        if (location.endsWith("!")) {
            forceReload = true;
            location = location.substring(0, location.length() - 1);
        }
        if (!location.endsWith(".modl") && !location.endsWith(".txt")) {
            location = location + ".modl";
        }
        if (!forceReload) {
            if (cache.get(location) != null) {
                if (FileLoader.cache.get((Object)location).endTime >= System.currentTimeMillis() / 1000L) {
                    return FileLoader.cache.get((Object)location).rawModlObject;
                }
                cache.remove(location);
            }
        } else {
            cache.remove(location);
        }
        if (location.startsWith("http:")) {
            try {
                contents = new Scanner(new URL(location).openStream(), "UTF-8").useDelimiter("\\A").next();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not make URI : " + location + ", error : " + e);
            }
        }
        try {
            contents = new String(Files.readAllBytes(Paths.get(location, new String[0])));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not open file : " + location + ", error : " + e);
        }
        RawModlObject rawModlObject = null;
        try {
            rawModlObject = ModlObjectCreator.processModlParsed(contents);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not interpret " + location + ", error : " + e);
        }
        long endTime = System.currentTimeMillis() / 1000L + 3600L;
        ModlAndTtl modlAndTtl = new ModlAndTtl(endTime, rawModlObject);
        cache.put(location, modlAndTtl);
        return rawModlObject;
    }
}

