/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.service.notify;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Base64;
import java.util.Scanner;
import uk.gov.service.notify.NotificationClientException;

public class PdfUtils {
    public static boolean isFilePDF(File file) throws NotificationClientException {
        Scanner input;
        try {
            input = new Scanner(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            throw new NotificationClientException("Error reading PDF file", e);
        }
        return PdfUtils.isPDF(input);
    }

    public static boolean isBase64StringPDF(String base64String) {
        byte[] decoded = Base64.getDecoder().decode(base64String);
        Scanner input = new Scanner(new ByteArrayInputStream(decoded));
        return PdfUtils.isPDF(input);
    }

    private static boolean isPDF(Scanner input) {
        while (input.hasNextLine()) {
            String checkLine = input.nextLine();
            if (!checkLine.contains("%PDF-")) continue;
            return true;
        }
        return false;
    }
}

