/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.service.notify;

import java.util.Optional;
import java.util.UUID;
import org.json.JSONObject;

public class SendLetterResponse {
    private UUID notificationId;
    private String reference;
    private UUID templateId;
    private int templateVersion;
    private String templateUri;
    private String body;
    private String subject;

    public SendLetterResponse(String response) {
        JSONObject data = new JSONObject(response);
        this.notificationId = UUID.fromString(data.getString("id"));
        this.reference = data.isNull("reference") ? null : data.getString("reference");
        JSONObject content = data.getJSONObject("content");
        this.body = content.getString("body");
        this.subject = content.getString("subject");
        JSONObject template = data.getJSONObject("template");
        this.templateId = UUID.fromString(template.getString("id"));
        this.templateVersion = template.getInt("version");
        this.templateUri = template.getString("uri");
    }

    public UUID getNotificationId() {
        return this.notificationId;
    }

    public Optional<String> getReference() {
        return Optional.ofNullable(this.reference);
    }

    public UUID getTemplateId() {
        return this.templateId;
    }

    public int getTemplateVersion() {
        return this.templateVersion;
    }

    public String getTemplateUri() {
        return this.templateUri;
    }

    public String getBody() {
        return this.body;
    }

    public String getSubject() {
        return this.subject;
    }

    public String toString() {
        return "SendLetterResponse{notificationId=" + this.notificationId + ", reference=" + this.reference + ", templateId=" + this.templateId + ", templateVersion=" + this.templateVersion + ", templateUri='" + this.templateUri + '\'' + ", body='" + this.body + '\'' + ", subject='" + this.subject + '}';
    }
}

