/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.service.notify;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.gov.service.notify.Notification;

public class NotificationList {
    private List<Notification> notifications;
    private String currentPageLink;
    private String nextPageLink;

    public List<Notification> getNotifications() {
        return this.notifications;
    }

    public Optional<String> getNextPageLink() {
        return Optional.ofNullable(this.nextPageLink);
    }

    public String getCurrentPageLink() {
        return this.currentPageLink;
    }

    public NotificationList(String content) {
        JSONObject data = new JSONObject(content);
        JSONObject links = data.getJSONObject("links");
        this.currentPageLink = links.getString("current");
        this.nextPageLink = links.isNull("next") ? null : links.getString("next");
        this.notifications = new ArrayList<Notification>();
        JSONArray notificationsData = data.getJSONArray("notifications");
        for (int i = 0; i < notificationsData.length(); ++i) {
            JSONObject notification = notificationsData.getJSONObject(i);
            this.notifications.add(new Notification(notification));
        }
    }

    public String toString() {
        StringBuilder notifications_string = new StringBuilder("\n");
        for (Notification notification : this.notifications) {
            notifications_string.append(notification.toString()).append("\n");
        }
        return "NotificationList{notifications=" + notifications_string.toString() + ", currentPageLink='" + this.currentPageLink + '\'' + ", nextPageLink='" + this.nextPageLink + '\'' + '}';
    }
}

