/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.common.shared.security;

import io.prometheus.client.Gauge;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;

public class TrustStoreMetrics {
    private Gauge expiryDateGauge;

    public TrustStoreMetrics(Gauge gauge) {
        this.expiryDateGauge = gauge;
    }

    public TrustStoreMetrics() {
        this("verify_trust_store_certificate_expiry_date");
    }

    public TrustStoreMetrics(String gaugeName) {
        this.expiryDateGauge = (Gauge)((Gauge.Builder)Gauge.build((String)gaugeName, (String)"Expiry date (in unix time milliseconds) of a certificate in a Java truststore").labelNames(new String[]{"truststore", "subject", "serial"})).register();
    }

    public void registerTrustStore(String name, KeyStore trustStore) {
        try {
            Enumeration<String> aliases = trustStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                X509Certificate certificate = (X509Certificate)trustStore.getCertificate(alias);
                ((Gauge.Child)this.expiryDateGauge.labels(new String[]{name, certificate.getSubjectDN().getName(), certificate.getSerialNumber().toString(10)})).set((double)certificate.getNotAfter().getTime());
            }
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
    }
}

