/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.common.shared.configuration;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.ByteArrayInputStream;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import uk.gov.ida.common.shared.configuration.EncodedCertificateConfiguration;
import uk.gov.ida.common.shared.configuration.PublicKeyFileConfiguration;
import uk.gov.ida.common.shared.configuration.X509CertificateConfiguration;
import uk.gov.ida.common.shared.security.exceptions.CertificateLoadingException;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=PublicKeyFileConfiguration.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=PublicKeyFileConfiguration.class, name="file"), @JsonSubTypes.Type(value=EncodedCertificateConfiguration.class, name="encoded"), @JsonSubTypes.Type(value=X509CertificateConfiguration.class, name="x509")})
public abstract class DeserializablePublicKeyConfiguration {
    protected String fullCertificate;
    protected Certificate certificate;
    protected String name;

    public PublicKey getPublicKey() {
        return this.certificate.getPublicKey();
    }

    public String getName() {
        return this.name;
    }

    public String getCert() {
        return this.fullCertificate;
    }

    protected static Certificate getCertificateFromString(String cert) {
        try {
            return CertificateFactory.getInstance("X509").generateCertificate(new ByteArrayInputStream(cert.getBytes()));
        }
        catch (CertificateException e) {
            throw new CertificateLoadingException(cert);
        }
    }
}

