/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.binary_entrypoint;

import b3.entrypoint.fixp.sbe.EstablishDecoder;
import b3.entrypoint.fixp.sbe.FinishedReceivingDecoder;
import b3.entrypoint.fixp.sbe.FinishedSendingDecoder;
import b3.entrypoint.fixp.sbe.MessageHeaderDecoder;
import b3.entrypoint.fixp.sbe.NegotiateDecoder;
import b3.entrypoint.fixp.sbe.RetransmitRequestDecoder;
import b3.entrypoint.fixp.sbe.SequenceDecoder;
import b3.entrypoint.fixp.sbe.TerminateDecoder;
import io.aeron.logbuffer.ControlledFragmentHandler;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.binary_entrypoint.BinaryEntryPointContext;
import uk.co.real_logic.artio.binary_entrypoint.InternalBinaryEntryPointConnection;
import uk.co.real_logic.artio.fixp.AbstractFixPParser;
import uk.co.real_logic.artio.fixp.SimpleOpenFramingHeader;

public class BinaryEntryPointParser
extends AbstractFixPParser {
    private final MessageHeaderDecoder header = new MessageHeaderDecoder();
    private final NegotiateDecoder negotiate = new NegotiateDecoder();
    private final EstablishDecoder establish = new EstablishDecoder();
    private final TerminateDecoder terminate = new TerminateDecoder();
    private final SequenceDecoder sequence = new SequenceDecoder();
    private final FinishedSendingDecoder finishedSending = new FinishedSendingDecoder();
    private final FinishedReceivingDecoder finishedReceiving = new FinishedReceivingDecoder();
    private final RetransmitRequestDecoder retransmitRequest = new RetransmitRequestDecoder();
    private final Consumer<StringBuilder> negotiateAppendTo = arg_0 -> ((NegotiateDecoder)this.negotiate).appendTo(arg_0);
    private final Consumer<StringBuilder> establishAppendTo = arg_0 -> ((EstablishDecoder)this.establish).appendTo(arg_0);
    private final Consumer<StringBuilder> terminateAppendTo = arg_0 -> ((TerminateDecoder)this.terminate).appendTo(arg_0);
    private final Consumer<StringBuilder> sequenceAppendTo = arg_0 -> ((SequenceDecoder)this.sequence).appendTo(arg_0);
    private final Consumer<StringBuilder> finishedSendingAppendTo = arg_0 -> ((FinishedSendingDecoder)this.finishedSending).appendTo(arg_0);
    private final Consumer<StringBuilder> finishedReceivingAppendTo = arg_0 -> ((FinishedReceivingDecoder)this.finishedReceiving).appendTo(arg_0);
    private final Consumer<StringBuilder> retransmitRequestAppendTo = arg_0 -> ((RetransmitRequestDecoder)this.retransmitRequest).appendTo(arg_0);
    private final InternalBinaryEntryPointConnection handler;

    public BinaryEntryPointParser(InternalBinaryEntryPointConnection handler) {
        this.handler = handler;
    }

    public int templateId(DirectBuffer buffer, int offset) {
        this.header.wrap(buffer, offset);
        return this.header.templateId();
    }

    public int blockLength(DirectBuffer buffer, int offset) {
        this.header.wrap(buffer, offset);
        return this.header.blockLength();
    }

    public int version(DirectBuffer buffer, int offset) {
        this.header.wrap(buffer, offset);
        return this.header.version();
    }

    public ControlledFragmentHandler.Action onMessage(DirectBuffer buffer, int start) {
        int offset = start + 4;
        this.header.wrap(buffer, offset);
        int templateId = this.header.templateId();
        int blockLength = this.header.blockLength();
        int version = this.header.version();
        offset += 8;
        switch (templateId) {
            case 1: {
                return this.onNegotiate(buffer, offset, blockLength, version);
            }
            case 4: {
                return this.onEstablish(buffer, offset, blockLength, version);
            }
            case 7: {
                return this.onTerminate(buffer, offset, blockLength, version);
            }
            case 9: {
                return this.onSequence(buffer, offset, blockLength, version);
            }
            case 10: {
                return this.onFinishedSending(buffer, offset, blockLength, version);
            }
            case 11: {
                return this.onFinishedReceiving(buffer, offset, blockLength, version);
            }
            case 12: {
                return this.onRetransmitRequest(buffer, offset, blockLength, version);
            }
        }
        int sofhMessageSize = SimpleOpenFramingHeader.readSofhMessageSize((DirectBuffer)buffer, (int)start);
        return this.handler.onMessage(buffer, offset, templateId, blockLength, version, sofhMessageSize);
    }

    private ControlledFragmentHandler.Action onRetransmitRequest(DirectBuffer buffer, int offset, int blockLength, int version) {
        RetransmitRequestDecoder retransmitRequest = this.retransmitRequest;
        retransmitRequest.wrap(buffer, offset, blockLength, version);
        DebugLogger.logSbeDecoder((LogTag)LogTag.FIXP_SESSION, (String)"> ", this.retransmitRequestAppendTo);
        return this.handler.onRetransmitRequest(retransmitRequest.sessionID(), retransmitRequest.timestamp().time(), retransmitRequest.fromSeqNo(), retransmitRequest.count());
    }

    private ControlledFragmentHandler.Action onFinishedSending(DirectBuffer buffer, int offset, int blockLength, int version) {
        FinishedSendingDecoder finishedSending = this.finishedSending;
        finishedSending.wrap(buffer, offset, blockLength, version);
        DebugLogger.logSbeDecoder((LogTag)LogTag.FIXP_SESSION, (String)"> ", this.finishedSendingAppendTo);
        return this.handler.onFinishedSending(finishedSending.sessionID(), finishedSending.sessionVerID(), finishedSending.lastSeqNo());
    }

    private ControlledFragmentHandler.Action onFinishedReceiving(DirectBuffer buffer, int offset, int blockLength, int version) {
        FinishedReceivingDecoder finishedReceiving = this.finishedReceiving;
        finishedReceiving.wrap(buffer, offset, blockLength, version);
        DebugLogger.logSbeDecoder((LogTag)LogTag.FIXP_SESSION, (String)"> ", this.finishedReceivingAppendTo);
        return this.handler.onFinishedReceiving(finishedReceiving.sessionID(), finishedReceiving.sessionVerID());
    }

    private ControlledFragmentHandler.Action onSequence(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.sequence.wrap(buffer, offset, blockLength, version);
        DebugLogger.logSbeDecoder((LogTag)LogTag.FIXP_SESSION, (String)"> ", this.sequenceAppendTo);
        return this.handler.onSequence(this.sequence.nextSeqNo());
    }

    private ControlledFragmentHandler.Action onTerminate(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.terminate.wrap(buffer, offset, blockLength, version);
        DebugLogger.logSbeDecoder((LogTag)LogTag.FIXP_SESSION, (String)"> ", this.terminateAppendTo);
        return this.handler.onTerminate(this.terminate.sessionID(), this.terminate.sessionVerID(), this.terminate.terminationCode());
    }

    private ControlledFragmentHandler.Action onEstablish(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.establish.wrap(buffer, offset, blockLength, version);
        DebugLogger.logSbeDecoder((LogTag)LogTag.FIXP_SESSION, (String)"> ", this.establishAppendTo);
        return this.handler.onEstablish(this.establish.sessionID(), this.establish.sessionVerID(), this.establish.timestamp().time(), this.establish.keepAliveInterval().time(), this.establish.nextSeqNo(), this.establish.cancelOnDisconnectType(), this.establish.codTimeoutWindow().time());
    }

    private ControlledFragmentHandler.Action onNegotiate(DirectBuffer buffer, int offset, int blockLength, int version) {
        this.negotiate.wrap(buffer, offset, blockLength, version);
        DebugLogger.logSbeDecoder((LogTag)LogTag.FIXP_SESSION, (String)"> ", this.negotiateAppendTo);
        return this.handler.onNegotiate(this.negotiate.sessionID(), this.negotiate.sessionVerID(), this.negotiate.timestamp().time(), this.negotiate.enteringFirm(), this.negotiate.onbehalfFirm(), this.negotiate.senderLocation());
    }

    public BinaryEntryPointContext lookupContext(DirectBuffer messageBuffer, int messageOffset, int messageLength) {
        int offset = messageOffset + 4;
        this.header.wrap(messageBuffer, offset);
        int templateId = this.header.templateId();
        int blockLength = this.header.blockLength();
        int version = this.header.version();
        offset += 8;
        switch (templateId) {
            case 1: {
                this.negotiate.wrap(messageBuffer, offset, blockLength, version);
                return new BinaryEntryPointContext(this.negotiate.sessionID(), this.negotiate.sessionVerID(), this.negotiate.timestamp().time(), this.negotiate.enteringFirm(), true);
            }
            case 4: {
                this.establish.wrap(messageBuffer, offset, blockLength, version);
                return new BinaryEntryPointContext(this.establish.sessionID(), this.establish.sessionVerID(), this.establish.timestamp().time(), NegotiateDecoder.enteringFirmNullValue(), false);
            }
        }
        throw new IllegalArgumentException("Template id: " + templateId + " isn't a negotiate or establish");
    }

    public long sessionId(DirectBuffer buffer, int start) {
        int offset = start + 4;
        this.header.wrap(buffer, offset);
        int templateId = this.header.templateId();
        int blockLength = this.header.blockLength();
        int version = this.header.version();
        offset += 8;
        switch (templateId) {
            case 1: {
                this.negotiate.wrap(buffer, offset, blockLength, version);
                return this.negotiate.sessionID();
            }
            case 4: {
                this.establish.wrap(buffer, offset, blockLength, version);
                return this.establish.sessionID();
            }
        }
        throw new IllegalArgumentException("Template id: " + templateId + " isn't a negotiate or establish");
    }

    public int retransmissionTemplateId() {
        return 13;
    }

    public boolean isRetransmittedMessage(DirectBuffer buffer, int offset) {
        return this.templateId(buffer, offset) >= 100;
    }
}

