/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.MessageHeaderDecoder;
import b3.entrypoint.fixp.sbe.MessageType;
import b3.entrypoint.fixp.sbe.MetaAttribute;
import b3.entrypoint.fixp.sbe.OrdType;
import b3.entrypoint.fixp.sbe.PriceDecoder;
import b3.entrypoint.fixp.sbe.Side;
import b3.entrypoint.fixp.sbe.TimeInForce;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class SimpleNewOrderDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 58;
    public static final int TEMPLATE_ID = 100;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final SimpleNewOrderDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;
    private static final byte[] SECURITYIDSOURCE_VALUE = new byte[]{56};
    private static final byte[] SECURITYEXCHANGE_VALUE = new byte[]{66, 86, 77, 70};
    private final PriceDecoder price = new PriceDecoder();

    public int sbeBlockLength() {
        return 58;
    }

    public int sbeTemplateId() {
        return 100;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public SimpleNewOrderDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public SimpleNewOrderDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (100 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int messageTypeId() {
        return 35;
    }

    public static int messageTypeSinceVersion() {
        return 0;
    }

    public static int messageTypeEncodingOffset() {
        return 0;
    }

    public static int messageTypeEncodingLength() {
        return 1;
    }

    public static String messageTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public short messageTypeRaw() {
        return MessageType.SimpleNewOrder.value();
    }

    public MessageType messageType() {
        return MessageType.SimpleNewOrder;
    }

    public static int clOrdIDId() {
        return 11;
    }

    public static int clOrdIDSinceVersion() {
        return 0;
    }

    public static int clOrdIDEncodingOffset() {
        return 0;
    }

    public static int clOrdIDEncodingLength() {
        return 8;
    }

    public static String clOrdIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long clOrdIDNullValue() {
        return -1L;
    }

    public static long clOrdIDMinValue() {
        return 0L;
    }

    public static long clOrdIDMaxValue() {
        return -2L;
    }

    public long clOrdID() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int securityIDId() {
        return 48;
    }

    public static int securityIDSinceVersion() {
        return 0;
    }

    public static int securityIDEncodingOffset() {
        return 8;
    }

    public static int securityIDEncodingLength() {
        return 8;
    }

    public static String securityIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long securityIDNullValue() {
        return -1L;
    }

    public static long securityIDMinValue() {
        return 0L;
    }

    public static long securityIDMaxValue() {
        return -2L;
    }

    public long securityID() {
        return this.buffer.getLong(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int securityIDSourceId() {
        return 22;
    }

    public static int securityIDSourceSinceVersion() {
        return 0;
    }

    public static int securityIDSourceEncodingOffset() {
        return 16;
    }

    public static int securityIDSourceEncodingLength() {
        return 0;
    }

    public static String securityIDSourceMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static byte securityIDSourceNullValue() {
        return 0;
    }

    public static byte securityIDSourceMinValue() {
        return 32;
    }

    public static byte securityIDSourceMaxValue() {
        return 126;
    }

    public static int securityIDSourceLength() {
        return 1;
    }

    public byte securityIDSource(int index) {
        return SECURITYIDSOURCE_VALUE[index];
    }

    public int getSecurityIDSource(byte[] dst, int offset, int length) {
        int bytesCopied = Math.min(length, 1);
        System.arraycopy(SECURITYIDSOURCE_VALUE, 0, dst, offset, bytesCopied);
        return bytesCopied;
    }

    public byte securityIDSource() {
        return 56;
    }

    public static int securityExchangeId() {
        return 207;
    }

    public static int securityExchangeSinceVersion() {
        return 0;
    }

    public static int securityExchangeEncodingOffset() {
        return 16;
    }

    public static int securityExchangeEncodingLength() {
        return 0;
    }

    public static String securityExchangeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static byte securityExchangeNullValue() {
        return 0;
    }

    public static byte securityExchangeMinValue() {
        return 32;
    }

    public static byte securityExchangeMaxValue() {
        return 126;
    }

    public static int securityExchangeLength() {
        return 4;
    }

    public byte securityExchange(int index) {
        return SECURITYEXCHANGE_VALUE[index];
    }

    public int getSecurityExchange(byte[] dst, int offset, int length) {
        int bytesCopied = Math.min(length, 4);
        System.arraycopy(SECURITYEXCHANGE_VALUE, 0, dst, offset, bytesCopied);
        return bytesCopied;
    }

    public String securityExchange() {
        return "BVMF";
    }

    public static int priceId() {
        return 44;
    }

    public static int priceSinceVersion() {
        return 0;
    }

    public static int priceEncodingOffset() {
        return 16;
    }

    public static int priceEncodingLength() {
        return 8;
    }

    public static String priceMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public PriceDecoder price() {
        this.price.wrap(this.buffer, this.offset + 16);
        return this.price;
    }

    public static int orderQtyId() {
        return 38;
    }

    public static int orderQtySinceVersion() {
        return 0;
    }

    public static int orderQtyEncodingOffset() {
        return 24;
    }

    public static int orderQtyEncodingLength() {
        return 16;
    }

    public static String orderQtyMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long orderQtyNullValue() {
        return 0xFFFFFFFFL;
    }

    public static long orderQtyMinValue() {
        return 0L;
    }

    public static long orderQtyMaxValue() {
        return 0xFFFFFFFEL;
    }

    public static int orderQtyLength() {
        return 4;
    }

    public long orderQty(int index) {
        if (index < 0 || index >= 4) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 24 + index * 4;
        return (long)this.buffer.getInt(pos, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
    }

    public static int accountId() {
        return 1;
    }

    public static int accountSinceVersion() {
        return 0;
    }

    public static int accountEncodingOffset() {
        return 40;
    }

    public static int accountEncodingLength() {
        return 4;
    }

    public static String accountMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static long accountNullValue() {
        return 0L;
    }

    public static long accountMinValue() {
        return 0L;
    }

    public static long accountMaxValue() {
        return 0xFFFFFFFEL;
    }

    public long account() {
        return (long)this.buffer.getInt(this.offset + 40, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
    }

    public static int marketSegmentIDId() {
        return 1300;
    }

    public static int marketSegmentIDSinceVersion() {
        return 0;
    }

    public static int marketSegmentIDEncodingOffset() {
        return 44;
    }

    public static int marketSegmentIDEncodingLength() {
        return 1;
    }

    public static String marketSegmentIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static short marketSegmentIDNullValue() {
        return 255;
    }

    public static short marketSegmentIDMinValue() {
        return 0;
    }

    public static short marketSegmentIDMaxValue() {
        return 254;
    }

    public short marketSegmentID() {
        return (short)(this.buffer.getByte(this.offset + 44) & 0xFF);
    }

    public static int sideId() {
        return 54;
    }

    public static int sideSinceVersion() {
        return 0;
    }

    public static int sideEncodingOffset() {
        return 45;
    }

    public static int sideEncodingLength() {
        return 1;
    }

    public static String sideMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public byte sideRaw() {
        return this.buffer.getByte(this.offset + 45);
    }

    public Side side() {
        return Side.get(this.buffer.getByte(this.offset + 45));
    }

    public static int ordTypeId() {
        return 40;
    }

    public static int ordTypeSinceVersion() {
        return 0;
    }

    public static int ordTypeEncodingOffset() {
        return 46;
    }

    public static int ordTypeEncodingLength() {
        return 1;
    }

    public static String ordTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public byte ordTypeRaw() {
        return this.buffer.getByte(this.offset + 46);
    }

    public OrdType ordType() {
        return OrdType.get(this.buffer.getByte(this.offset + 46));
    }

    public static int timeInForceId() {
        return 59;
    }

    public static int timeInForceSinceVersion() {
        return 0;
    }

    public static int timeInForceEncodingOffset() {
        return 47;
    }

    public static int timeInForceEncodingLength() {
        return 1;
    }

    public static String timeInForceMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public byte timeInForceRaw() {
        return this.buffer.getByte(this.offset + 47);
    }

    public TimeInForce timeInForce() {
        return TimeInForce.get(this.buffer.getByte(this.offset + 47));
    }

    public static int ordTagIDId() {
        return 35505;
    }

    public static int ordTagIDSinceVersion() {
        return 0;
    }

    public static int ordTagIDEncodingOffset() {
        return 48;
    }

    public static int ordTagIDEncodingLength() {
        return 1;
    }

    public static String ordTagIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static short ordTagIDNullValue() {
        return 0;
    }

    public static short ordTagIDMinValue() {
        return 0;
    }

    public static short ordTagIDMaxValue() {
        return 254;
    }

    public short ordTagID() {
        return (short)(this.buffer.getByte(this.offset + 48) & 0xFF);
    }

    public static int enteringTraderId() {
        return 35502;
    }

    public static int enteringTraderSinceVersion() {
        return 0;
    }

    public static int enteringTraderEncodingOffset() {
        return 49;
    }

    public static int enteringTraderEncodingLength() {
        return 5;
    }

    public static String enteringTraderMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte enteringTraderNullValue() {
        return 0;
    }

    public static byte enteringTraderMinValue() {
        return 32;
    }

    public static byte enteringTraderMaxValue() {
        return 126;
    }

    public static int enteringTraderLength() {
        return 5;
    }

    public byte enteringTrader(int index) {
        if (index < 0 || index >= 5) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 49 + index * 1;
        return this.buffer.getByte(pos);
    }

    public static String enteringTraderCharacterEncoding() {
        return "ASCII";
    }

    public int getEnteringTrader(byte[] dst, int dstOffset) {
        int length = 5;
        if (dstOffset < 0 || dstOffset > dst.length - 5) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + dstOffset);
        }
        this.buffer.getBytes(this.offset + 49, dst, dstOffset, 5);
        return 5;
    }

    public String enteringTrader() {
        int end;
        byte[] dst = new byte[5];
        this.buffer.getBytes(this.offset + 49, dst, 0, 5);
        for (end = 0; end < 5 && dst[end] != 0; ++end) {
        }
        return new String(dst, 0, end, StandardCharsets.US_ASCII);
    }

    public int getEnteringTrader(Appendable value) {
        for (int i = 0; i < 5; ++i) {
            int c = this.buffer.getByte(this.offset + 49 + i) & 0xFF;
            if (c == 0) {
                return i;
            }
            try {
                value.append((char)(c > 127 ? 63 : (char)c));
                continue;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return 5;
    }

    public static int investorIDId() {
        return 35504;
    }

    public static int investorIDSinceVersion() {
        return 0;
    }

    public static int investorIDEncodingOffset() {
        return 54;
    }

    public static int investorIDEncodingLength() {
        return 4;
    }

    public static String investorIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static long investorIDNullValue() {
        return 0L;
    }

    public static long investorIDMinValue() {
        return 0L;
    }

    public static long investorIDMaxValue() {
        return 0xFFFFFFFEL;
    }

    public long investorID() {
        return (long)this.buffer.getInt(this.offset + 54, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        SimpleNewOrderDecoder decoder = new SimpleNewOrderDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int i;
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[SimpleNewOrder](sbeTemplateId=");
        builder.append(100);
        builder.append("|sbeSchemaId=");
        builder.append(1);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 0) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(0);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 58) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(58);
        builder.append("):");
        builder.append("messageType=");
        builder.append((Object)this.messageType());
        builder.append('|');
        builder.append("clOrdID=");
        builder.append(this.clOrdID());
        builder.append('|');
        builder.append("securityID=");
        builder.append(this.securityID());
        builder.append('|');
        builder.append("price=");
        PriceDecoder price = this.price();
        if (price != null) {
            price.appendTo(builder);
        } else {
            builder.append("null");
        }
        builder.append('|');
        builder.append("orderQty=");
        builder.append('[');
        if (SimpleNewOrderDecoder.orderQtyLength() > 0) {
            for (i = 0; i < SimpleNewOrderDecoder.orderQtyLength(); ++i) {
                builder.append(this.orderQty(i));
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        builder.append('|');
        builder.append("account=");
        builder.append(this.account());
        builder.append('|');
        builder.append("marketSegmentID=");
        builder.append(this.marketSegmentID());
        builder.append('|');
        builder.append("side=");
        builder.append((Object)this.side());
        builder.append('|');
        builder.append("ordType=");
        builder.append((Object)this.ordType());
        builder.append('|');
        builder.append("timeInForce=");
        builder.append((Object)this.timeInForce());
        builder.append('|');
        builder.append("ordTagID=");
        builder.append(this.ordTagID());
        builder.append('|');
        builder.append("enteringTrader=");
        for (i = 0; i < SimpleNewOrderDecoder.enteringTraderLength() && this.enteringTrader(i) > 0; ++i) {
            builder.append((char)this.enteringTrader(i));
        }
        builder.append('|');
        builder.append("investorID=");
        builder.append(this.investorID());
        this.limit(originalLimit);
        return builder;
    }
}

