/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.FramingHeaderDecoder;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.CompositeEncoderFlyweight;

public final class FramingHeaderEncoder
implements CompositeEncoderFlyweight {
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 5;
    public static final int ENCODED_LENGTH = 4;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private int offset;
    private MutableDirectBuffer buffer;

    public FramingHeaderEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        return this;
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public int encodedLength() {
        return 4;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 5;
    }

    public static int messageLengthEncodingOffset() {
        return 0;
    }

    public static int messageLengthEncodingLength() {
        return 2;
    }

    public static int messageLengthNullValue() {
        return 65535;
    }

    public static int messageLengthMinValue() {
        return 12;
    }

    public static int messageLengthMaxValue() {
        return 2048;
    }

    public FramingHeaderEncoder messageLength(int value) {
        this.buffer.putShort(this.offset + 0, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int encodingTypeEncodingOffset() {
        return 2;
    }

    public static int encodingTypeEncodingLength() {
        return 2;
    }

    public static int encodingTypeNullValue() {
        return 65535;
    }

    public static int encodingTypeMinValue() {
        return 0;
    }

    public static int encodingTypeMaxValue() {
        return 65534;
    }

    public FramingHeaderEncoder encodingType(int value) {
        this.buffer.putShort(this.offset + 2, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        FramingHeaderDecoder decoder = new FramingHeaderDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset);
        return decoder.appendTo(builder);
    }
}

