/*
 * Decompiled with CFR 0.152.
 */
package com.seleniumsimplified.webdriver.manager;

import com.seleniumsimplified.webdriver.manager.EnvironmentPropertyReader;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.MarionetteDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public class Driver
extends Thread {
    private static WebDriver aDriver = null;
    private static long browserStartTime = 0L;
    private static long savedTimecount = 0L;
    public static final long DEFAULT_TIMEOUT_SECONDS = 10L;
    private static boolean avoidRecursiveCall = false;
    public static final String BROWSER_PROPERTY_NAME = "selenium2basics.webdriver";
    private static final String DEFAULT_BROWSER = "GOOGLECHROME";
    public static BrowserName currentDriver;
    private static BrowserName useThisDriver;
    public static String PROXYHOST;
    public static String PROXYPORT;
    public static String PROXY;

    public static void set(BrowserName aBrowser) {
        useThisDriver = aBrowser;
        if (aDriver != null) {
            aDriver.quit();
            aDriver = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static WebDriver get() {
        if (useThisDriver == null) {
            String defaultBrowser = EnvironmentPropertyReader.getPropertyOrEnv(BROWSER_PROPERTY_NAME, DEFAULT_BROWSER);
            if ("FIREFOX".contentEquals(defaultBrowser)) {
                useThisDriver = BrowserName.FIREFOX;
            }
            if ("FIREFOXLEGACY".contentEquals(defaultBrowser)) {
                useThisDriver = BrowserName.FIREFOXLEGACY;
            }
            if ("FIREFOXPORTABLE".contentEquals(defaultBrowser)) {
                useThisDriver = BrowserName.FIREFOXPORTABLE;
            }
            if ("FIREFOXMARIONETTE".contentEquals(defaultBrowser)) {
                useThisDriver = BrowserName.FIREFOXMARIONETTE;
            }
            if ("CHROME".contentEquals(defaultBrowser)) {
                useThisDriver = BrowserName.GOOGLECHROME;
            }
            if (DEFAULT_BROWSER.contentEquals(defaultBrowser)) {
                useThisDriver = BrowserName.GOOGLECHROME;
            }
            if ("IE".contentEquals(defaultBrowser)) {
                useThisDriver = BrowserName.IE;
            }
            if ("EDGE".contentEquals(defaultBrowser)) {
                useThisDriver = BrowserName.EDGE;
            }
            if ("SAUCELABS".contentEquals(defaultBrowser)) {
                useThisDriver = BrowserName.SAUCELABS;
            }
            if ("HTMLUNIT".contentEquals(defaultBrowser)) {
                useThisDriver = BrowserName.HTMLUNIT;
            }
            if ("GRID".contentEquals(defaultBrowser)) {
                useThisDriver = BrowserName.GRID;
            }
            if ("APPIUM".contentEquals(defaultBrowser)) {
                useThisDriver = BrowserName.APPIUM;
            }
            if (useThisDriver == null) {
                throw new RuntimeException("Unknown Browser in selenium2basics.webdriver: " + defaultBrowser);
            }
        }
        if (aDriver == null) {
            long startBrowserTime = System.currentTimeMillis();
            switch (useThisDriver) {
                case FIREFOX: {
                    FirefoxProfile profile = new FirefoxProfile();
                    profile.setEnableNativeEvents(true);
                    DesiredCapabilities firefoxCapabilities = DesiredCapabilities.firefox();
                    Driver.setDriverPropertyIfNecessary("webdriver.gecko.driver", "/../tools/marionette/geckodriver.exe", "C://webdrivers/marionette/geckodriver.exe");
                    aDriver = new FirefoxDriver((Capabilities)firefoxCapabilities);
                    currentDriver = BrowserName.FIREFOX;
                    break;
                }
                case FIREFOXLEGACY: {
                    DesiredCapabilities legacyCapabilities = DesiredCapabilities.firefox();
                    legacyCapabilities.setCapability("marionette", false);
                    aDriver = new FirefoxDriver((Capabilities)legacyCapabilities);
                    currentDriver = BrowserName.FIREFOX;
                    break;
                }
                case FIREFOXPORTABLE: {
                    Driver.setDriverPropertyIfNecessary("seleniumsimplified.firefoxportable", "/../tools/FirefoxPortable/FirefoxPortable.exe", "C://webdrivers/FirefoxPortable/FirefoxPortable.exe");
                    DesiredCapabilities portableCapabilities = DesiredCapabilities.firefox();
                    portableCapabilities.setCapability("marionette", false);
                    portableCapabilities.setCapability("firefox_binary", new File(System.getProperty("seleniumsimplified.firefoxportable")).getAbsolutePath());
                    aDriver = new FirefoxDriver((Capabilities)portableCapabilities);
                    currentDriver = BrowserName.FIREFOX;
                    break;
                }
                case FIREFOXMARIONETTE: {
                    Driver.setDriverPropertyIfNecessary("webdriver.gecko.driver", "/../tools/marionette/geckodriver.exe", "C://webdrivers/marionette/geckodriver.exe");
                    aDriver = new MarionetteDriver();
                    currentDriver = BrowserName.FIREFOXMARIONETTE;
                    break;
                }
                case HTMLUNIT: {
                    aDriver = new HtmlUnitDriver(true);
                    currentDriver = BrowserName.HTMLUNIT;
                    break;
                }
                case IE: {
                    Driver.setDriverPropertyIfNecessary("webdriver.ie.driver", "/../tools/iedriver_32/IEDriverServer.exe", "C://webdrivers/iedriver_32/IEDriverServer.exe");
                    aDriver = new InternetExplorerDriver();
                    currentDriver = BrowserName.IE;
                    break;
                }
                case EDGE: {
                    Driver.setDriverPropertyIfNecessary("webdriver.edge.driver", "/../tools/edgedriver/MicrosoftWebDriver.exe", "C://webdrivers/edgedriver/MicrosoftWebDriver.exe");
                    aDriver = new EdgeDriver();
                    currentDriver = BrowserName.EDGE;
                    break;
                }
                case GOOGLECHROME: {
                    Driver.setDriverPropertyIfNecessary("webdriver.chrome.driver", "/../tools/chromedriver/chromedriver.exe", "C://webdrivers/chromedriver/chromedriver.exe");
                    ChromeOptions options = new ChromeOptions();
                    options.addArguments(new String[]{"disable-plugins"});
                    options.addArguments(new String[]{"disable-extensions"});
                    options.addArguments(new String[]{"test-type"});
                    DesiredCapabilities chromeCapabilities = DesiredCapabilities.chrome();
                    chromeCapabilities.setCapability("chromeOptions", (Object)options);
                    aDriver = new ChromeDriver((Capabilities)chromeCapabilities);
                    currentDriver = BrowserName.GOOGLECHROME;
                    break;
                }
                case SAUCELABS: {
                    DesiredCapabilities sauceCapabilities = DesiredCapabilities.firefox();
                    sauceCapabilities.setCapability("version", "5");
                    sauceCapabilities.setCapability("platform", Platform.XP);
                    try {
                        String sauceURL = System.getenv("SAUCELABS_URL");
                        aDriver = new RemoteWebDriver(new URL(sauceURL), (Capabilities)sauceCapabilities);
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                    currentDriver = BrowserName.SAUCELABS;
                    break;
                }
                case APPIUM: {
                    DesiredCapabilities appiumCapabilities = new DesiredCapabilities();
                    appiumCapabilities.setCapability("deviceName", EnvironmentPropertyReader.getPropertyOrEnv("APPIUM_DEVICE_NAME", ""));
                    appiumCapabilities.setCapability("platformName", Platform.ANDROID);
                    appiumCapabilities.setCapability("app", EnvironmentPropertyReader.getPropertyOrEnv("APPIUM_BROWSER", "browser"));
                    try {
                        String appiumURL = "http://127.0.0.1:4723/wd/hub";
                        aDriver = new RemoteWebDriver(new URL(appiumURL), (Capabilities)appiumCapabilities);
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                    currentDriver = BrowserName.APPIUM;
                    break;
                }
                case GRID: {
                    String gridBrowser = EnvironmentPropertyReader.getPropertyOrEnv("WEBDRIVER_GRID_BROWSER", "firefox");
                    String gridBrowserVersion = EnvironmentPropertyReader.getPropertyOrEnv("WEBDRIVER_GRID_BROWSER_VERSION", "");
                    String gridBrowserPlatform = EnvironmentPropertyReader.getPropertyOrEnv("WEBDRIVER_GRID_BROWSER_PLATFORM", "");
                    DesiredCapabilities gridCapabilities = new DesiredCapabilities();
                    gridCapabilities.setBrowserName(gridBrowser);
                    if (gridBrowserVersion.length() > 0) {
                        gridCapabilities.setVersion(gridBrowserVersion);
                    }
                    if (gridBrowserPlatform.length() > 0) {
                        gridCapabilities.setPlatform(Platform.fromString((String)gridBrowserPlatform));
                    }
                    Map<String, String> anyExtraCapabilities = System.getenv();
                    Driver.addAnyValidExtraCapabilityTo(gridCapabilities, anyExtraCapabilities.keySet());
                    Properties anyExtraCapabilityProperties = System.getProperties();
                    Driver.addAnyValidExtraCapabilityTo(gridCapabilities, anyExtraCapabilityProperties.stringPropertyNames());
                    try {
                        String gridURL = EnvironmentPropertyReader.getPropertyOrEnv("WEBDRIVER_GRID_URL", "http://localhost:4444/wd/hub");
                        aDriver = new RemoteWebDriver(new URL(gridURL), (Capabilities)gridCapabilities);
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                    currentDriver = BrowserName.GRID;
                    break;
                }
            }
            long browserStartedTime = System.currentTimeMillis();
            browserStartTime = browserStartedTime - startBrowserTime;
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    Driver.quit();
                }
            });
        } else {
            try {
                if (aDriver.getWindowHandle() == null) {
                    // empty if block
                }
            }
            catch (Exception e) {
                if (avoidRecursiveCall) {
                    throw new RuntimeException("something has gone wrong as we have been in Driver.get already");
                }
                Driver.quit();
                aDriver = null;
                avoidRecursiveCall = true;
                return Driver.get();
            }
            System.out.println("Saved another " + browserStartTime + "ms : total saved " + (savedTimecount += browserStartTime) + "ms");
        }
        avoidRecursiveCall = false;
        return aDriver;
    }

    public static BrowserName currentBrowser() {
        if (currentDriver == BrowserName.GRID) {
            String gridBrowser = EnvironmentPropertyReader.getPropertyOrEnv("WEBDRIVER_GRID_BROWSER", "firefox").toLowerCase();
            if (gridBrowser.contains("firefox")) {
                return BrowserName.FIREFOX;
            }
            if (gridBrowser.contains("chrome")) {
                return BrowserName.GOOGLECHROME;
            }
            if (gridBrowser.contains("ie")) {
                return BrowserName.IE;
            }
            if (gridBrowser.contains("html")) {
                return BrowserName.HTMLUNIT;
            }
        }
        if (currentDriver == BrowserName.SAUCELABS) {
            return BrowserName.FIREFOX;
        }
        return currentDriver;
    }

    private static void addAnyValidExtraCapabilityTo(DesiredCapabilities gridCapabilities, Set<String> possibleCapabilityKeys) {
        String extraCapabilityPrefix = "WEBDRIVER_GRID_CAP_X_";
        for (String capabilityName : possibleCapabilityKeys) {
            String capabilityValue;
            if (!capabilityName.startsWith(extraCapabilityPrefix) || (capabilityValue = EnvironmentPropertyReader.getPropertyOrEnv(capabilityName, "")).length() <= 0) continue;
            String capability = capabilityName.replaceFirst(extraCapabilityPrefix, "");
            System.out.println("To Set Capability " + capability + " with value " + capabilityValue);
            gridCapabilities.setCapability(capability, capabilityValue);
        }
    }

    private static void setDriverPropertyIfNecessary(String propertyKey, String relativeToUserPath, String absolutePath) {
        if (!System.getProperties().containsKey(propertyKey)) {
            String currentDir = System.getProperty("user.dir");
            String chromeDriverLocation = currentDir + relativeToUserPath;
            File driverExe = new File(chromeDriverLocation);
            if (driverExe.exists()) {
                System.setProperty(propertyKey, chromeDriverLocation);
            } else {
                driverExe = new File(absolutePath);
                if (driverExe.exists()) {
                    System.setProperty(propertyKey, absolutePath);
                }
            }
        }
    }

    public static WebDriver get(String aURL, boolean maximize) {
        block4: {
            Driver.get();
            aDriver.get(aURL);
            if (maximize) {
                try {
                    aDriver.manage().window().maximize();
                }
                catch (UnsupportedCommandException e) {
                    System.out.println("Remote Driver does not support maximise");
                }
                catch (WebDriverException e) {
                    if (currentDriver != BrowserName.APPIUM) break block4;
                    System.out.println("Appium does not support maximise");
                }
            }
        }
        return aDriver;
    }

    public static WebDriver get(String aURL) {
        return Driver.get(aURL, true);
    }

    public static void quit() {
        if (aDriver != null) {
            System.out.println("total time saved by reusing browsers " + savedTimecount + "ms");
            try {
                aDriver.quit();
                aDriver = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        useThisDriver = null;
        PROXYHOST = "localhost";
        PROXYPORT = "8888";
        PROXY = PROXYHOST + ":" + PROXYPORT;
    }

    public static enum BrowserName {
        FIREFOX,
        FIREFOXLEGACY,
        GOOGLECHROME,
        SAUCELABS,
        IE,
        HTMLUNIT,
        GRID,
        FIREFOXPORTABLE,
        FIREFOXMARIONETTE,
        APPIUM,
        EDGE;

    }
}

