/*
 * Decompiled with CFR 0.152.
 */
package uk.co.coen.capsulecrm.client;

import com.google.common.util.concurrent.Futures;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Response;
import java.io.IOException;
import java.util.concurrent.Future;
import org.joda.time.DateTime;
import uk.co.coen.capsulecrm.client.CCustomField;
import uk.co.coen.capsulecrm.client.CCustomFields;
import uk.co.coen.capsulecrm.client.CHistory;
import uk.co.coen.capsulecrm.client.CHistoryItem;
import uk.co.coen.capsulecrm.client.CTag;
import uk.co.coen.capsulecrm.client.CTask;
import uk.co.coen.capsulecrm.client.CTasks;
import uk.co.coen.capsulecrm.client.SimpleCapsuleEntity;
import uk.co.coen.capsulecrm.client.TaskStatus;
import uk.co.coen.capsulecrm.client.utils.ListenableFutureAdapter;
import uk.co.coen.capsulecrm.client.utils.UnmarshalResponseBody;

public abstract class CapsuleEntity
extends SimpleCapsuleEntity {
    public DateTime createdOn;
    public DateTime updatedOn;

    public Future<CCustomFields> listCustomFields() throws IOException {
        return Futures.transform(new ListenableFutureAdapter(((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareGet(capsuleUrl + "/api" + this.readContextPath() + "/" + this.id + "/customfield").addHeader("Accept", "application/xml").setRealm(realm)).execute()), new UnmarshalResponseBody(xstream));
    }

    public Future<Response> add(final CCustomField cCustomField) throws IOException {
        if (cCustomField.id != null) {
            return ((AsyncHttpClient.BoundRequestBuilder)((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.preparePut(capsuleUrl + "/api" + this.readContextPath() + "/" + this.id + "/customfield/" + cCustomField.id).addHeader("Content-Type", "application/xml").setRealm(realm)).setBodyEncoding("UTF-8")).setBody(xstream.toXML((Object)cCustomField)).execute();
        }
        return ((AsyncHttpClient.BoundRequestBuilder)((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.preparePost(capsuleUrl + "/api" + this.readContextPath() + "/" + this.id + "/customfield").addHeader("Content-Type", "application/xml").setRealm(realm)).setBodyEncoding("UTF-8")).setBody(xstream.toXML((Object)cCustomField)).execute((AsyncHandler)new AsyncCompletionHandler<Response>(){

            public Response onCompleted(Response response) throws Exception {
                String string = response.getHeader("Location");
                if (string == null) {
                    throw new RuntimeException("null location, cannot assign id to custom field " + (Object)((Object)this) + ", status is " + response.getStatusCode() + " " + response.getStatusText());
                }
                cCustomField.id = Integer.parseInt(string.substring(string.lastIndexOf("/") + 1));
                return response;
            }
        });
    }

    public Future<Response> remove(CCustomField cCustomField) throws IOException {
        return ((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareDelete(capsuleUrl + "/api" + this.readContextPath() + "/" + this.id + "/customfield/" + cCustomField.id).setRealm(realm)).execute();
    }

    public Future<CHistory> listHistory() throws IOException {
        return Futures.transform(new ListenableFutureAdapter(((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareGet(capsuleUrl + "/api" + this.readContextPath() + "/" + this.id + "/history").addHeader("Accept", "application/xml").setRealm(realm)).execute()), new UnmarshalResponseBody(xstream));
    }

    public Future<Response> add(final CHistoryItem cHistoryItem) throws IOException {
        if (cHistoryItem.id != null) {
            return ((AsyncHttpClient.BoundRequestBuilder)((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.preparePut(capsuleUrl + "/api" + this.readContextPath() + "/" + this.id + "/history/" + cHistoryItem.id).addHeader("Content-Type", "application/xml").setRealm(realm)).setBodyEncoding("UTF-8")).setBody(xstream.toXML((Object)cHistoryItem)).execute();
        }
        return ((AsyncHttpClient.BoundRequestBuilder)((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.preparePost(capsuleUrl + "/api" + this.readContextPath() + "/" + this.id + "/history").addHeader("Content-Type", "application/xml").setRealm(realm)).setBodyEncoding("UTF-8")).setBody(xstream.toXML((Object)cHistoryItem)).execute((AsyncHandler)new AsyncCompletionHandler<Response>(){

            public Response onCompleted(Response response) throws Exception {
                String string = response.getHeader("Location");
                if (string == null) {
                    throw new RuntimeException("null location, cannot assign id to history item " + (Object)((Object)this) + ", status is " + response.getStatusCode() + " " + response.getStatusText());
                }
                cHistoryItem.id = Integer.parseInt(string.substring(string.lastIndexOf("/") + 1));
                return response;
            }
        });
    }

    public Future<Response> remove(CHistoryItem cHistoryItem) throws IOException {
        return ((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareDelete(capsuleUrl + "/api" + this.readContextPath() + "/" + this.id + "/history/" + cHistoryItem.id).setRealm(realm)).execute();
    }

    public Future<Response> add(CTag cTag) throws IOException {
        return ((AsyncHttpClient.BoundRequestBuilder)((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.preparePost(capsuleUrl + "/api" + this.readContextPath() + "/" + this.id + "/tag/" + cTag.name).addHeader("Content-Type", "application/xml").setRealm(realm)).setBodyEncoding("UTF-8")).setBody(xstream.toXML((Object)cTag)).execute();
    }

    public Future<Response> remove(CTag cTag) throws IOException {
        return ((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareDelete(capsuleUrl + "/api" + this.readContextPath() + "/" + this.id + "/tag/" + cTag.name).setRealm(realm)).execute();
    }

    public Future<CTasks> listTasks() throws IOException {
        return Futures.transform(new ListenableFutureAdapter(((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareGet(capsuleUrl + "/api" + this.readContextPath() + "/" + this.id + "/tasks").addHeader("Accept", "application/xml").setRealm(realm)).execute()), new UnmarshalResponseBody(xstream));
    }

    public Future<CTasks> listTasks(TaskStatus taskStatus) throws IOException {
        return Futures.transform(new ListenableFutureAdapter(((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.prepareGet(capsuleUrl + "/api" + this.readContextPath() + "/" + this.id + "/tasks").addQueryParameter("status", taskStatus.name()).addHeader("Accept", "application/xml").setRealm(realm)).execute()), new UnmarshalResponseBody(xstream));
    }

    public Future<Response> add(final CTask cTask) throws IOException {
        return ((AsyncHttpClient.BoundRequestBuilder)((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.preparePost(capsuleUrl + "/api" + this.readContextPath() + "/" + this.id + "/task").addHeader("Content-Type", "application/xml").setRealm(realm)).setBodyEncoding("UTF-8")).setBody(xstream.toXML((Object)cTask)).execute((AsyncHandler)new AsyncCompletionHandler<Response>(){

            public Response onCompleted(Response response) throws Exception {
                String string = response.getHeader("Location");
                if (string == null) {
                    throw new RuntimeException("null location, cannot assign id to task " + (Object)((Object)this) + ", status is " + response.getStatusCode() + " " + response.getStatusText());
                }
                cTask.id = Integer.parseInt(string.substring(string.lastIndexOf("/") + 1));
                return response;
            }
        });
    }
}

