/*
 * Decompiled with CFR 0.152.
 */
package uk.co.coen.capsulecrm.client;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import play.Play;
import play.libs.F;
import play.libs.WS;
import uk.co.coen.capsulecrm.client.CAddress;
import uk.co.coen.capsulecrm.client.CAttachment;
import uk.co.coen.capsulecrm.client.CCustomField;
import uk.co.coen.capsulecrm.client.CCustomFields;
import uk.co.coen.capsulecrm.client.CEmail;
import uk.co.coen.capsulecrm.client.CHistory;
import uk.co.coen.capsulecrm.client.CHistoryItem;
import uk.co.coen.capsulecrm.client.CIdentifiable;
import uk.co.coen.capsulecrm.client.CMilestone;
import uk.co.coen.capsulecrm.client.CMilestones;
import uk.co.coen.capsulecrm.client.COpportunities;
import uk.co.coen.capsulecrm.client.COpportunity;
import uk.co.coen.capsulecrm.client.COrganisation;
import uk.co.coen.capsulecrm.client.CParties;
import uk.co.coen.capsulecrm.client.CPerson;
import uk.co.coen.capsulecrm.client.CPhone;
import uk.co.coen.capsulecrm.client.CTag;
import uk.co.coen.capsulecrm.client.CTags;
import uk.co.coen.capsulecrm.client.CTask;
import uk.co.coen.capsulecrm.client.CTasks;
import uk.co.coen.capsulecrm.client.CUser;
import uk.co.coen.capsulecrm.client.CWebsite;
import uk.co.coen.capsulecrm.client.utils.JodaDateTimeXStreamConverter;

public abstract class SimpleCapsuleEntity
extends CIdentifiable {
    static final XStream xstream = new XStream();
    static final String capsuleUrl;
    static final String capsuleToken;

    protected abstract String readContextPath();

    protected String writeContextPath() {
        return this.readContextPath();
    }

    public F.Promise<WS.Response> save() {
        OutputStreamWriter outputStreamWriter;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
            outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        xstream.toXML((Object)this, (Writer)outputStreamWriter);
        if (this.id != null) {
            return WS.url((String)(capsuleUrl + "/api" + this.writeContextPath() + "/" + this.id)).setHeader("Content-Type", "text/xml; charset=utf-8").setAuth(capsuleToken, "").put((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        }
        return WS.url((String)(capsuleUrl + "/api" + this.writeContextPath())).setHeader("Content-Type", "text/xml; charset=utf-8").setAuth(capsuleToken, "").post((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray())).map((F.Function)new F.Function<WS.Response, WS.Response>(){

            public WS.Response apply(WS.Response response) throws Throwable {
                String string = response.getHeader("Location");
                if (string == null) {
                    throw new RuntimeException("null location, cannot assign id to " + this + ", status is " + response.getStatus() + " " + response.getStatusText());
                }
                SimpleCapsuleEntity.this.id = Integer.parseInt(string.substring(string.lastIndexOf("/") + 1));
                return response;
            }
        });
    }

    public F.Promise<WS.Response> delete() {
        return WS.url((String)(capsuleUrl + "/api" + this.readContextPath() + "/" + this.id)).setAuth(capsuleToken, "").delete();
    }

    static {
        xstream.registerConverter((Converter)new JodaDateTimeXStreamConverter());
        xstream.addDefaultImplementation(ArrayList.class, List.class);
        xstream.alias("attachment", CAttachment.class);
        xstream.alias("organisation", COrganisation.class);
        xstream.alias("person", CPerson.class);
        xstream.alias("address", CAddress.class);
        xstream.alias("website", CWebsite.class);
        xstream.alias("email", CEmail.class);
        xstream.alias("phone", CPhone.class);
        xstream.alias("tags", CTags.class);
        xstream.aliasAttribute(CTags.class, "size", "size");
        xstream.addImplicitCollection(CTags.class, "tags", CTag.class);
        xstream.alias("tag", CTag.class);
        xstream.alias("tasks", CTasks.class);
        xstream.aliasAttribute(CTasks.class, "size", "size");
        xstream.addImplicitCollection(CTasks.class, "tasks", CTask.class);
        xstream.alias("task", CTask.class);
        xstream.alias("users", CTasks.class);
        xstream.addImplicitCollection(CUser.class, "users", CUser.class);
        xstream.alias("user", CUser.class);
        xstream.alias("history", CHistory.class);
        xstream.aliasAttribute(CHistory.class, "size", "size");
        xstream.addImplicitCollection(CHistory.class, "historyItems", CHistoryItem.class);
        xstream.alias("historyItem", CHistoryItem.class);
        xstream.alias("parties", CParties.class);
        xstream.aliasAttribute(CParties.class, "size", "size");
        xstream.addImplicitCollection(CParties.class, "organisations", COrganisation.class);
        xstream.addImplicitCollection(CParties.class, "persons", CPerson.class);
        xstream.alias("customField", CCustomField.class);
        xstream.alias("customFields", CCustomFields.class);
        xstream.aliasAttribute(CCustomFields.class, "size", "size");
        xstream.addImplicitCollection(CCustomFields.class, "customFields", CCustomField.class);
        xstream.alias("opportunities", COpportunities.class);
        xstream.addImplicitCollection(COpportunities.class, "opportunities", COpportunity.class);
        xstream.alias("opportunity", COpportunity.class);
        xstream.alias("milestones", CMilestones.class);
        xstream.addImplicitCollection(CMilestones.class, "milestones", CMilestone.class);
        xstream.alias("milestone", CMilestone.class);
        capsuleUrl = Play.application().configuration().getString("capsulecrm.url");
        capsuleToken = Play.application().configuration().getString("capsulecrm.token");
    }
}

