/*
 * Decompiled with CFR 0.152.
 */
package uk.co.coen.capsulecrm.client;

import com.google.common.base.Objects;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.DomReader;
import org.joda.time.DateTime;
import play.libs.F;
import play.libs.WS;
import uk.co.coen.capsulecrm.client.CTasks;
import uk.co.coen.capsulecrm.client.SimpleCapsuleEntity;
import uk.co.coen.capsulecrm.client.TaskStatus;

public class CTask
extends SimpleCapsuleEntity {
    public String description;
    public String detail;
    public String category;
    public TaskStatus status;
    public DateTime dueDate;
    public DateTime dueDateTime;
    public DateTime completedOn;
    public String owner;
    public Integer partyId;
    public String partyName;
    public Integer caseId;
    public String caseName;
    public Integer opportunityId;
    public String opportunityName;

    public CTask() {
    }

    public CTask(String string, DateTime dateTime, boolean bl) {
        this(string, null, dateTime, bl);
    }

    public CTask(String string, String string2, DateTime dateTime, boolean bl) {
        this.description = string;
        this.detail = string2;
        if (bl) {
            this.dueDateTime = dateTime;
        } else {
            this.dueDate = dateTime;
        }
    }

    @Override
    protected String readContextPath() {
        return "/task";
    }

    public static F.Promise<CTasks> list() {
        return CTask.list(null, null, null, 0, 0);
    }

    public static F.Promise<CTasks> list(int n, int n2) {
        return CTask.list(null, null, null, n, n2);
    }

    public static F.Promise<CTasks> list(TaskStatus taskStatus) {
        return CTask.list(null, null, taskStatus, 0, 0);
    }

    public static F.Promise<CTasks> list(TaskStatus taskStatus, int n, int n2) {
        return CTask.list(null, null, taskStatus, n, n2);
    }

    public static F.Promise<CTasks> list(String string, String string2, TaskStatus taskStatus, int n, int n2) {
        WS.WSRequestHolder wSRequestHolder = WS.url((String)(capsuleUrl + "/api/tasks"));
        if (string != null) {
            wSRequestHolder.setQueryParameter("category", string);
        }
        if (string2 != null) {
            wSRequestHolder.setQueryParameter("user", string2);
        }
        if (taskStatus != null) {
            wSRequestHolder.setQueryParameter("status", taskStatus.name());
        }
        if (n != 0) {
            wSRequestHolder.setQueryParameter("start", "" + n);
        }
        if (n2 != 0) {
            wSRequestHolder.setQueryParameter("limit", "" + n2);
        }
        return wSRequestHolder.setHeader("Content-Type", "text/xml; charset=utf-8").setAuth(capsuleToken, "").get().map((F.Function)new F.Function<WS.Response, CTasks>(){

            public CTasks apply(WS.Response response) throws Throwable {
                return (CTasks)SimpleCapsuleEntity.xstream.unmarshal((HierarchicalStreamReader)new DomReader(response.asXml()));
            }
        });
    }

    public F.Promise<WS.Response> complete() {
        return WS.url((String)(capsuleUrl + "/api/task/" + this.id + "/complete")).setHeader("Content-Type", "text/xml; charset=utf-8").setAuth(capsuleToken, "").post("");
    }

    public F.Promise<WS.Response> reopen() {
        return WS.url((String)(capsuleUrl + "/api/task/" + this.id + "/reopen")).setHeader("Content-Type", "text/xml; charset=utf-8").setAuth(capsuleToken, "").post("");
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("description", (Object)this.description).add("detail", (Object)this.detail).add("category", (Object)this.category).add("status", (Object)this.status).add("dueDate", (Object)this.dueDate).add("dueDateTime", (Object)this.dueDateTime).add("completedOn", (Object)this.completedOn).add("owner", (Object)this.owner).add("partyId", (Object)this.partyId).add("partyName", (Object)this.partyName).add("caseId", (Object)this.caseId).add("caseName", (Object)this.caseName).add("opportunityId", (Object)this.opportunityId).add("opportunityName", (Object)this.opportunityName).toString();
    }
}

