/*
 * Decompiled with CFR 0.152.
 */
package uk.co.coen.capsulecrm.client;

import com.google.common.collect.Lists;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.DomReader;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import play.libs.F;
import play.libs.WS;
import uk.co.coen.capsulecrm.client.CAddress;
import uk.co.coen.capsulecrm.client.CContact;
import uk.co.coen.capsulecrm.client.CEmail;
import uk.co.coen.capsulecrm.client.CParties;
import uk.co.coen.capsulecrm.client.CPhone;
import uk.co.coen.capsulecrm.client.CWebsite;
import uk.co.coen.capsulecrm.client.CapsuleEntity;
import uk.co.coen.capsulecrm.client.SimpleCapsuleEntity;
import uk.co.coen.capsulecrm.client.WebService;

public abstract class CParty
extends CapsuleEntity {
    public List<CContact> contacts;
    public String about;
    public String pictureURL;

    public abstract String getName();

    public void addContact(CContact cContact) {
        if (this.contacts == null) {
            this.contacts = Lists.newArrayList();
        }
        this.contacts.add(cContact);
    }

    public CAddress firstAddress() {
        for (CContact cContact : this.contacts) {
            if (!(cContact instanceof CAddress)) continue;
            return (CAddress)cContact;
        }
        return null;
    }

    public CEmail firstEmail() {
        for (CContact cContact : this.contacts) {
            if (!(cContact instanceof CEmail)) continue;
            return (CEmail)cContact;
        }
        return null;
    }

    public CPhone firstPhone() {
        for (CContact cContact : this.contacts) {
            if (!(cContact instanceof CPhone)) continue;
            return (CPhone)cContact;
        }
        return null;
    }

    public CWebsite firstWebsite() {
        return this.firstWebsite(null);
    }

    public CWebsite firstWebsite(WebService webService) {
        for (CContact cContact : this.contacts) {
            if (!(cContact instanceof CWebsite)) continue;
            CWebsite cWebsite = (CWebsite)cContact;
            if (webService != null && webService != cWebsite.webService) continue;
            return (CWebsite)cContact;
        }
        return null;
    }

    @Override
    public String readContextPath() {
        return "/party";
    }

    public static F.Promise<CParties> search(String string) {
        return CParty.search(string, 12L, TimeUnit.SECONDS);
    }

    public static F.Promise<CParties> search(String string, long l, TimeUnit timeUnit) {
        return WS.url((String)(capsuleUrl + "/api/party")).setTimeout((int)timeUnit.toMillis(l)).setQueryParameter("q", string).setHeader("Content-Type", "text/xml; charset=utf-8").setAuth(capsuleToken, "").get().map((F.Function)new F.Function<WS.Response, CParties>(){

            public CParties apply(WS.Response response) throws Throwable {
                return (CParties)SimpleCapsuleEntity.xstream.unmarshal((HierarchicalStreamReader)new DomReader(response.asXml()));
            }
        });
    }

    public static F.Promise<CParties> listAll() {
        return CParty.listAll(12L, TimeUnit.SECONDS);
    }

    public static F.Promise<CParties> listAll(long l, TimeUnit timeUnit) {
        return WS.url((String)(capsuleUrl + "/api/party")).setTimeout((int)timeUnit.toMillis(l)).setHeader("Content-Type", "text/xml; charset=utf-8").setAuth(capsuleToken, "").get().map((F.Function)new F.Function<WS.Response, CParties>(){

            public CParties apply(WS.Response response) throws Throwable {
                if (response.getStatus() == 401) {
                    throw new RuntimeException("Not Authorized, check your Play configuration.");
                }
                return (CParties)SimpleCapsuleEntity.xstream.unmarshal((HierarchicalStreamReader)new DomReader(response.asXml()));
            }
        });
    }

    public static F.Promise<CParties> listModifiedSince(DateTime dateTime) {
        return CParty.listModifiedSince(dateTime, 12L, TimeUnit.SECONDS);
    }

    public static F.Promise<CParties> listModifiedSince(DateTime dateTime, long l, TimeUnit timeUnit) {
        return WS.url((String)(capsuleUrl + "/api/party")).setTimeout((int)timeUnit.toMillis(l)).setQueryParameter("lastmodified", dateTime.toString("yyyyMMdd'T'HHmmss")).setHeader("Content-Type", "text/xml; charset=utf-8").setAuth(capsuleToken, "").get().map((F.Function)new F.Function<WS.Response, CParties>(){

            public CParties apply(WS.Response response) throws Throwable {
                return (CParties)SimpleCapsuleEntity.xstream.unmarshal((HierarchicalStreamReader)new DomReader(response.asXml()));
            }
        });
    }

    public static F.Promise<CParties> listByEmailAddress(String string) {
        return CParty.listByEmailAddress(string, 12L, TimeUnit.SECONDS);
    }

    public static F.Promise<CParties> listByEmailAddress(String string, long l, TimeUnit timeUnit) {
        return WS.url((String)(capsuleUrl + "/api/party")).setTimeout((int)timeUnit.toMillis(l)).setQueryParameter("email", string).setHeader("Content-Type", "text/xml; charset=utf-8").setAuth(capsuleToken, "").get().map((F.Function)new F.Function<WS.Response, CParties>(){

            public CParties apply(WS.Response response) throws Throwable {
                return (CParties)SimpleCapsuleEntity.xstream.unmarshal((HierarchicalStreamReader)new DomReader(response.asXml()));
            }
        });
    }

    public static F.Promise<CParties> listByTag(String string) {
        return CParty.listByTag(string, 12L, TimeUnit.SECONDS);
    }

    public static F.Promise<CParties> listByTag(String string, long l, TimeUnit timeUnit) {
        return WS.url((String)(capsuleUrl + "/api/party")).setTimeout((int)timeUnit.toMillis(l)).setQueryParameter("tag", string).setHeader("Content-Type", "text/xml; charset=utf-8").setAuth(capsuleToken, "").get().map((F.Function)new F.Function<WS.Response, CParties>(){

            public CParties apply(WS.Response response) throws Throwable {
                return (CParties)SimpleCapsuleEntity.xstream.unmarshal((HierarchicalStreamReader)new DomReader(response.asXml()));
            }
        });
    }

    public static F.Promise<CParty> byId(Integer n) {
        return WS.url((String)(capsuleUrl + "/api/party/" + n)).setHeader("Content-Type", "text/xml; charset=utf-8").setAuth(capsuleToken, "").get().map((F.Function)new F.Function<WS.Response, CParty>(){

            public CParty apply(WS.Response response) throws Throwable {
                if (response.getStatus() < 200 || response.getStatus() > 299) {
                    throw new IllegalStateException("Response is not OK: " + response.getStatus() + " " + response.getStatusText());
                }
                return (CParty)SimpleCapsuleEntity.xstream.unmarshal((HierarchicalStreamReader)new DomReader(response.asXml()));
            }
        });
    }

    public F.Promise<WS.Response> deleteContact(CContact cContact) {
        return WS.url((String)(capsuleUrl + "/api/party/" + this.id + "/contact/" + cContact.id)).setAuth(capsuleToken, "").delete();
    }
}

