/*
 * Decompiled with CFR 0.152.
 */
package uk.co.baconi.secure.api.exceptions;

import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import uk.co.baconi.secure.api.exceptions.BaseErrorResponse;
import uk.co.baconi.secure.api.exceptions.ExceptionResponse;
import uk.co.baconi.secure.api.exceptions.ValidationResponse;

@ControllerAdvice(annotations={RestController.class})
public class GlobalExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @Order(value=0x7FFFFFFF)
    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ExceptionResponse> handleExceptions(HttpServletRequest request, Exception exception) {
        return this.handleResponse((BaseErrorResponse)new ExceptionResponse(exception), request, HttpStatus.INTERNAL_SERVER_ERROR, exception);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseEntity<ValidationResponse> handleResourceNotFoundException(HttpServletRequest request, ConstraintViolationException exception) {
        return this.handleValidationResponse(new ValidationResponse(exception), request, (Exception)exception);
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public ResponseEntity<ValidationResponse> handleMethodArgumentTypeMismatchException(HttpServletRequest request, MethodArgumentTypeMismatchException exception) {
        return this.handleValidationResponse(new ValidationResponse(exception), request, (Exception)exception);
    }

    private ResponseEntity<ValidationResponse> handleValidationResponse(ValidationResponse response, HttpServletRequest request, Exception exception) {
        return this.handleResponse((BaseErrorResponse)response, request, HttpStatus.BAD_REQUEST, exception);
    }

    private <A extends BaseErrorResponse> ResponseEntity<A> handleResponse(A response, HttpServletRequest request, HttpStatus httpStatus, Exception exception) {
        LOG.error("Error [{}] on url [{}] of [{}] with message [{}]", new Object[]{response.getUuid(), request.getRequestURL(), exception.getClass().getName(), exception.getMessage()});
        LOG.debug("Stacktrace for [{}]:", (Object)response.getUuid(), (Object)exception);
        LOG.trace("Response for [{}]:", (Object)response.getUuid(), response);
        return ResponseEntity.status((HttpStatus)httpStatus).body(response);
    }
}

