/*
 * Decompiled with CFR 0.152.
 */
package gate.test;

import gate.Gate;
import gate.creole.Plugin;
import gate.creole.ResourceInstantiationException;
import gate.util.Files;
import gate.util.asm.ClassReader;
import gate.util.asm.ClassVisitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class GATEPluginTestCase
extends TestCase {
    protected Plugin.Maven pluginUnderTest = null;

    public void setUp() throws Exception {
        this.pluginUnderTest = GATEPluginTestCase.loadPlugin();
    }

    protected static Plugin.Maven loadPlugin() throws Exception {
        URL creoleUrl;
        if (!Gate.isInitialised()) {
            Gate.runInSandbox((boolean)true);
            Gate.init();
        }
        if ((creoleUrl = GATEPluginTestCase.class.getResource("/creole.xml")) == null) {
            throw new ResourceInstantiationException("Could not load plugin, creole.xml not found");
        }
        Properties properties = new Properties();
        URL propsUrl = GATEPluginTestCase.class.getResource("/creole.properties");
        if (propsUrl == null) {
            throw new ResourceInstantiationException("Could not load plugin, creole.properties not found");
        }
        InputStream propsStream = propsUrl.openStream();
        properties.load(propsStream);
        PluginUnderTest plugin = new PluginUnderTest(Files.fileFromURL((URL)creoleUrl), properties.getProperty("groupId"), properties.getProperty("artifactId"), properties.getProperty("version"));
        if (!Gate.getCreoleRegister().getPlugins().contains((Object)plugin)) {
            Gate.getCreoleRegister().registerPlugin((Plugin)plugin);
        }
        return plugin;
    }

    static class PluginUnderTest
    extends Plugin.Maven {
        private static final long serialVersionUID = -7173026992962397847L;
        private File creoleFile;

        public PluginUnderTest(File creoleFile, String group, String artifact, String version) throws MalformedURLException {
            super(group, artifact, version);
            this.creoleFile = creoleFile;
            this.baseURL = new URL(creoleFile.toURI().toURL(), ".");
        }

        public Document getMetadataXML() throws Exception {
            return this.getCreoleXML();
        }

        public Document getCreoleXML() throws Exception {
            SAXBuilder builder = new SAXBuilder(false);
            Document jdomDoc = builder.build((InputStream)new FileInputStream(this.creoleFile), this.getBaseURL().toExternalForm());
            Element creoleRoot = jdomDoc.getRootElement();
            creoleRoot.setAttribute("VERSION", this.getVersion());
            HashSet<String> resources = new HashSet<String>();
            String dir = this.creoleFile.getParent();
            if (!dir.endsWith(File.separator)) {
                dir = dir + File.separator;
            }
            this.scanDir(dir.length(), this.creoleFile.getParentFile(), resources);
            for (String resource : resources) {
                Element resourceElement = new Element("RESOURCE");
                Element classElement = new Element("CLASS");
                classElement.setText(resource);
                resourceElement.addContent((Content)classElement);
                creoleRoot.addContent((Content)resourceElement);
            }
            return jdomDoc;
        }

        private void scanDir(int prefix, File dir, Set<String> resources) throws IOException {
            for (File file : dir.listFiles()) {
                if (file.isDirectory()) {
                    this.scanDir(prefix, file, resources);
                    continue;
                }
                if (!file.getName().endsWith(".class")) continue;
                String className = file.getAbsolutePath().substring(prefix);
                className = className.substring(0, className.length() - 6).replace(File.separator, ".");
                ClassReader classReader = new ClassReader((InputStream)new FileInputStream(file));
                Gate.ResourceInfo resInfo = new Gate.ResourceInfo(null, className, null);
                Plugin.ResourceInfoVisitor visitor = new Plugin.ResourceInfoVisitor(resInfo);
                classReader.accept((ClassVisitor)visitor, 7);
                if (!visitor.isCreoleResource()) continue;
                resources.add(className);
            }
        }
    }
}

