/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.configurate;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.InetSocketAddress;
import java.util.function.Predicate;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.SerializationException;

public final class AddressSerializer
extends ScalarSerializer<InetSocketAddress> {
    public static final AddressSerializer INSTANCE = new AddressSerializer();

    private AddressSerializer() {
        super(InetSocketAddress.class);
    }

    public InetSocketAddress deserialize(Type type, Object obj) throws SerializationException {
        String address = obj.toString();
        String trim = address.trim();
        String[] split = trim.split(":");
        if (split.length != 2) {
            throw new SerializationException("The node has to be in a X:Y format to deserialize!");
        }
        return new InetSocketAddress(split[0], new BigDecimal(split[1]).intValueExact());
    }

    protected Object serialize(InetSocketAddress item, Predicate<Class<?>> typeSupported) {
        return item.getHostName() + ":" + item.getPort();
    }
}

