/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.files;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;
import org.spongepowered.configurate.objectmapping.meta.Setting;
import tr.com.infumia.infumialib.configurate.InfumiaCollection;

@ConfigSerializable
public final class InfumiaConfig {
    @NotNull
    private static InfumiaConfig INSTANCE = new InfumiaConfig();
    @Setting
    @Comment(value="Cert chain file.")
    private Path certChainFile = Path.of("secrets/certChain", new String[0]);
    @Setting
    @Comment(value="Checks update for the Infumia library plugin.")
    private boolean checkForUpdate = true;
    @Setting
    @Comment(value="The http api's endpoint address.")
    private String endpoint = "api.infumia.net";
    @Setting
    @Comment(value="Whether enable multiple server support or not.")
    private boolean multiServer = false;
    @Setting
    @Comment(value="Private key file.")
    private Path privateKeyFile = Path.of("secrets/privateKey", new String[0]);
    @Setting
    @Comment(value="Private key password.")
    @Nullable
    private String privateKeyPassword = null;
    @Setting
    @Comment(value="Server's group.")
    private String serverGroup = "base";
    @Setting
    @Comment(value="Server's name.")
    private String serverName = UUID.randomUUID().toString();

    public static boolean checkCredentialFiles() {
        InfumiaConfig instance = InfumiaConfig.instance();
        return Files.notExists(instance.certChainFile(), new LinkOption[0]) || Files.notExists(instance.privateKeyFile(), new LinkOption[0]);
    }

    public static void init(@NotNull Path directory) throws ConfigurateException {
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(directory.resolve("config.conf"))).defaultOptions(options -> options.implicitInitialization(false).serializers(builder -> builder.registerAll(InfumiaCollection.COLLECTION)))).build();
        CommentedConfigurationNode node = (CommentedConfigurationNode)loader.load();
        INSTANCE = (InfumiaConfig)node.get(InfumiaConfig.class, (Object)new InfumiaConfig());
        node.set(InfumiaConfig.class, (Object)INSTANCE);
        loader.save((ConfigurationNode)node);
    }

    @NotNull
    public static InfumiaConfig instance() {
        return INSTANCE;
    }

    public Path certChainFile() {
        return this.certChainFile;
    }

    public boolean checkForUpdate() {
        return this.checkForUpdate;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public boolean multiServer() {
        return this.multiServer;
    }

    public Path privateKeyFile() {
        return this.privateKeyFile;
    }

    @Nullable
    public String privateKeyPassword() {
        return this.privateKeyPassword;
    }

    public String serverGroup() {
        return this.serverGroup;
    }

    public String serverName() {
        return this.serverName;
    }

    public InfumiaConfig certChainFile(Path certChainFile) {
        this.certChainFile = certChainFile;
        return this;
    }

    public InfumiaConfig checkForUpdate(boolean checkForUpdate) {
        this.checkForUpdate = checkForUpdate;
        return this;
    }

    public InfumiaConfig endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public InfumiaConfig multiServer(boolean multiServer) {
        this.multiServer = multiServer;
        return this;
    }

    public InfumiaConfig privateKeyFile(Path privateKeyFile) {
        this.privateKeyFile = privateKeyFile;
        return this;
    }

    public InfumiaConfig privateKeyPassword(@Nullable String privateKeyPassword) {
        this.privateKeyPassword = privateKeyPassword;
        return this;
    }

    public InfumiaConfig serverGroup(String serverGroup) {
        this.serverGroup = serverGroup;
        return this;
    }

    public InfumiaConfig serverName(String serverName) {
        this.serverName = serverName;
        return this;
    }
}

