/*
 * Decompiled with CFR 0.152.
 */
package top.wboost.common.utils.web.interfaces.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.ContextStartedEvent;
import org.springframework.context.event.ContextStoppedEvent;
import org.springframework.core.OrderComparator;
import top.wboost.common.utils.web.interfaces.context.EzApplicationListener;
import top.wboost.common.utils.web.utils.SpringApplicationUtil;

public interface EzApplicationListenerManager
extends ApplicationListener<ApplicationEvent> {
    default public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextClosedEvent) {
            this.onContextClosedEvent((ContextClosedEvent)event);
        } else if (event instanceof ContextRefreshedEvent) {
            this.onContextRefreshedEvent((ContextRefreshedEvent)event);
        } else if (event instanceof ContextStartedEvent) {
            this.onContextStartedEvent((ContextStartedEvent)event);
        } else if (event instanceof ContextStoppedEvent) {
            this.onContextStoppedEvent((ContextStoppedEvent)event);
        }
    }

    default public void onContextStoppedEvent(ContextStoppedEvent event) {
    }

    default public void onContextStartedEvent(ContextStartedEvent event) {
    }

    default public void onContextClosedEvent(ContextClosedEvent event) {
    }

    default public void onContextRefreshedEvent(ContextRefreshedEvent event) {
        ApplicationContext parentContext = event.getApplicationContext().getParent();
        ArrayList<EzApplicationListener> ezApplicationListeners = new ArrayList<EzApplicationListener>(this.getEzApplicationListeners(event.getApplicationContext()));
        ezApplicationListeners.sort((Comparator<EzApplicationListener>)OrderComparator.INSTANCE);
        if (!SpringApplicationUtil.isBootApplicationContext(event)) {
            for (EzApplicationListener ezApplicationListener : ezApplicationListeners) {
                if (parentContext != null) {
                    ezApplicationListener.onWebApplicationEvent(event);
                    continue;
                }
                ezApplicationListener.onRootApplicationEvent(event);
            }
        } else {
            for (EzApplicationListener ezApplicationListener : ezApplicationListeners) {
                ezApplicationListener.onBootApplicationEvent(event);
                if (!ezApplicationListener.doWebAndRootApplicationListener(event)) continue;
                ezApplicationListener.onRootApplicationEvent(event);
            }
            for (EzApplicationListener ezApplicationListener : ezApplicationListeners) {
                if (!ezApplicationListener.doWebAndRootApplicationListener(event)) continue;
                ezApplicationListener.onWebApplicationEvent(event);
            }
        }
    }

    public Collection<EzApplicationListener> getEzApplicationListeners(ApplicationContext var1);

    public void setEzApplicationListeners(Collection<EzApplicationListener> var1);
}

