/*
 * Decompiled with CFR 0.152.
 */
package top.wboost.common.utils.web.core;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePropertySource;
import org.springframework.util.StringValueResolver;
import org.springframework.web.context.support.StandardServletEnvironment;
import top.wboost.common.base.enums.CharsetEnum;
import top.wboost.common.log.entity.Logger;
import top.wboost.common.log.util.LoggerUtil;
import top.wboost.common.util.StringUtil;
import top.wboost.common.utils.web.core.PropertiesAware;
import top.wboost.common.utils.web.interfaces.context.EzRootApplicationListener;
import top.wboost.common.utils.web.utils.PropertiesUtil;

public class ConfigProperties
implements BeanDefinitionRegistryPostProcessor,
EzRootApplicationListener,
EnvironmentAware,
EmbeddedValueResolverAware,
PriorityOrdered {
    public static final String DEFAULT_PROPERTIES = "classpath*:properties/common-default.properties";
    public static final String SYS_PROPERTIES_SCAN = "classpath*:sys/properties/*.properties";
    public static final String SYS2_PROPERTIES_SCAN = "classpath*:sys.properties/*.properties";
    public static final String DEFAULT_PROPERTIES_SCAN = "classpath:properties/*.properties";
    public static final String DEFAULT_CONFIG_FILE = "classpath:properties/config.properties";
    public static final String DEFAULT_CONFIG_NAME = "sys.properties";
    public static StandardServletEnvironment localenv = new StandardServletEnvironment();
    public static StringValueResolver resolver = null;
    private static Logger log = LoggerUtil.getLogger(PropertiesUtil.class);
    private static Set<String> ADD_PROP = new HashSet<String>();
    private static PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
    private static boolean initRootPropertiesConfig = false;
    private Environment environment;

    private PropertySourcesPlaceholderConfigurer configPropertySourcesPlaceholderConfigurer(ConfigurableListableBeanFactory beanFactory) {
        PropertySourcesPlaceholderConfigurer configurer = null;
        try {
            String[] names = beanFactory.getBeanNamesForType(PropertySourcesPlaceholderConfigurer.class, true, false);
            if (names.length > 0) {
                configurer = (PropertySourcesPlaceholderConfigurer)beanFactory.getBean(names[0], PropertySourcesPlaceholderConfigurer.class);
            }
        }
        catch (Exception names) {
            // empty catch block
        }
        if (configurer == null) {
            configurer = new PropertySourcesPlaceholderConfigurer();
            configurer.setBeanFactory((BeanFactory)beanFactory);
            configurer.setIgnoreUnresolvablePlaceholders(false);
            configurer.setEnvironment(this.environment);
            String namePrefix = "org.springframework.context.support.PropertySourcesPlaceholderConfigurer";
            String name = !initRootPropertiesConfig ? namePrefix + "#root" : namePrefix + "#web";
            beanFactory.registerSingleton(name, (Object)configurer);
        }
        try {
            configurer.postProcessBeanFactory(null);
        }
        catch (Exception namePrefix) {
            // empty catch block
        }
        configurer.setFileEncoding(CharsetEnum.UTF_8.getName());
        try {
            Field propertySources = configurer.getClass().getDeclaredField("propertySources");
            propertySources.setAccessible(true);
            PropertySources propertySourcesVal = (PropertySources)propertySources.get(configurer);
            Field appliedPropertySources = configurer.getClass().getDeclaredField("appliedPropertySources");
            appliedPropertySources.setAccessible(true);
            appliedPropertySources.set(configurer, propertySourcesVal);
        }
        catch (Exception e) {
            log.error("init PropertySourcesPlaceholderConfigurer error", (Throwable)e);
        }
        return configurer;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    private void mergeProperties(PropertySourcesPlaceholderConfigurer configurer) {
        PropertySources sources = configurer.getAppliedPropertySources();
        sources.forEach(source -> {
            Object env = source.getSource();
            if (env instanceof ConfigurableEnvironment) {
                ConfigurableEnvironment ssenv = (ConfigurableEnvironment)env;
                ssenv.merge((ConfigurableEnvironment)localenv);
                localenv.merge(ssenv);
            }
        });
    }

    @Override
    public void onRootApplicationEvent(ContextRefreshedEvent event) {
        initRootPropertiesConfig = true;
    }

    @Override
    public boolean doWebAndRootApplicationListener(ContextRefreshedEvent event) {
        return false;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        ConfigurableListableBeanFactory beanFactory = (ConfigurableListableBeanFactory)registry;
        PropertySourcesPlaceholderConfigurer configurer = this.configPropertySourcesPlaceholderConfigurer(beanFactory);
        String[] propertiesAwares = beanFactory.getBeanNamesForType(PropertiesAware.class);
        Arrays.asList(propertiesAwares).forEach(propertiesAwareName -> ((PropertiesAware)beanFactory.getBean(propertiesAwareName, PropertiesAware.class)).setProperties(localenv));
        this.mergeProperties(configurer);
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        ConfigProperties.resolver = resolver;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    static {
        String location = PropertiesUtil.getProperty(DEFAULT_CONFIG_NAME, DEFAULT_CONFIG_FILE);
        if (StringUtil.notEmpty((Object)location).booleanValue()) {
            ADD_PROP.add(location);
        }
        ADD_PROP.add(DEFAULT_PROPERTIES);
        ADD_PROP.add(DEFAULT_PROPERTIES_SCAN);
        ADD_PROP.add(SYS_PROPERTIES_SCAN);
        ADD_PROP.add(SYS2_PROPERTIES_SCAN);
        ADD_PROP.add(DEFAULT_CONFIG_FILE);
        ADD_PROP.forEach(path -> {
            try {
                Resource[] resources;
                for (Resource resource : resources = resourceResolver.getResources(path)) {
                    localenv.getPropertySources().addLast((PropertySource)new ResourcePropertySource(resource));
                }
            }
            catch (IOException e) {
                log.warn(e.getLocalizedMessage());
            }
        });
    }
}

