/*
 * Decompiled with CFR 0.152.
 */
package top.todev.ding.workflow.boot.config;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import top.todev.ding.common.bean.DingHostConfig;
import top.todev.ding.common.config.DingConfigStorage;
import top.todev.ding.common.config.impl.DingDefaultConfigImpl;
import top.todev.ding.workflow.api.IDingWorkflowService;
import top.todev.ding.workflow.api.impl.DingWorkflowServiceImpl;
import top.todev.ding.workflow.boot.autoconfigure.DingTalkWorkflowConfigProperties;

@Configuration
@EnableConfigurationProperties(value={DingTalkWorkflowConfigProperties.class})
public class DingTalkWorkflowDefaultConfiguration {
    @Bean
    @ConditionalOnProperty(prefix="ding.talk.workflow", value={"app-key"})
    public IDingWorkflowService dingWorkflowService(DingTalkWorkflowConfigProperties properties) {
        DingTalkWorkflowConfigProperties.HostConfig hostConfig = properties.getHost();
        DingHostConfig config = new DingHostConfig(hostConfig.getApi());
        DingDefaultConfigImpl storage = new DingDefaultConfigImpl();
        storage.setHostConfig(config);
        storage.setAppKey(properties.getAppKey());
        storage.setAppSecret(properties.getAppSecret());
        DingWorkflowServiceImpl service = new DingWorkflowServiceImpl();
        service.setDingOrgConfigStorage((DingConfigStorage)storage);
        return service;
    }
}

