/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.base.controller;

import io.swagger.v3.oas.annotations.Operation;
import java.io.Serializable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import top.tangyh.basic.annotation.log.SysLog;
import top.tangyh.basic.annotation.security.PreAuth;
import top.tangyh.basic.base.R;
import top.tangyh.basic.base.controller.SuperController;
import top.tangyh.basic.base.service.SuperCacheService;

public abstract class SuperCacheController<S extends SuperCacheService<Entity>, Id extends Serializable, Entity, PageQuery, SaveDTO, UpdateDTO>
extends SuperController<S, Id, Entity, PageQuery, SaveDTO, UpdateDTO> {
    @Override
    @SysLog(value="'\u67e5\u8be2:' + #id")
    @PreAuth(value="hasAnyPermission('{}view')")
    public R<Entity> get(@PathVariable Id id) {
        return this.success(((SuperCacheService)this.baseService).getByIdCache((Serializable)id));
    }

    @Operation(summary="\u5237\u65b0\u7f13\u5b58", description="\u5237\u65b0\u7f13\u5b58")
    @PostMapping(value={"refreshCache"})
    @SysLog(value="'\u5237\u65b0\u7f13\u5b58'")
    @PreAuth(value="hasAnyPermission('{}add')")
    public R<Boolean> refreshCache() {
        ((SuperCacheService)this.baseService).refreshCache();
        return this.success(true);
    }

    @Operation(summary="\u6e05\u7406\u7f13\u5b58", description="\u6e05\u7406\u7f13\u5b58")
    @PostMapping(value={"clearCache"})
    @SysLog(value="'\u6e05\u7406\u7f13\u5b58'")
    @PreAuth(value="hasAnyPermission('{}add')")
    public R<Boolean> clearCache() {
        ((SuperCacheService)this.baseService).clearCache();
        return this.success(true);
    }
}

