/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.database.datasource;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.baidu.fsg.uid.UidGenerator;
import com.baidu.fsg.uid.buffer.RejectedPutBufferHandler;
import com.baidu.fsg.uid.buffer.RejectedTakeBufferHandler;
import com.baidu.fsg.uid.impl.CachedUidGenerator;
import com.baidu.fsg.uid.impl.DefaultUidGenerator;
import com.baidu.fsg.uid.impl.HuToolUidGenerator;
import com.baidu.fsg.uid.worker.DisposableWorkerIdAssigner;
import com.baidu.fsg.uid.worker.WorkerIdAssigner;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.BlockAttackInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.IllegalSQLInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import java.util.Collections;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import top.tangyh.basic.context.ContextUtil;
import top.tangyh.basic.database.datasource.LampMetaObjectHandler;
import top.tangyh.basic.database.injector.LampSqlInjector;
import top.tangyh.basic.database.mybatis.WriteInterceptor;
import top.tangyh.basic.database.mybatis.typehandler.FullLikeTypeHandler;
import top.tangyh.basic.database.mybatis.typehandler.LeftLikeTypeHandler;
import top.tangyh.basic.database.mybatis.typehandler.RightLikeTypeHandler;
import top.tangyh.basic.database.plugins.SchemaInterceptor;
import top.tangyh.basic.database.properties.DatabaseProperties;
import top.tangyh.basic.database.properties.MultiTenantType;
import top.tangyh.basic.uid.dao.WorkerNodeDao;

public abstract class BaseMybatisConfiguration {
    private static final Logger log = LoggerFactory.getLogger(BaseMybatisConfiguration.class);
    protected final DatabaseProperties databaseProperties;

    public BaseMybatisConfiguration(DatabaseProperties databaseProperties) {
        this.databaseProperties = databaseProperties;
    }

    @Bean
    @Order(value=15)
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="lamp.database", name={"isNotWrite"}, havingValue="true")
    public WriteInterceptor getWriteInterceptor() {
        return new WriteInterceptor();
    }

    @Bean
    @Order(value=5)
    @ConditionalOnMissingBean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        List<InnerInterceptor> beforeInnerInterceptor;
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        log.info("\u68c0\u6d4b\u5230 lamp.database.multiTenantType={}\uff0c\u5df2\u542f\u7528 {} \u6a21\u5f0f", (Object)this.databaseProperties.getMultiTenantType().name(), (Object)this.databaseProperties.getMultiTenantType().getDescribe());
        if (StrUtil.equalsAny((CharSequence)this.databaseProperties.getMultiTenantType().name(), (CharSequence[])new CharSequence[]{MultiTenantType.SCHEMA.name(), MultiTenantType.SCHEMA_COLUMN.name()})) {
            SchemaInterceptor schemaInterceptor = new SchemaInterceptor(this.databaseProperties.getTenantDatabasePrefix());
            interceptor.addInnerInterceptor((InnerInterceptor)schemaInterceptor);
        }
        if (StrUtil.equalsAny((CharSequence)this.databaseProperties.getMultiTenantType().name(), (CharSequence[])new CharSequence[]{MultiTenantType.COLUMN.name(), MultiTenantType.SCHEMA_COLUMN.name(), MultiTenantType.DATASOURCE_COLUMN.name()})) {
            TenantLineInnerInterceptor tli = new TenantLineInnerInterceptor();
            tli.setTenantLineHandler(new TenantLineHandler(){

                public String getTenantIdColumn() {
                    return BaseMybatisConfiguration.this.databaseProperties.getTenantIdColumn();
                }

                public boolean ignoreTable(String tableName) {
                    return false;
                }

                public Expression getTenantId() {
                    return MultiTenantType.COLUMN.eq(BaseMybatisConfiguration.this.databaseProperties.getMultiTenantType()) ? new StringValue(ContextUtil.getTenant()) : new StringValue(ContextUtil.getSubTenant());
                }
            });
            interceptor.addInnerInterceptor((InnerInterceptor)tli);
        }
        if (!(beforeInnerInterceptor = this.getPaginationBeforeInnerInterceptor()).isEmpty()) {
            beforeInnerInterceptor.forEach(arg_0 -> ((MybatisPlusInterceptor)interceptor).addInnerInterceptor(arg_0));
        }
        PaginationInnerInterceptor paginationInterceptor = new PaginationInnerInterceptor();
        paginationInterceptor.setMaxLimit(Long.valueOf(this.databaseProperties.getLimit()));
        paginationInterceptor.setDbType(this.databaseProperties.getDbType());
        paginationInterceptor.setOverflow(true);
        interceptor.addInnerInterceptor((InnerInterceptor)paginationInterceptor);
        List<InnerInterceptor> afterInnerInterceptor = this.getPaginationAfterInnerInterceptor();
        if (!afterInnerInterceptor.isEmpty()) {
            afterInnerInterceptor.forEach(arg_0 -> ((MybatisPlusInterceptor)interceptor).addInnerInterceptor(arg_0));
        }
        if (this.databaseProperties.getIsBlockAttack().booleanValue()) {
            interceptor.addInnerInterceptor((InnerInterceptor)new BlockAttackInnerInterceptor());
        }
        if (this.databaseProperties.getIsIllegalSql().booleanValue()) {
            interceptor.addInnerInterceptor((InnerInterceptor)new IllegalSQLInnerInterceptor());
        }
        return interceptor;
    }

    protected List<InnerInterceptor> getPaginationAfterInnerInterceptor() {
        return Collections.emptyList();
    }

    protected List<InnerInterceptor> getPaginationBeforeInnerInterceptor() {
        return Collections.emptyList();
    }

    @Bean(value={"myMetaObjectHandler"})
    @ConditionalOnMissingBean
    public MetaObjectHandler getMyMetaObjectHandler() {
        return new LampMetaObjectHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnExpression(value="'DEFAULT'.equals('${lamp.database.id-type:DEFAULT}') || 'CACHE'.equals('${lamp.database.id-type:DEFAULT}')")
    public DisposableWorkerIdAssigner disposableWorkerIdAssigner(WorkerNodeDao workerNodeDao) {
        return new DisposableWorkerIdAssigner(workerNodeDao);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="lamp.database", name={"id-type"}, havingValue="DEFAULT", matchIfMissing=true)
    public UidGenerator getDefaultUidGenerator(DisposableWorkerIdAssigner disposableWorkerIdAssigner) {
        DefaultUidGenerator uidGenerator = new DefaultUidGenerator();
        BeanUtil.copyProperties((Object)this.databaseProperties.getDefaultId(), (Object)uidGenerator, (String[])new String[0]);
        uidGenerator.setWorkerIdAssigner((WorkerIdAssigner)disposableWorkerIdAssigner);
        return uidGenerator;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="lamp.database", name={"id-type"}, havingValue="CACHE")
    public UidGenerator getCacheUidGenerator(DisposableWorkerIdAssigner disposableWorkerIdAssigner) {
        CachedUidGenerator uidGenerator = new CachedUidGenerator();
        DatabaseProperties.CacheId cacheId = this.databaseProperties.getCacheId();
        BeanUtil.copyProperties((Object)cacheId, (Object)uidGenerator, (String[])new String[0]);
        if (cacheId.getRejectedPutBufferHandlerClass() != null) {
            RejectedPutBufferHandler rejectedPutBufferHandler = (RejectedPutBufferHandler)ReflectUtil.newInstance(cacheId.getRejectedPutBufferHandlerClass(), (Object[])new Object[0]);
            uidGenerator.setRejectedPutBufferHandler(rejectedPutBufferHandler);
        }
        if (cacheId.getRejectedTakeBufferHandlerClass() != null) {
            RejectedTakeBufferHandler rejectedTakeBufferHandler = (RejectedTakeBufferHandler)ReflectUtil.newInstance(cacheId.getRejectedTakeBufferHandlerClass(), (Object[])new Object[0]);
            uidGenerator.setRejectedTakeBufferHandler(rejectedTakeBufferHandler);
        }
        uidGenerator.setWorkerIdAssigner((WorkerIdAssigner)disposableWorkerIdAssigner);
        return uidGenerator;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="lamp.database", name={"id-type"}, havingValue="HU_TOOL")
    public UidGenerator getHuToolUidGenerator() {
        DatabaseProperties.HutoolId id = this.databaseProperties.getHutoolId();
        return new HuToolUidGenerator(id.getWorkerId().longValue(), id.getDataCenterId().longValue());
    }

    @Bean
    public LeftLikeTypeHandler getLeftLikeTypeHandler() {
        return new LeftLikeTypeHandler();
    }

    @Bean
    public RightLikeTypeHandler getRightLikeTypeHandler() {
        return new RightLikeTypeHandler();
    }

    @Bean
    public FullLikeTypeHandler getFullLikeTypeHandler() {
        return new FullLikeTypeHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public LampSqlInjector getMySqlInjector() {
        return new LampSqlInjector();
    }
}

