/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.database.mybatis.auth;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.tangyh.basic.context.ContextUtil;
import top.tangyh.basic.database.mybatis.auth.DataScopeHelper;
import top.tangyh.basic.model.database.DataScope;
import top.tangyh.basic.model.database.DataScopeType;

public class DataScopeInnerInterceptor
implements InnerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DataScopeInnerInterceptor.class);
    private final Function<Long, Map<String, Object>> function;

    protected Optional<DataScope> findDataScope(Object parameterObj) {
        DataScope ds = DataScopeHelper.getLocalDataScope();
        DataScopeHelper.clearDataScope();
        if (ds != null) {
            return Optional.of(ds);
        }
        if (parameterObj == null) {
            return Optional.empty();
        }
        if (parameterObj instanceof DataScope) {
            return Optional.of((DataScope)parameterObj);
        }
        if (parameterObj instanceof Map) {
            for (Object val : ((Map)parameterObj).values()) {
                if (!(val instanceof DataScope)) continue;
                return Optional.of((DataScope)val);
            }
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) {
        try {
            DataScope dataScope = this.findDataScope(parameter).orElse(null);
            if (dataScope == null) {
                return;
            }
            Object originalSql = boundSql.getSql();
            String scopeName = dataScope.getScopeName();
            String selfScopeName = dataScope.getSelfScopeName();
            Long userId = dataScope.getUserId() == null ? ContextUtil.getUserId() : dataScope.getUserId();
            List orgIds = dataScope.getOrgIds();
            DataScopeType dsType = DataScopeType.SELF;
            if (CollectionUtil.isEmpty((Collection)orgIds)) {
                Map<String, Object> result = this.function.apply(userId);
                if (result == null) {
                    return;
                }
                Integer type = (Integer)result.get("dsType");
                dsType = DataScopeType.get((Integer)type);
                orgIds = (List)result.get("orgIds");
            }
            if (DataScopeType.ALL.eq(dsType)) {
                return;
            }
            if (DataScopeType.SELF.eq(dsType)) {
                originalSql = "select * from (" + (String)originalSql + ") temp_data_scope where temp_data_scope." + selfScopeName + " = " + userId;
            } else if (StrUtil.isNotBlank((CharSequence)scopeName) && CollUtil.isNotEmpty((Collection)orgIds)) {
                String join = CollectionUtil.join((Iterable)orgIds, (CharSequence)",");
                originalSql = "select * from (" + (String)originalSql + ") temp_data_scope where temp_data_scope." + scopeName + " in (" + join + ")";
            }
            PluginUtils.MPBoundSql mpBoundSql = PluginUtils.mpBoundSql((BoundSql)boundSql);
            mpBoundSql.sql((String)originalSql);
        }
        finally {
            DataScopeHelper.clearDataScope();
        }
    }

    public DataScopeInnerInterceptor(Function<Long, Map<String, Object>> function) {
        this.function = function;
    }
}

