/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.cache.redis;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.google.common.collect.Lists;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import top.tangyh.basic.cache.redis.NullVal;
import top.tangyh.basic.exception.BizException;
import top.tangyh.basic.model.cache.CacheHashKey;
import top.tangyh.basic.model.cache.CacheKey;
import top.tangyh.basic.utils.ArgumentAssert;
import top.tangyh.basic.utils.CollHelper;

public class RedisOps {
    private static final Logger log = LoggerFactory.getLogger(RedisOps.class);
    private static final String KEY_NOT_NULL = "key\u4e0d\u80fd\u4e3a\u7a7a";
    private static final String CACHE_KEY_NOT_NULL = "cacheKey\u4e0d\u80fd\u4e3a\u7a7a";
    private static final int BATCH_SIZE = 1000;
    private static final Map<String, Object> KEY_LOCKS = new ConcurrentHashMap<String, Object>();
    private final RedisTemplate<String, Object> redisTemplate;
    private final ValueOperations<String, Object> valueOps;
    private final HashOperations<String, Object, Object> hashOps;
    private final ListOperations<String, Object> listOps;
    private final SetOperations<String, Object> setOps;
    private final ZSetOperations<String, Object> zSetOps;
    private final StringRedisTemplate stringRedisTemplate;
    private final boolean defaultCacheNullVal;

    public RedisOps(RedisTemplate<String, Object> redisTemplate, StringRedisTemplate stringRedisTemplate, boolean defaultCacheNullVal) {
        this.redisTemplate = redisTemplate;
        ArgumentAssert.notNull(redisTemplate, (String)"redisTemplate \u4e3a\u7a7a", (Object[])new Object[0]);
        this.valueOps = redisTemplate.opsForValue();
        this.hashOps = redisTemplate.opsForHash();
        this.listOps = redisTemplate.opsForList();
        this.setOps = redisTemplate.opsForSet();
        this.zSetOps = redisTemplate.opsForZSet();
        this.stringRedisTemplate = stringRedisTemplate;
        this.defaultCacheNullVal = defaultCacheNullVal;
    }

    private static <T> boolean isNullVal(T value) {
        boolean isNull = value == null || NullVal.class.equals(value.getClass());
        return isNull || value.getClass().equals(Object.class) || value instanceof Map && ((Map)value).isEmpty();
    }

    private void setExpire(CacheKey key) {
        if (key != null && key.getExpire() != null) {
            this.redisTemplate.expire((Object)key.getKey(), key.getExpire());
        }
    }

    private NullVal newNullVal() {
        return new NullVal();
    }

    private <T> T returnVal(T value) {
        return RedisOps.isNullVal(value) ? null : (T)value;
    }

    public Long del(CacheKey ... keys) {
        return this.del(Arrays.stream(keys).map(CacheKey::getKey).collect(Collectors.toList()));
    }

    public Long del(String ... keys) {
        return this.del(Arrays.stream(keys).collect(Collectors.toList()));
    }

    public Long del(@NonNull List<String> keys) {
        if (CollUtil.isEmpty(keys)) {
            return 0L;
        }
        List partitionKeys = Lists.partition(keys, (int)1000);
        long count = 0L;
        for (List list : partitionKeys) {
            count += this.redisTemplate.delete((Collection)list).longValue();
        }
        return count;
    }

    public Long del(@NonNull Collection<CacheKey> keys) {
        return this.del(keys.stream().map(CacheKey::getKey).collect(Collectors.toList()));
    }

    public Long unlink(CacheKey ... keys) {
        return this.unlinkStrs(Arrays.stream(keys).map(CacheKey::getKey).collect(Collectors.toList()));
    }

    public Long unlink(String ... keys) {
        return this.unlinkStrs(Arrays.stream(keys).collect(Collectors.toList()));
    }

    public Long unlinkCacheKeys(@NonNull Collection<CacheKey> keys) {
        return this.unlinkStrs(keys.stream().map(CacheKey::getKey).collect(Collectors.toList()));
    }

    public Long unlinkStrs(@NonNull List<String> keys) {
        if (CollUtil.isEmpty(keys)) {
            return 0L;
        }
        List partitionKeys = Lists.partition(keys, (int)1000);
        long count = 0L;
        for (List list : partitionKeys) {
            count += this.redisTemplate.unlink((Collection)list).longValue();
        }
        return count;
    }

    public void scanUnlink(@NonNull String pattern) {
        log.info("pattern={}", (Object)pattern);
        if (StrUtil.isEmpty((CharSequence)pattern) || "*".equals(pattern.trim())) {
            throw BizException.wrap((String)"\u5fc5\u987b\u6307\u5b9a\u5339\u914d\u7b26", (Object[])new Object[0]);
        }
        List<String> keys = this.scan(pattern);
        log.info("keys={}", (Object)keys.size());
        if (CollUtil.isEmpty(keys)) {
            return;
        }
        this.unlinkStrs(keys);
    }

    public List<String> scan(@NonNull String pattern) {
        ArrayList<String> keyList = new ArrayList<String>();
        this.scan(pattern, item -> {
            Object key = this.redisTemplate.getKeySerializer().deserialize(item);
            if (ObjectUtil.isNotEmpty((Object)key)) {
                keyList.add(String.valueOf(key));
            }
        });
        return keyList;
    }

    private void scan(String pattern, Consumer<byte[]> consumer) {
        this.redisTemplate.execute(connection -> {
            try (Cursor cursor = connection.scan(ScanOptions.scanOptions().count(1000L).match(pattern).build());){
                cursor.forEachRemaining(consumer);
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    public Set<String> keys(@NonNull String pattern) {
        return this.redisTemplate.keys((Object)pattern);
    }

    public Boolean exists(@NonNull String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public String randomKey() {
        return (String)this.redisTemplate.randomKey();
    }

    public void rename(@NonNull String oldKey, @NonNull String newKey) {
        this.redisTemplate.rename((Object)oldKey, (Object)newKey);
    }

    public Boolean renameNx(@NonNull String oldKey, String newKey) {
        return this.redisTemplate.renameIfAbsent((Object)oldKey, (Object)newKey);
    }

    public Boolean move(@NonNull String key, int dbIndex) {
        return this.redisTemplate.move((Object)key, dbIndex);
    }

    public Boolean expire(@NonNull String key, long seconds) {
        ArgumentAssert.notEmpty((CharSequence)key, (String)KEY_NOT_NULL, (Object[])new Object[0]);
        return this.redisTemplate.expire((Object)key, seconds, TimeUnit.SECONDS);
    }

    public Boolean expire(@NonNull String key, @NonNull Duration timeout) {
        return this.expire(key, timeout.getSeconds());
    }

    public Boolean expireAt(@NonNull String key, @NonNull Date date) {
        return this.redisTemplate.expireAt((Object)key, date);
    }

    public Boolean expireAt(@NonNull String key, long unixTimestamp) {
        return this.expireAt(key, new Date(unixTimestamp));
    }

    public Boolean pExpire(@NonNull String key, long milliseconds) {
        return this.redisTemplate.expire((Object)key, milliseconds, TimeUnit.MILLISECONDS);
    }

    public Boolean persist(@NonNull String key) {
        return this.redisTemplate.persist((Object)key);
    }

    public String type(@NonNull String key) {
        DataType type = this.redisTemplate.type((Object)key);
        return type == null ? DataType.NONE.code() : type.code();
    }

    public Long ttl(@NonNull String key) {
        return this.redisTemplate.getExpire((Object)key);
    }

    public Long pTtl(@NonNull String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.MILLISECONDS);
    }

    public void set(@NonNull String key, Object value, boolean ... cacheNullValues) {
        boolean cacheNullVal;
        ArgumentAssert.notNull((Object)key, (String)KEY_NOT_NULL, (Object[])new Object[0]);
        boolean bl = cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        if (!cacheNullVal && value == null) {
            return;
        }
        this.valueOps.set((Object)key, value == null ? this.newNullVal() : value);
    }

    public void set(@NonNull CacheKey cacheKey, Object value, boolean ... cacheNullValues) {
        boolean cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        ArgumentAssert.notNull((Object)cacheKey, (String)CACHE_KEY_NOT_NULL, (Object[])new Object[0]);
        String key = cacheKey.getKey();
        Duration expire = cacheKey.getExpire();
        if (expire == null) {
            this.set(key, value, cacheNullVal);
        } else {
            this.setEx(key, value, expire, cacheNullVal);
        }
    }

    public void setEx(@NonNull String key, Object value, Duration timeout, boolean ... cacheNullValues) {
        boolean cacheNullVal;
        ArgumentAssert.notNull((Object)key, (String)KEY_NOT_NULL, (Object[])new Object[0]);
        boolean bl = cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        if (!cacheNullVal && value == null) {
            return;
        }
        this.valueOps.set((Object)key, value == null ? this.newNullVal() : value, timeout);
    }

    public void setEx(@NonNull String key, Object value, long seconds, boolean ... cacheNullValues) {
        this.setEx(key, value, Duration.ofSeconds(seconds), cacheNullValues);
    }

    @Nullable
    public Boolean setXx(@NonNull String key, String value, boolean ... cacheNullValues) {
        boolean cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        return this.valueOps.setIfPresent((Object)key, cacheNullVal && value == null ? this.newNullVal() : value);
    }

    @Nullable
    public Boolean setXx(@NonNull String key, String value, long seconds, boolean ... cacheNullValues) {
        boolean cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        return this.valueOps.setIfPresent((Object)key, cacheNullVal && value == null ? this.newNullVal() : value, seconds, TimeUnit.SECONDS);
    }

    @Nullable
    public Boolean setXx(@NonNull String key, String value, Duration timeout, boolean ... cacheNullValues) {
        boolean cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        return this.valueOps.setIfPresent((Object)key, cacheNullVal && value == null ? this.newNullVal() : value, timeout);
    }

    @Nullable
    public Boolean setNx(@NonNull String key, String value, boolean ... cacheNullValues) {
        boolean cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        return this.valueOps.setIfAbsent((Object)key, cacheNullVal && value == null ? this.newNullVal() : value);
    }

    @Nullable
    public <T> T get(@NonNull String key, boolean ... cacheNullValues) {
        boolean cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        Object value = this.valueOps.get((Object)key);
        if (value == null && cacheNullVal) {
            this.set(key, (Object)this.newNullVal(), true);
        }
        return (T)this.returnVal(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T get(@NonNull String key, Function<String, T> loader, boolean ... cacheNullValues) {
        boolean cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        Object value = this.valueOps.get((Object)key);
        if (value != null) {
            return (T)this.returnVal(value);
        }
        Object object = KEY_LOCKS.computeIfAbsent(key, v -> new Object());
        synchronized (object) {
            value = this.valueOps.get((Object)key);
            if (value != null) {
                return (T)this.returnVal(value);
            }
            try {
                value = loader.apply(key);
                this.set(key, value, cacheNullVal);
            }
            finally {
                KEY_LOCKS.remove(key);
            }
        }
        return (T)this.returnVal(value);
    }

    public <T> T getSet(@NonNull String key, Object value) {
        ArgumentAssert.notNull((Object)key, (String)CACHE_KEY_NOT_NULL, (Object[])new Object[0]);
        Object val = this.valueOps.getAndSet((Object)key, value == null ? this.newNullVal() : value);
        return (T)this.returnVal(val);
    }

    @Nullable
    public <T> T get(@NonNull CacheKey key, boolean ... cacheNullValues) {
        boolean cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        ArgumentAssert.notNull((Object)key, (String)CACHE_KEY_NOT_NULL, (Object[])new Object[0]);
        ArgumentAssert.notNull((Object)key.getKey(), (String)KEY_NOT_NULL, (Object[])new Object[0]);
        Object value = this.valueOps.get((Object)key.getKey());
        if (value == null && cacheNullVal) {
            this.set(key, (Object)this.newNullVal(), true);
        }
        return (T)this.returnVal(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T get(@NonNull CacheKey key, Function<CacheKey, T> loader, boolean ... cacheNullValues) {
        ArgumentAssert.notNull((Object)key, (String)CACHE_KEY_NOT_NULL, (Object[])new Object[0]);
        ArgumentAssert.notNull((Object)key.getKey(), (String)KEY_NOT_NULL, (Object[])new Object[0]);
        boolean cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        Object value = this.valueOps.get((Object)key.getKey());
        if (value != null) {
            return (T)this.returnVal(value);
        }
        Object object = KEY_LOCKS.computeIfAbsent(key.getKey(), v -> new Object());
        synchronized (object) {
            value = this.valueOps.get((Object)key.getKey());
            if (value != null) {
                return (T)this.returnVal(value);
            }
            try {
                value = loader.apply(key);
                this.set(key, value, cacheNullVal);
            }
            finally {
                KEY_LOCKS.remove(key.getKey());
            }
        }
        return (T)this.returnVal(value);
    }

    @Nullable
    public Long strLen(@NonNull String key) {
        return this.valueOps.size((Object)key);
    }

    @Nullable
    public Integer append(@NonNull String key, String value) {
        return this.valueOps.append((Object)key, value);
    }

    public void setRange(@NonNull String key, String value, long offset) {
        this.valueOps.set((Object)key, (Object)value, offset);
    }

    public String getRange(@NonNull String key, long start, long end) {
        return this.valueOps.get((Object)key, start, end);
    }

    private Map<String, Object> mSetMap(@NonNull Map<String, Object> map, boolean cacheNullVal) {
        HashMap<String, Object> mSetMap = new HashMap<String, Object>(CollHelper.initialCapacity((int)map.size()));
        map.forEach((k, v) -> {
            if (v == null && cacheNullVal) {
                mSetMap.put((String)k, this.newNullVal());
            } else {
                mSetMap.put((String)k, v);
            }
        });
        return mSetMap;
    }

    public void mSet(@NonNull Map<String, Object> map, boolean cacheNullVal) {
        Map<String, Object> mSetMap = this.mSetMap(map, cacheNullVal);
        this.valueOps.multiSet(mSetMap);
    }

    public void mSet(@NonNull Map<String, Object> map) {
        this.mSet(map, this.defaultCacheNullVal);
    }

    public void mSetNx(@NonNull Map<String, Object> map, boolean cacheNullVal) {
        Map<String, Object> mSetMap = this.mSetMap(map, cacheNullVal);
        this.valueOps.multiSetIfAbsent(mSetMap);
    }

    public void mSetNx(@NonNull Map<String, Object> map) {
        this.mSetNx(map, this.defaultCacheNullVal);
    }

    public <T> List<T> mGet(String ... keys) {
        return this.mGet(Arrays.asList(keys));
    }

    public <T> List<T> mGet(CacheKey ... keys) {
        return this.mGetByCacheKey(Arrays.asList(keys));
    }

    public <T> List<T> mGet(@NonNull Collection<String> keys) {
        List list = this.valueOps.multiGet(keys);
        return list == null ? Collections.emptyList() : list.stream().map(this::returnVal).collect(Collectors.toList());
    }

    public <T> List<T> mGetByCacheKey(@NonNull Collection<CacheKey> cacheKeys) {
        List keys = cacheKeys.stream().map(CacheKey::getKey).collect(Collectors.toList());
        List list = this.valueOps.multiGet(keys);
        return list == null ? Collections.emptyList() : list.stream().map(this::returnVal).collect(Collectors.toList());
    }

    public Long incr(@NonNull CacheKey key) {
        Long increment = this.stringRedisTemplate.opsForValue().increment((Object)key.getKey());
        this.setExpire(key);
        return increment;
    }

    public Long incrBy(@NonNull CacheKey key, long increment) {
        Long incrBy = this.stringRedisTemplate.opsForValue().increment((Object)key.getKey(), increment);
        this.setExpire(key);
        return incrBy;
    }

    public Double incrByFloat(@NonNull CacheKey key, double increment) {
        Double incrByFloat = this.stringRedisTemplate.opsForValue().increment((Object)key.getKey(), increment);
        this.setExpire(key);
        return incrByFloat;
    }

    public Long getCounter(@NonNull CacheKey key, Long ... defaultValue) {
        Object val = this.stringRedisTemplate.opsForValue().get((Object)key.getKey());
        if (RedisOps.isNullVal(val)) {
            return defaultValue.length > 0 ? defaultValue[0] : null;
        }
        return Convert.toLong((Object)val);
    }

    public Long getCounter(@NonNull CacheKey key, Function<CacheKey, Long> loader) {
        Object val = this.stringRedisTemplate.opsForValue().get((Object)key.getKey());
        if (RedisOps.isNullVal(val)) {
            return loader.apply(key);
        }
        return Convert.toLong((Object)val);
    }

    public Long decr(@NonNull CacheKey key) {
        Long decr = this.stringRedisTemplate.opsForValue().decrement((Object)key.getKey());
        this.setExpire(key);
        return decr;
    }

    public Long decrBy(@NonNull CacheKey key, long decrement) {
        Long decr = this.stringRedisTemplate.opsForValue().decrement((Object)key.getKey(), decrement);
        this.setExpire(key);
        return decr;
    }

    public void hSet(@NonNull String key, @NonNull Object field, Object value, boolean ... cacheNullValues) {
        boolean cacheNullVal;
        ArgumentAssert.notEmpty((CharSequence)key, (String)KEY_NOT_NULL, (Object[])new Object[0]);
        ArgumentAssert.notNull((Object)field, (String)"field\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        boolean bl = cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        if (!cacheNullVal && value == null) {
            return;
        }
        this.hashOps.put((Object)key, field, value == null ? this.newNullVal() : value);
    }

    public void hSet(@NonNull CacheHashKey key, Object value, boolean ... cacheNullValues) {
        ArgumentAssert.notNull((Object)key, (String)"CacheHashKey\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.hSet(key.getKey(), key.getField(), value, cacheNullValues);
        this.setExpire((CacheKey)key);
    }

    @Nullable
    public <T> T hGet(@NonNull String key, @NonNull Object field, boolean ... cacheNullValues) {
        boolean cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        Object value = this.hashOps.get((Object)key, field);
        if (value == null && cacheNullVal) {
            this.hSet(key, field, this.newNullVal(), true);
        }
        return (T)this.returnVal(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T hGet(@NonNull String key, @NonNull Object field, BiFunction<String, Object, T> loader, boolean ... cacheNullValues) {
        boolean cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        Object value = this.hashOps.get((Object)key, field);
        if (value != null) {
            return (T)this.returnVal(value);
        }
        String lockKey = key + "@" + field;
        Object object = KEY_LOCKS.computeIfAbsent(lockKey, v -> new Object());
        synchronized (object) {
            value = this.hashOps.get((Object)key, field);
            if (value != null) {
                return (T)this.returnVal(value);
            }
            try {
                value = loader.apply(key, field);
                this.hSet(key, field, value, cacheNullVal);
            }
            finally {
                KEY_LOCKS.remove(lockKey);
            }
        }
        return (T)this.returnVal(value);
    }

    @Nullable
    public <T> T hGet(@NonNull CacheHashKey key, boolean ... cacheNullValues) {
        boolean cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        ArgumentAssert.notNull((Object)key, (String)"CacheHashKey\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArgumentAssert.notEmpty((CharSequence)key.getKey(), (String)KEY_NOT_NULL, (Object[])new Object[0]);
        ArgumentAssert.notNull((Object)key.getField(), (String)"field\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Object value = this.hashOps.get((Object)key.getKey(), key.getField());
        if (value == null && cacheNullVal) {
            this.hSet(key, (Object)this.newNullVal(), true);
        }
        return (T)this.returnVal(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T hGet(@NonNull CacheHashKey key, Function<CacheHashKey, T> loader, boolean ... cacheNullValues) {
        boolean cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        Object value = this.hashOps.get((Object)key.getKey(), key.getField());
        if (value != null) {
            return (T)this.returnVal(value);
        }
        String lockKey = key.getKey() + "@" + key.getField();
        Object object = KEY_LOCKS.computeIfAbsent(lockKey, v -> new Object());
        synchronized (object) {
            value = this.hashOps.get((Object)key.getKey(), key.getField());
            if (value != null) {
                return (T)this.returnVal(value);
            }
            try {
                value = loader.apply(key);
                this.hSet(key, value, cacheNullVal);
            }
            finally {
                KEY_LOCKS.remove(key.getKey());
            }
        }
        return (T)this.returnVal(value);
    }

    public Boolean hExists(@NonNull String key, @NonNull Object field) {
        return this.hashOps.hasKey((Object)key, field);
    }

    public Boolean hExists(@NonNull CacheHashKey cacheHashKey) {
        return this.hashOps.hasKey((Object)cacheHashKey.getKey(), cacheHashKey.getField());
    }

    public Long hDel(@NonNull String key, Object ... fields) {
        return this.hashOps.delete((Object)key, fields);
    }

    public Long hDel(@NonNull CacheHashKey key) {
        return this.hashOps.delete((Object)key.getKey(), new Object[]{key.getField()});
    }

    public Long hLen(@NonNull String key) {
        return this.hashOps.size((Object)key);
    }

    public Long hStrLen(@NonNull String key, @NonNull Object field) {
        return this.hashOps.lengthOfValue((Object)key, field);
    }

    public Long hIncrBy(@NonNull CacheHashKey key, long increment) {
        Long hIncrBy = this.stringRedisTemplate.opsForHash().increment((Object)key.getKey(), key.getField(), increment);
        if (key.getExpire() != null) {
            this.stringRedisTemplate.expire((Object)key.getKey(), key.getExpire());
        }
        return hIncrBy;
    }

    public Double hIncrByFloat(@NonNull CacheHashKey key, double increment) {
        Double hIncrBy = this.stringRedisTemplate.opsForHash().increment((Object)key.getKey(), key.getField(), increment);
        if (key.getExpire() != null) {
            this.stringRedisTemplate.expire((Object)key.getKey(), key.getExpire());
        }
        return hIncrBy;
    }

    public <K, V> void hmSet(@NonNull String key, @NonNull Map<K, V> hash, boolean ... cacheNullValues) {
        boolean cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        HashMap newMap = new HashMap(CollHelper.initialCapacity((int)hash.size()));
        hash.forEach((k, v) -> {
            if (v == null && cacheNullVal) {
                newMap.put(k, this.newNullVal());
            } else {
                newMap.put(k, v);
            }
        });
        this.hashOps.putAll((Object)key, newMap);
    }

    public List<Object> hmGet(@NonNull String key, Object ... fields) {
        return this.hmGet(key, Arrays.asList(fields));
    }

    public List<Object> hmGet(@NonNull String key, @NonNull Collection<Object> fields) {
        List list = this.hashOps.multiGet((Object)key, fields);
        return list.stream().map(this::returnVal).collect(Collectors.toList());
    }

    public <HK> Set<HK> hKeys(@NonNull String key) {
        return this.hashOps.keys((Object)key);
    }

    public <HV> List<HV> hVals(@NonNull String key) {
        return this.hashOps.values((Object)key);
    }

    public <K, V> Map<K, V> hGetAll(@NonNull String key) {
        Map map = this.hashOps.entries((Object)key);
        return this.returnMapVal(map);
    }

    public <K, V> Map<K, V> hGetAll(@NonNull CacheHashKey key) {
        Map map = this.hashOps.entries((Object)key.getKey());
        return this.returnMapVal(map);
    }

    private <K, V> Map<K, V> returnMapVal(Map<K, V> map) {
        HashMap newMap = new HashMap(CollHelper.initialCapacity((int)map.size()));
        if (MapUtil.isNotEmpty(map)) {
            map.forEach((k, v) -> {
                if (!RedisOps.isNullVal(v)) {
                    newMap.put(k, v);
                }
            });
        }
        return newMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <K, V> Map<K, V> hGetAll(@NonNull CacheHashKey key, Function<CacheHashKey, Map<K, V>> loader, boolean ... cacheNullValues) {
        boolean cacheNullVal = cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
        Map<K, V> map = this.hashOps.entries((Object)key.getKey());
        if (MapUtil.isNotEmpty((Map)map)) {
            return this.returnMapVal(map);
        }
        String lockKey = key.getKey();
        Object object = KEY_LOCKS.computeIfAbsent(lockKey, v -> new Object());
        synchronized (object) {
            map = this.hashOps.entries((Object)key.getKey());
            if (MapUtil.isNotEmpty((Map)map)) {
                return this.returnMapVal(map);
            }
            try {
                map = loader.apply(key);
                this.hmSet(key.getKey(), map, cacheNullVal);
            }
            finally {
                KEY_LOCKS.remove(key.getKey());
            }
        }
        return this.returnMapVal(map);
    }

    @Nullable
    public Long lPush(@NonNull String key, Object ... values) {
        return this.listOps.leftPushAll((Object)key, values);
    }

    @Nullable
    public Long lPush(@NonNull String key, Collection<Object> values) {
        return this.listOps.leftPushAll((Object)key, values);
    }

    @Nullable
    public Long lPushX(@NonNull String key, Object values) {
        return this.listOps.leftPushIfPresent((Object)key, values);
    }

    @Nullable
    public Long rPush(@NonNull String key, Object ... values) {
        return this.listOps.rightPushAll((Object)key, values);
    }

    @Nullable
    public Long rPush(@NonNull String key, Collection<Object> values) {
        return this.listOps.rightPushAll((Object)key, values);
    }

    @Nullable
    public Long rPushX(@NonNull String key, Object value) {
        return this.listOps.rightPushIfPresent((Object)key, value);
    }

    @Nullable
    public <T> T lPop(@NonNull String key) {
        return (T)this.listOps.leftPop((Object)key);
    }

    public <T> T rPop(@NonNull String key) {
        return (T)this.listOps.rightPop((Object)key);
    }

    public <T> T rPoplPush(String sourceKey, String destinationKey) {
        return (T)this.listOps.rightPopAndLeftPush((Object)sourceKey, (Object)destinationKey);
    }

    @Nullable
    public Long lRem(@NonNull String key, long count, Object value) {
        return this.listOps.remove((Object)key, count, value);
    }

    @Nullable
    public Long lLen(@NonNull String key) {
        return this.listOps.size((Object)key);
    }

    @Nullable
    public <T> T lIndex(@NonNull String key, long index) {
        return (T)this.listOps.index((Object)key, index);
    }

    @Nullable
    public Long lInsert(@NonNull String key, Object pivot, Object value) {
        return this.listOps.leftPush((Object)key, pivot, value);
    }

    @Nullable
    public Long rInsert(@NonNull String key, Object pivot, Object value) {
        return this.listOps.rightPush((Object)key, pivot, value);
    }

    public void lSet(@NonNull String key, long index, Object value) {
        this.listOps.set((Object)key, index, value);
    }

    @Nullable
    public List<Object> lRange(@NonNull String key, long start, long end) {
        return this.listOps.range((Object)key, start, end);
    }

    public void lTrim(@NonNull String key, long start, long end) {
        this.listOps.trim((Object)key, start, end);
    }

    public <V> Long sAdd(@NonNull CacheKey key, V ... members) {
        Long count = this.setOps.add((Object)key.getKey(), (Object[])members);
        this.setExpire(key);
        return count;
    }

    public <V> Long sAdd(@NonNull CacheKey key, Collection<V> members) {
        Long count = this.setOps.add((Object)key.getKey(), members.toArray());
        this.setExpire(key);
        return count;
    }

    public Boolean sIsMember(@NonNull CacheKey key, Object member) {
        return this.setOps.isMember((Object)key.getKey(), member);
    }

    @Nullable
    public <T> T sPop(@NonNull CacheKey key) {
        return (T)this.setOps.pop((Object)key.getKey());
    }

    @Nullable
    public <T> T sRandMember(@NonNull CacheKey key) {
        return (T)this.setOps.randomMember((Object)key.getKey());
    }

    @Nullable
    public <V> Set<V> sRandMember(@NonNull CacheKey key, long count) {
        return this.setOps.distinctRandomMembers((Object)key.getKey(), count);
    }

    @Nullable
    public <V> List<V> sRandMembers(@NonNull CacheKey key, long count) {
        return this.setOps.randomMembers((Object)key.getKey(), count);
    }

    @Nullable
    public Long sRem(@NonNull CacheKey key, Object ... members) {
        return this.setOps.remove((Object)key.getKey(), members);
    }

    public <V> Boolean sMove(@NonNull CacheKey sourceKey, CacheKey destinationKey, V value) {
        return this.setOps.move((Object)sourceKey.getKey(), value, (Object)destinationKey.getKey());
    }

    public Long sCard(@NonNull CacheKey key) {
        return this.setOps.size((Object)key.getKey());
    }

    @Nullable
    public <V> Set<V> sMembers(@NonNull CacheKey key) {
        return this.setOps.members((Object)key.getKey());
    }

    @Nullable
    public <V> Set<V> sInter(@NonNull CacheKey key, @NonNull CacheKey otherKey) {
        return this.setOps.intersect((Object)key.getKey(), (Object)otherKey.getKey());
    }

    @Nullable
    public Set<Object> sInter(@NonNull CacheKey key, Collection<CacheKey> otherKeys) {
        return this.setOps.intersect((Object)key.getKey(), (Collection)otherKeys.stream().map(CacheKey::getKey).collect(Collectors.toList()));
    }

    @Nullable
    public <V> Set<V> sInter(Collection<CacheKey> otherKeys) {
        return this.setOps.intersect((Collection)otherKeys.stream().map(CacheKey::getKey).collect(Collectors.toList()));
    }

    @Nullable
    public Long sInterStore(@NonNull CacheKey key, @NonNull CacheKey otherKey, @NonNull CacheKey destKey) {
        return this.setOps.intersectAndStore((Object)key.getKey(), (Object)otherKey.getKey(), (Object)destKey.getKey());
    }

    @Nullable
    public Long sInterStore(@NonNull CacheKey key, @NonNull Collection<CacheKey> otherKeys, @NonNull CacheKey destKey) {
        return this.setOps.intersectAndStore((Object)key.getKey(), (Collection)otherKeys.stream().map(CacheKey::getKey).collect(Collectors.toList()), (Object)destKey.getKey());
    }

    @Nullable
    public Long sInterStore(Collection<CacheKey> otherKeys, @NonNull CacheKey destKey) {
        return this.setOps.intersectAndStore((Collection)otherKeys.stream().map(CacheKey::getKey).collect(Collectors.toList()), (Object)destKey.getKey());
    }

    @Nullable
    public <V> Set<V> sUnion(@NonNull CacheKey key, @NonNull CacheKey otherKey) {
        return this.setOps.union((Object)key.getKey(), (Object)otherKey.getKey());
    }

    @Nullable
    public <V> Set<V> sUnion(@NonNull CacheKey key, Collection<CacheKey> otherKeys) {
        return this.setOps.union((Object)key.getKey(), (Collection)otherKeys.stream().map(CacheKey::getKey).collect(Collectors.toList()));
    }

    @Nullable
    public <V> Set<V> sUnion(Collection<CacheKey> otherKeys) {
        return this.setOps.union((Collection)otherKeys.stream().map(CacheKey::getKey).collect(Collectors.toList()));
    }

    public Long sUnionStore(@NonNull CacheKey key, @NonNull CacheKey otherKey, @NonNull CacheKey distKey) {
        return this.setOps.unionAndStore((Object)key.getKey(), (Object)otherKey.getKey(), (Object)distKey.getKey());
    }

    public Long sUnionStore(Collection<CacheKey> otherKeys, @NonNull CacheKey distKey) {
        return this.setOps.unionAndStore((Collection)otherKeys.stream().map(CacheKey::getKey).collect(Collectors.toList()), (Object)distKey.getKey());
    }

    @Nullable
    public <V> Set<V> sDiff(@NonNull CacheKey key, @NonNull CacheKey otherKey) {
        return this.setOps.difference((Object)key.getKey(), (Object)otherKey.getKey());
    }

    public <V> Set<V> sDiff(Collection<CacheKey> otherKeys) {
        return this.setOps.difference((Collection)otherKeys.stream().map(CacheKey::getKey).collect(Collectors.toList()));
    }

    public Long sDiffStore(@NonNull CacheKey key, @NonNull CacheKey otherKey, @NonNull CacheKey distKey) {
        return this.setOps.differenceAndStore((Object)key.getKey(), (Object)otherKey.getKey(), (Object)distKey.getKey());
    }

    public Long sDiffStore(Collection<CacheKey> otherKeys, @NonNull CacheKey distKey) {
        return this.setOps.differenceAndStore((Collection)otherKeys.stream().map(CacheKey::getKey).collect(Collectors.toList()), (Object)distKey.getKey());
    }

    public Boolean zAdd(@NonNull String key, Object member, double score) {
        return this.zSetOps.add((Object)key, member, score);
    }

    public Long zAdd(@NonNull String key, Map<Object, Double> scoreMembers) {
        HashSet tuples = new HashSet();
        scoreMembers.forEach((score, member) -> tuples.add(new DefaultTypedTuple(score, member)));
        return this.zSetOps.add((Object)key, tuples);
    }

    public Double zScore(@NonNull String key, Object member) {
        return this.zSetOps.score((Object)key, member);
    }

    public Double zIncrBy(@NonNull String key, Object member, double score) {
        return this.zSetOps.incrementScore((Object)key, member, score);
    }

    public Long zCard(@NonNull String key) {
        return this.zSetOps.zCard((Object)key);
    }

    public Long zCount(@NonNull String key, double min, double max) {
        return this.zSetOps.count((Object)key, min, max);
    }

    @Nullable
    public Set<Object> zRange(@NonNull String key, long start, long end) {
        return this.zSetOps.range((Object)key, start, end);
    }

    @Nullable
    public Set<ZSetOperations.TypedTuple<Object>> zRangeWithScores(@NonNull String key, long start, long end) {
        return this.zSetOps.rangeWithScores((Object)key, start, end);
    }

    @Nullable
    public Set<Object> zRevrange(@NonNull String key, long start, long end) {
        return this.zSetOps.reverseRange((Object)key, start, end);
    }

    @Nullable
    public Set<ZSetOperations.TypedTuple<Object>> zRevrangeWithScores(@NonNull String key, long start, long end) {
        return this.zSetOps.reverseRangeWithScores((Object)key, start, end);
    }

    public Set<Object> zRangeByScore(@NonNull String key, double min, double max) {
        return this.zSetOps.rangeByScore((Object)key, min, max);
    }

    public Set<ZSetOperations.TypedTuple<Object>> zRangeByScoreWithScores(@NonNull String key, double min, double max) {
        return this.zSetOps.rangeByScoreWithScores((Object)key, min, max);
    }

    public Set<Object> zReverseRange(@NonNull String key, double min, double max) {
        return this.zSetOps.reverseRangeByScore((Object)key, min, max);
    }

    public Set<ZSetOperations.TypedTuple<Object>> zReverseRangeByScoreWithScores(@NonNull String key, double min, double max) {
        return this.zSetOps.reverseRangeByScoreWithScores((Object)key, min, max);
    }

    @Nullable
    public Long zRank(@NonNull String key, Object member) {
        return this.zSetOps.rank((Object)key, member);
    }

    public Long zRevrank(@NonNull String key, Object member) {
        return this.zSetOps.reverseRank((Object)key, member);
    }

    public Long zRem(@NonNull String key, Object ... members) {
        return this.zSetOps.remove((Object)key, members);
    }

    public Long zRem(@NonNull String key, long start, long end) {
        return this.zSetOps.removeRange((Object)key, start, end);
    }

    public Long zRemRangeByScore(@NonNull String key, double min, double max) {
        return this.zSetOps.removeRangeByScore((Object)key, min, max);
    }

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public ValueOperations<String, Object> getValueOps() {
        return this.valueOps;
    }

    public HashOperations<String, Object, Object> getHashOps() {
        return this.hashOps;
    }

    public ListOperations<String, Object> getListOps() {
        return this.listOps;
    }

    public SetOperations<String, Object> getSetOps() {
        return this.setOps;
    }

    public ZSetOperations<String, Object> getZSetOps() {
        return this.zSetOps;
    }

    public StringRedisTemplate getStringRedisTemplate() {
        return this.stringRedisTemplate;
    }

    public boolean isDefaultCacheNullVal() {
        return this.defaultCacheNullVal;
    }
}

