/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import top.tangyh.basic.cache.lock.CaffeineDistributedLock;
import top.tangyh.basic.cache.properties.CustomCacheProperties;
import top.tangyh.basic.cache.repository.CacheOps;
import top.tangyh.basic.cache.repository.CachePlusOps;
import top.tangyh.basic.cache.repository.impl.CaffeineOpsImpl;
import top.tangyh.basic.lock.DistributedLock;

@ConditionalOnProperty(prefix="lamp.cache", name={"type"}, havingValue="CAFFEINE")
@EnableConfigurationProperties(value={CustomCacheProperties.class})
public class CaffeineAutoConfigure {
    private static final Logger log = LoggerFactory.getLogger(CaffeineAutoConfigure.class);
    private final CustomCacheProperties cacheProperties;

    @Bean
    @ConditionalOnMissingBean
    public DistributedLock caffeineDistributedLock() {
        return new CaffeineDistributedLock();
    }

    @Bean
    @ConditionalOnMissingBean
    public CacheOps cacheOps() {
        log.warn("\u68c0\u67e5\u5230\u7f13\u5b58\u91c7\u7528\u4e86 Caffeine(\u5185\u5b58\u6a21\u5f0f)");
        return new CaffeineOpsImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public CachePlusOps cachePlusOps() {
        return new CaffeineOpsImpl();
    }

    @Bean
    @Primary
    public CacheManager caffeineCacheManager() {
        CaffeineCacheManager cacheManager = new CaffeineCacheManager();
        Caffeine caffeine = Caffeine.newBuilder().recordStats().initialCapacity(500).expireAfterWrite(this.cacheProperties.getDef().getTimeToLive()).maximumSize((long)this.cacheProperties.getDef().getMaxSize());
        cacheManager.setAllowNullValues(this.cacheProperties.getDef().isCacheNullValues());
        cacheManager.setCaffeine(caffeine);
        return cacheManager;
    }

    public CaffeineAutoConfigure(CustomCacheProperties cacheProperties) {
        this.cacheProperties = cacheProperties;
    }
}

