/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.domain.proto.mapper;

import com.github.tobato.fastdfs.domain.proto.mapper.FdfsColumnMapException;
import com.github.tobato.fastdfs.domain.proto.mapper.FieldMetaData;
import com.github.tobato.fastdfs.domain.proto.mapper.ObjectMetaData;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FdfsParamMapper {
    private static Map<String, ObjectMetaData> mapCache = new HashMap<String, ObjectMetaData>();
    private static final Logger LOGGER = LoggerFactory.getLogger(FdfsParamMapper.class);

    private FdfsParamMapper() {
    }

    public static <T> T map(byte[] content, Class<T> genericType, Charset charset) {
        ObjectMetaData objectMap = FdfsParamMapper.getObjectMap(genericType);
        if (LOGGER.isDebugEnabled()) {
            objectMap.dumpObjectMetaData();
        }
        try {
            return FdfsParamMapper.mapByIndex(content, genericType, objectMap, charset);
        }
        catch (InstantiationException ie) {
            LOGGER.debug("Cannot instantiate: ", (Throwable)ie);
            throw new FdfsColumnMapException(ie);
        }
        catch (IllegalAccessException iae) {
            LOGGER.debug("Illegal access: ", (Throwable)iae);
            throw new FdfsColumnMapException(iae);
        }
        catch (InvocationTargetException ite) {
            LOGGER.debug("Cannot invoke method: ", (Throwable)ite);
            throw new FdfsColumnMapException(ite);
        }
    }

    public static <T> ObjectMetaData getObjectMap(Class<T> genericType) {
        if (null == mapCache.get(genericType.getName())) {
            mapCache.put(genericType.getName(), new ObjectMetaData(genericType));
        }
        return mapCache.get(genericType.getName());
    }

    private static <T> T mapByIndex(byte[] content, Class<T> genericType, ObjectMetaData objectMap, Charset charset) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        List<FieldMetaData> mappingFields = objectMap.getFieldList();
        T obj = genericType.newInstance();
        for (int i = 0; i < mappingFields.size(); ++i) {
            FieldMetaData field = mappingFields.get(i);
            LOGGER.debug("\u8bbe\u7f6e\u503c\u662f {} = {}", (Object)field, field.getValue(content, charset));
            BeanUtils.setProperty(obj, (String)field.getFieldName(), (Object)field.getValue(content, charset));
        }
        return obj;
    }

    public static byte[] toByte(Object object, Charset charset) {
        ObjectMetaData objectMap = FdfsParamMapper.getObjectMap(object.getClass());
        try {
            return FdfsParamMapper.convertFieldToByte(objectMap, object, charset);
        }
        catch (NoSuchMethodException ie) {
            LOGGER.debug("Cannot invoke get methed: ", (Throwable)ie);
            throw new FdfsColumnMapException(ie);
        }
        catch (IllegalAccessException iae) {
            LOGGER.debug("Illegal access: ", (Throwable)iae);
            throw new FdfsColumnMapException(iae);
        }
        catch (InvocationTargetException ite) {
            LOGGER.debug("Cannot invoke method: ", (Throwable)ite);
            throw new FdfsColumnMapException(ite);
        }
    }

    private static byte[] convertFieldToByte(ObjectMetaData objectMap, Object object, Charset charset) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        List<FieldMetaData> mappingFields = objectMap.getFieldList();
        int size = objectMap.getFieldsSendTotalByteSize(object, charset);
        byte[] result = new byte[size];
        int offsize = 0;
        for (int i = 0; i < mappingFields.size(); ++i) {
            FieldMetaData field = mappingFields.get(i);
            byte[] fieldByte = field.toByte(object, charset);
            if (null == fieldByte) continue;
            System.arraycopy(fieldByte, 0, result, offsize, fieldByte.length);
            offsize += fieldByte.length;
        }
        return result;
    }
}

