/*
 * Decompiled with CFR 0.152.
 */
package top.lrshuai.encryption;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AesUtils {
    public static final String AES = "AES";
    public static final String CIPHER_MODE_ECB_PKCS5PADDING = "AES/ECB/PKCS5Padding";
    public static final String CIPHER_MODE_ECB_PKCS7PADDING = "AES/ECB/PKCS7Padding";
    public static final String CIPHER_MODE_CBC_PKCS5PADDING = "AES/CBC/PKCS5Padding";
    public static final String CIPHER_MODE_CBC_PKCS7PADDING = "AES/CBC/PKCS7Padding";
    public static final String CIPHER_MODE_CTR_PKCS5PADDING = "AES/CTR/PKCS5Padding";
    public static final String CIPHER_MODE_CTR_PKCS7PADDING = "AES/CTR/PKCS7Padding";
    public static final String CIPHER_MODE_OFB_PKCS5PADDING = "AES/OFB/PKCS5Padding";
    public static final String CIPHER_MODE_OFB_PKCS7PADDING = "AES/OFB/PKCS7Padding";
    public static final String CIPHER_MODE_CFB_PKCS5PADDING = "AES/CFB/PKCS5Padding";
    public static final String CIPHER_MODE_CFB_PKCS7PADDING = "AES/CFB/PKCS7Padding";
    public static final String CHARSET_NAME = "UTF-8";
    public static final int KEY_SIZE_128 = 128;
    public static final int KEY_SIZE_192 = 192;
    public static final int KEY_SIZE_256 = 256;
    private static final BouncyCastleProvider BOUNCYCASTLEPROVIDER = new BouncyCastleProvider();

    public static String generateSecret(int keySize) {
        String result = UUID.randomUUID().toString().replaceAll("-", "");
        if (128 == keySize) {
            result = result.substring(0, 16);
        } else if (192 == keySize) {
            result = result.substring(0, 24);
        } else if (256 == keySize) {
            result = result.substring(0, 32);
        } else {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef\uff0c\u957f\u5ea6\u53ef\u9009\uff1a128\u3001192\u3001256");
        }
        return result;
    }

    public static byte[] encrypt(String content, String pwdKey) throws GeneralSecurityException, UnsupportedEncodingException {
        Cipher cipher = AesUtils.getCipher(1, pwdKey, null, CIPHER_MODE_ECB_PKCS5PADDING);
        return cipher.doFinal(content.getBytes(CHARSET_NAME));
    }

    public static byte[] encryptByIv(String content, String pwdKey, byte[] iv, String transformMode) throws GeneralSecurityException, UnsupportedEncodingException {
        Cipher cipher = AesUtils.getCipher(1, pwdKey, iv, transformMode);
        return cipher.doFinal(content.getBytes(CHARSET_NAME));
    }

    public static String encodeBase64(String content, String pwdKey) throws GeneralSecurityException, UnsupportedEncodingException {
        return Base64.encodeBase64String((byte[])AesUtils.encrypt(content, pwdKey));
    }

    public static String encodeBase64(String content, String pwdKey, byte[] iv, String transformMode) throws GeneralSecurityException, UnsupportedEncodingException {
        return Base64.encodeBase64String((byte[])AesUtils.encryptByIv(content, pwdKey, iv, transformMode));
    }

    public static byte[] decrypt(byte[] content, String pwdKey) throws GeneralSecurityException, UnsupportedEncodingException {
        Cipher cipher = AesUtils.getCipher(2, pwdKey, null, CIPHER_MODE_ECB_PKCS5PADDING);
        return cipher.doFinal(content);
    }

    public static byte[] decryptByIv(byte[] content, String pwdKey, byte[] iv, String transformMode) throws GeneralSecurityException, UnsupportedEncodingException {
        Cipher cipher = AesUtils.getCipher(2, pwdKey, iv, transformMode);
        return cipher.doFinal(content);
    }

    public static String decodeBase64(String content, String pwdKey) throws GeneralSecurityException, UnsupportedEncodingException {
        return new String(AesUtils.decrypt(Base64.decodeBase64((String)content), pwdKey), CHARSET_NAME);
    }

    public static String decodeBase64(String content, String pwdKey, byte[] iv, String transformMode) throws GeneralSecurityException, UnsupportedEncodingException {
        return new String(AesUtils.decryptByIv(Base64.decodeBase64((String)content), pwdKey, iv, transformMode), CHARSET_NAME);
    }

    private static Cipher getCipher(int cipherMode, String pwdKey, byte[] iv, String transformMode) throws GeneralSecurityException, UnsupportedEncodingException {
        byte[] raw = pwdKey.getBytes(CHARSET_NAME);
        Security.addProvider((Provider)BOUNCYCASTLEPROVIDER);
        SecretKeySpec secretKeySpec = new SecretKeySpec(raw, AES);
        Cipher cipher = Cipher.getInstance(transformMode);
        if (iv != null && iv.length > 0) {
            cipher.init(cipherMode, (Key)secretKeySpec, new IvParameterSpec(iv));
        } else {
            cipher.init(cipherMode, secretKeySpec);
        }
        return cipher;
    }

    public static void main(String[] args) throws Exception {
        String pwd = AesUtils.generateSecret(256);
        System.out.println("pwd=" + pwd);
        System.out.println("pwd=" + pwd.length());
        String text = "abcAAA";
        byte[] iv = "1234567890123456".getBytes();
        String encode7 = AesUtils.encodeBase64(text, pwd, iv, CIPHER_MODE_OFB_PKCS5PADDING);
        System.out.println("encode3=" + encode7);
        String decrypt8 = AesUtils.decodeBase64(encode7, pwd, iv, CIPHER_MODE_OFB_PKCS5PADDING);
        System.out.println("decrypt4=" + decrypt8);
    }
}

