/*
 * Decompiled with CFR 0.152.
 */
package top.heue.utils.log.pool;

import java.util.Arrays;
import java.util.concurrent.ConcurrentLinkedDeque;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.heue.utils.log.LogLevel;
import top.heue.utils.log.base.IBaseHandler;
import top.heue.utils.log.base.IBasePrinter;
import top.heue.utils.log.pool.ITaskPool;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\"\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010\u0012\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J-\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0015\"\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0016J \u0010\u0017\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000fH\u0016R\u0018\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ltop/heue/utils/log/pool/TaskPool;", "Ltop/heue/utils/log/pool/ITaskPool;", "()V", "handlers", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Ltop/heue/utils/log/base/IBaseHandler;", "printers", "Ltop/heue/utils/log/base/IBasePrinter;", "add", "", "item", "execute", "logLevel", "Ltop/heue/utils/log/LogLevel;", "tag", "", "any", "", "format", "text", "params", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "print", "string", "log_release"})
public final class TaskPool
implements ITaskPool {
    @NotNull
    public static final TaskPool INSTANCE = new TaskPool();
    @NotNull
    private static final ConcurrentLinkedDeque<IBaseHandler<?>> handlers = new ConcurrentLinkedDeque();
    @NotNull
    private static final ConcurrentLinkedDeque<IBasePrinter> printers = new ConcurrentLinkedDeque();

    private TaskPool() {
    }

    @Override
    public void add(@NotNull IBaseHandler<?> item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        IBaseHandler<?> iBaseHandler = handlers.peekLast();
        if (iBaseHandler != null) {
            iBaseHandler.next(item);
        }
        handlers.add(item);
    }

    @Override
    public void add(@NotNull IBasePrinter item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        IBasePrinter iBasePrinter = printers.peekLast();
        if (iBasePrinter != null) {
            iBasePrinter.next(item);
        }
        printers.add(item);
    }

    @Override
    public void execute(@NotNull LogLevel logLevel, @NotNull String tag, @Nullable Object any) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        String s = this.format(any);
        this.print(logLevel, tag, s);
    }

    @Override
    @NotNull
    public String format(@Nullable Object any) {
        String string = handlers.peekFirst().execute(any);
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Override
    public void print(@NotNull LogLevel logLevel, @NotNull String tag, @NotNull String string) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            IBasePrinter iBasePrinter = printers.peekFirst();
            if (iBasePrinter == null) break block0;
            iBasePrinter.execute(logLevel, tag, string);
        }
    }

    @Override
    @Nullable
    public String format(@Nullable String text, Object ... params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (text == null) {
            return null;
        }
        Object[] objectArray = Arrays.copyOf(params, params.length);
        String string = String.format(text, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(this, *args)");
        return string;
    }
}

