/*
 * Decompiled with CFR 0.152.
 */
package top.heue.utils.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.heue.utils.log.L;
import top.heue.utils.log.LogLevel;
import top.heue.utils.log.base.BasePrinter;
import top.heue.utils.log.printer.DefaultPrinter;
import top.heue.utils.log.printer.RecordPrinter;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005J\u000e\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u0013H\u0002JY\u0010\u001c\u001a\u00020\u0013*\u00020\u001d2K\u0010\u001e\u001aG\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u00130\u001fH\u0007J\u0014\u0010\u001c\u001a\u00020\u0013*\u00020\u001d2\u0006\u0010\"\u001a\u00020\rH\u0007J\u0012\u0010#\u001a\u00020\u0013*\u00020\u001d2\u0006\u0010$\u001a\u00020\u0005J\f\u0010%\u001a\u00020\u0013*\u00020\u001dH\u0007J\f\u0010&\u001a\u00020'*\u00020\u001dH\u0007J\u0012\u0010(\u001a\u00020\u0013*\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0005J\u0012\u0010)\u001a\u00020\u0013*\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0005R6\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Ltop/heue/utils/log/LogUtils;", "", "()V", "apartMap", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "getApartMap", "()Ljava/util/HashMap;", "setApartMap", "(Ljava/util/HashMap;)V", "firstPrinter", "Ltop/heue/utils/log/base/BasePrinter;", "printers", "Ljava/util/LinkedList;", "recordPrinter", "Ltop/heue/utils/log/printer/RecordPrinter;", "println", "", "logLevel", "Ltop/heue/utils/log/LogLevel;", "tag", "string", "throwToString", "e", "", "updatePrinters", "addPrinter", "Ltop/heue/utils/log/L;", "block", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "printer", "c", "from", "clearAllLog", "getAllLog", "Ljava/lang/StringBuffer;", "n", "s", "log_release"})
public final class LogUtils {
    @NotNull
    public static final LogUtils INSTANCE = new LogUtils();
    @NotNull
    private static final LinkedList<BasePrinter> printers = new LinkedList();
    @Nullable
    private static BasePrinter firstPrinter;
    @NotNull
    private static final RecordPrinter recordPrinter;
    @NotNull
    private static HashMap<String, Long> apartMap;

    private LogUtils() {
    }

    public final void println(@NotNull LogLevel logLevel, @NotNull String tag, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        BasePrinter basePrinter = firstPrinter;
        if (basePrinter != null) {
            basePrinter.printlnAny(logLevel, tag, string);
        }
    }

    @JvmStatic
    public static final void addPrinter(@NotNull L $this$addPrinter, @NotNull Function3<? super LogLevel, ? super String, ? super String, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$addPrinter, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        BasePrinter printer2 = new BasePrinter(block){
            final /* synthetic */ Function3<LogLevel, String, String, Unit> $block;
            {
                this.$block = $block;
            }

            public void println(@NotNull LogLevel logLevel, @NotNull String tag, @NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                Intrinsics.checkNotNullParameter((Object)string, (String)"string");
                this.$block.invoke((Object)((Object)logLevel), (Object)tag, (Object)string);
            }
        };
        LogUtils.addPrinter($this$addPrinter, printer2);
    }

    @JvmStatic
    public static final void addPrinter(@NotNull L $this$addPrinter, @NotNull BasePrinter printer2) {
        Intrinsics.checkNotNullParameter((Object)$this$addPrinter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)printer2, (String)"printer");
        int pos = printers.size() - 1;
        printers.add(pos, printer2);
        INSTANCE.updatePrinters();
    }

    @JvmStatic
    @NotNull
    public static final StringBuffer getAllLog(@NotNull L $this$getAllLog) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllLog, (String)"<this>");
        return recordPrinter.getLog();
    }

    @JvmStatic
    public static final void clearAllLog(@NotNull L $this$clearAllLog) {
        Intrinsics.checkNotNullParameter((Object)$this$clearAllLog, (String)"<this>");
        recordPrinter.getLog().setLength(0);
    }

    private final void updatePrinters() {
        int n = 0;
        int len = printers.size();
        if (n < len) {
            do {
                int i;
                if ((i = n++) <= 0) continue;
                BasePrinter basePrinter = printers.get(i);
                Intrinsics.checkNotNullExpressionValue((Object)basePrinter, (String)"printers[i]");
                printers.get(i - 1).setNextPrinter(basePrinter);
            } while (n < len);
        }
        firstPrinter = len == 0 ? null : printers.get(0);
    }

    @NotNull
    public final String throwToString(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        e.printStackTrace(printWriter);
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            cause.printStackTrace(printWriter);
        }
        printWriter.close();
        String string = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writer.toString()");
        return string;
    }

    @NotNull
    public final HashMap<String, Long> getApartMap() {
        return apartMap;
    }

    public final void setApartMap(@NotNull HashMap<String, Long> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        apartMap = hashMap;
    }

    public final void n(@NotNull L $this$n, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)$this$n, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.s(L.INSTANCE, tag);
    }

    public final void s(@NotNull L $this$s, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)$this$s, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Object object = tag;
        boolean bl = false;
        if (object.length() == 0) {
            L.w("tag should not be empty!");
            return;
        }
        if (apartMap.get(tag) == null) {
            object = apartMap;
            Long l = System.currentTimeMillis();
            boolean bl2 = false;
            object.put(tag, l);
        } else {
            String string = Intrinsics.stringPlus((String)tag, (Object)" Apart Time");
            long l = System.currentTimeMillis();
            Long l2 = apartMap.get(tag);
            Intrinsics.checkNotNull((Object)l2);
            object = l2;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"apartMap[tag]!!");
            L.d(string, l - ((Number)object).longValue());
            apartMap.remove(tag);
        }
    }

    public final void c(@NotNull L $this$c, @NotNull String from) {
        Intrinsics.checkNotNullParameter((Object)$this$c, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        StackTraceElement stackTrace = new Throwable().getStackTrace()[1];
        L.d(from + " -> " + stackTrace.getMethodName() + "()");
    }

    static {
        recordPrinter = new RecordPrinter();
        LinkedList<BasePrinter> linkedList = printers;
        boolean bl = false;
        boolean bl2 = false;
        LinkedList<BasePrinter> $this$_init__u24lambda_u2d0 = linkedList;
        boolean bl3 = false;
        $this$_init__u24lambda_u2d0.add(new DefaultPrinter());
        $this$_init__u24lambda_u2d0.add(recordPrinter);
        INSTANCE.updatePrinters();
        apartMap = new HashMap();
    }
}

