/*
 * Decompiled with CFR 0.152.
 */
package top.heue.utils.binding.helper;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.appwidget.AppWidgetManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.widget.RemoteViews;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.target.AppWidgetTarget;
import com.bumptech.glide.request.target.Target;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.heue.utils.binding.helper.WidgetHelperException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 =2\u00020\u0001:\u0001=B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006JG\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020\u00152%\u0010-\u001a!\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0002\u0012\u0004\u0012\u00020\u00190\u0016j\u0002`\u001bH\u0007J\u0016\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\u0015J\u000e\u00101\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u001fJ\u0016\u00102\u001a\n 4*\u0004\u0018\u000103032\u0006\u0010+\u001a\u00020\u001fJ\u0016\u00102\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u001f2\u0006\u00102\u001a\u000203J\u0016\u00105\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0015J\u001e\u00106\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u001f2\u0006\u00107\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u0001J\u000e\u00108\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\bJ\u0016\u00109\u001a\u00020\u00002\u0006\u0010:\u001a\u00020\u001f2\u0006\u00109\u001a\u00020\u0015J\u0006\u0010;\u001a\u00020\u0019J\u000e\u0010;\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\nJ\u0016\u0010;\u001a\u00020\u00192\u0006\u0010<\u001a\u00020\b2\u0006\u0010&\u001a\u00020\nR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012Rd\u0010\u0013\u001aX\u0012\u0004\u0012\u00020\u0015\u0012\u001f\u0012\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0002\u0012\u0004\u0012\u00020\u00190\u00160\u0014j-\u0012\u0004\u0012\u00020\u0015\u0012#\u0012!\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0002\u0012\u0004\u0012\u00020\u00190\u0016j\u0002`\u001b`\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010 \u001a\u0004\u0018\u00010\u001f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f@BX\u0082\u000e\u00a2\u0006\n\n\u0002\u0010#\"\u0004\b!\u0010\"R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u000eR\u0014\u0010&\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006>"}, d2={"Ltop/heue/utils/binding/helper/WidgetHelper;", "", "context", "Landroid/content/Context;", "providerClass", "Ljava/lang/Class;", "(Landroid/content/Context;Ljava/lang/Class;)V", "_targetWidgetIds", "", "_views", "Landroid/widget/RemoteViews;", "appContext", "appWidgetIds", "getAppWidgetIds", "()[I", "appWidgetManager", "Landroid/appwidget/AppWidgetManager;", "getAppWidgetManager", "()Landroid/appwidget/AppWidgetManager;", "clickEvent", "Ljava/util/HashMap;", "", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "", "Lkotlin/collections/HashMap;", "Ltop/heue/utils/binding/helper/listener;", "isTipsCalledRegeditClickEvent", "", "value", "", "layoutId", "setLayoutId", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "targetWidgetIds", "getTargetWidgetIds", "views", "getViews", "()Landroid/widget/RemoteViews;", "click", "viewId", "widgetId", "action", "callback", "img", "imgViewId", "url", "layout", "options", "Landroid/os/Bundle;", "kotlin.jvm.PlatformType", "regeditClick", "setMethod", "methodName", "targetWidget", "text", "textViewId", "update", "ids", "Companion", "binding_release"})
public final class WidgetHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Class<?> providerClass;
    @NotNull
    private final Context appContext;
    @Nullable
    private Integer layoutId;
    @Nullable
    private RemoteViews _views;
    @NotNull
    private final int[] appWidgetIds;
    @Nullable
    private int[] _targetWidgetIds;
    @NotNull
    private HashMap<String, Function1<Context, Unit>> clickEvent;
    private boolean isTipsCalledRegeditClickEvent;

    public WidgetHelper(@NotNull Context context, @NotNull Class<?> providerClass) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(providerClass, (String)"providerClass");
        this.providerClass = providerClass;
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        this.appContext = context2;
        int[] nArray = this.getAppWidgetManager().getAppWidgetIds(new ComponentName(this.appContext, this.providerClass));
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"appWidgetManager.getAppW\u2026iderClass\n        )\n    )");
        this.appWidgetIds = nArray;
        this.clickEvent = new HashMap();
    }

    private final void setLayoutId(Integer value) {
        WidgetHelper $this$_set_layoutId__u24lambda_u2d0 = this;
        boolean bl = false;
        this.layoutId = value;
        String string = $this$_set_layoutId__u24lambda_u2d0.appContext.getPackageName();
        Integer n = $this$_set_layoutId__u24lambda_u2d0.layoutId;
        Intrinsics.checkNotNull((Object)n);
        $this$_set_layoutId__u24lambda_u2d0._views = new RemoteViews(string, n.intValue());
    }

    private final RemoteViews getViews() {
        if (this.layoutId == null || this._views == null) {
            throw new WidgetHelperException("RemoteViews\u4e3anull\uff0c\u53ef\u80fd\u672a\u5b9a\u4e49layoutId");
        }
        RemoteViews remoteViews = this._views;
        Intrinsics.checkNotNull((Object)remoteViews);
        return remoteViews;
    }

    private final AppWidgetManager getAppWidgetManager() {
        AppWidgetManager appWidgetManager = AppWidgetManager.getInstance((Context)this.appContext);
        Intrinsics.checkNotNullExpressionValue((Object)appWidgetManager, (String)"getInstance(appContext)");
        return appWidgetManager;
    }

    @NotNull
    public final int[] getAppWidgetIds() {
        return this.appWidgetIds;
    }

    private final int[] getTargetWidgetIds() {
        if (this._targetWidgetIds == null) {
            Log.w((String)"WidgetHelper", (String)"targetWidgetIds\u4e3anull\uff0c\u9ed8\u8ba4\u6240\u6709WidgetIds");
            return this.appWidgetIds;
        }
        Intrinsics.checkNotNull((Object)this._targetWidgetIds);
        return this._targetWidgetIds;
    }

    @NotNull
    public final WidgetHelper layout(int layoutId) {
        WidgetHelper widgetHelper;
        WidgetHelper $this$layout_u24lambda_u2d1 = widgetHelper = this;
        boolean bl = false;
        $this$layout_u24lambda_u2d1.setLayoutId(layoutId);
        return widgetHelper;
    }

    @NotNull
    public final WidgetHelper targetWidget(@NotNull int[] targetWidgetIds) {
        WidgetHelper widgetHelper;
        Intrinsics.checkNotNullParameter((Object)targetWidgetIds, (String)"targetWidgetIds");
        WidgetHelper $this$targetWidget_u24lambda_u2d2 = widgetHelper = this;
        boolean bl = false;
        $this$targetWidget_u24lambda_u2d2._targetWidgetIds = targetWidgetIds;
        return widgetHelper;
    }

    @NotNull
    public final WidgetHelper img(int imgViewId, @NotNull String url) {
        WidgetHelper widgetHelper;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        WidgetHelper $this$img_u24lambda_u2d3 = widgetHelper = this;
        boolean bl = false;
        int[] nArray = $this$img_u24lambda_u2d3.getTargetWidgetIds();
        AppWidgetTarget appWidgetTarget = new AppWidgetTarget($this$img_u24lambda_u2d3.appContext, imgViewId, $this$img_u24lambda_u2d3.getViews(), Arrays.copyOf(nArray, nArray.length));
        ((RequestBuilder)Glide.with((Context)$this$img_u24lambda_u2d3.appContext).asBitmap().load(url).diskCacheStrategy(DiskCacheStrategy.AUTOMATIC)).into((Target)appWidgetTarget);
        return widgetHelper;
    }

    @NotNull
    public final WidgetHelper text(int textViewId, @NotNull String text) {
        WidgetHelper widgetHelper;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        WidgetHelper $this$text_u24lambda_u2d4 = widgetHelper = this;
        boolean bl = false;
        $this$text_u24lambda_u2d4.getViews().setTextViewText(textViewId, (CharSequence)text);
        return widgetHelper;
    }

    public final void regeditClick(@NotNull Context context, @NotNull String action) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.isTipsCalledRegeditClickEvent = true;
        for (Map.Entry event : ((Map)this.clickEvent).entrySet()) {
            if (!Intrinsics.areEqual((Object)action, event.getKey())) continue;
            ((Function1)event.getValue()).invoke((Object)context);
            break;
        }
    }

    @SuppressLint(value={"UnspecifiedImmutableFlag"})
    @NotNull
    public final WidgetHelper click(int viewId, int widgetId, @NotNull String action, @NotNull Function1<? super Context, Unit> callback) {
        WidgetHelper widgetHelper;
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        WidgetHelper $this$click_u24lambda_u2d5 = widgetHelper = this;
        boolean bl = false;
        ((Map)$this$click_u24lambda_u2d5.clickEvent).put(action + '.' + widgetId, callback);
        Intent intent = new Intent($this$click_u24lambda_u2d5.appContext, $this$click_u24lambda_u2d5.providerClass);
        intent.setAction(action + '.' + widgetId);
        PendingIntent pIntent = PendingIntent.getBroadcast((Context)$this$click_u24lambda_u2d5.appContext, (int)0, (Intent)intent, (int)0);
        $this$click_u24lambda_u2d5.getViews().setOnClickPendingIntent(viewId, pIntent);
        if (!$this$click_u24lambda_u2d5.isTipsCalledRegeditClickEvent) {
            $this$click_u24lambda_u2d5.isTipsCalledRegeditClickEvent = true;
            Log.d((String)"WidgetHelper", (String)"\u76ee\u524d\u672a\u66fe\u8c03\u7528regeditClick\uff0c\u8bf7\u52a1\u5fc5\u5728onReceive\u4e2d\u8c03\u7528regeditClick");
        }
        return widgetHelper;
    }

    @NotNull
    public final WidgetHelper setMethod(int viewId, @NotNull String methodName, @NotNull Object value) {
        WidgetHelper widgetHelper;
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        WidgetHelper $this$setMethod_u24lambda_u2d6 = widgetHelper = this;
        boolean bl = false;
        Object object = value;
        if (object instanceof Integer) {
            $this$setMethod_u24lambda_u2d6.getViews().setInt(viewId, methodName, ((Number)value).intValue());
        } else if (object instanceof String) {
            $this$setMethod_u24lambda_u2d6.getViews().setString(viewId, methodName, (String)value);
        } else if (object instanceof Boolean) {
            $this$setMethod_u24lambda_u2d6.getViews().setBoolean(viewId, methodName, ((Boolean)value).booleanValue());
        } else if (object instanceof Bitmap) {
            $this$setMethod_u24lambda_u2d6.getViews().setBitmap(viewId, methodName, (Bitmap)value);
        } else if (object instanceof Long) {
            $this$setMethod_u24lambda_u2d6.getViews().setLong(viewId, methodName, ((Number)value).longValue());
        } else if (object instanceof Float) {
            $this$setMethod_u24lambda_u2d6.getViews().setFloat(viewId, methodName, ((Number)value).floatValue());
        } else if (object instanceof Byte) {
            $this$setMethod_u24lambda_u2d6.getViews().setByte(viewId, methodName, ((Number)value).byteValue());
        } else if (object instanceof Character) {
            $this$setMethod_u24lambda_u2d6.getViews().setChar(viewId, methodName, ((Character)value).charValue());
        } else if (object instanceof Bundle) {
            $this$setMethod_u24lambda_u2d6.getViews().setBundle(viewId, methodName, (Bundle)value);
        } else if (object instanceof Double) {
            $this$setMethod_u24lambda_u2d6.getViews().setDouble(viewId, methodName, ((Number)value).doubleValue());
        } else if (object instanceof Short) {
            $this$setMethod_u24lambda_u2d6.getViews().setShort(viewId, methodName, ((Number)value).shortValue());
        } else if (object instanceof Uri) {
            $this$setMethod_u24lambda_u2d6.getViews().setUri(viewId, methodName, (Uri)value);
        }
        if (Build.VERSION.SDK_INT >= 23 && value instanceof Icon) {
            $this$setMethod_u24lambda_u2d6.getViews().setIcon(viewId, methodName, (Icon)value);
        }
        return widgetHelper;
    }

    public final Bundle options(int widgetId) {
        return this.getAppWidgetManager().getAppWidgetOptions(widgetId);
    }

    public final void options(int widgetId, @NotNull Bundle options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.getAppWidgetManager().updateAppWidgetOptions(widgetId, options);
    }

    public final void update(@NotNull RemoteViews views) {
        Intrinsics.checkNotNullParameter((Object)views, (String)"views");
        this.update(this.getTargetWidgetIds(), views);
    }

    public final void update() {
        this.update(this.getTargetWidgetIds(), this.getViews());
    }

    public final void update(@NotNull int[] ids, @NotNull RemoteViews views) {
        Intrinsics.checkNotNullParameter((Object)ids, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)views, (String)"views");
        this.getAppWidgetManager().updateAppWidget(ids, views);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u00a8\u0006\t"}, d2={"Ltop/heue/utils/binding/helper/WidgetHelper$Companion;", "", "()V", "with", "Ltop/heue/utils/binding/helper/WidgetHelper;", "context", "Landroid/content/Context;", "providerClass", "Ljava/lang/Class;", "binding_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WidgetHelper with(@NotNull Context context, @NotNull Class<?> providerClass) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(providerClass, (String)"providerClass");
            Companion $this$with_u24lambda_u2d0 = this;
            boolean bl = false;
            Log.d((String)"WidgetHelper", (String)"\u65b0\u5efaWidgetHelper");
            return new WidgetHelper(context, providerClass);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

