/*
 * Decompiled with CFR 0.152.
 */
package top.beanshell.web.vo;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import org.springframework.util.StringUtils;
import top.beanshell.common.exception.code.GlobalStatusCode;
import top.beanshell.common.model.enu.EnumCode;

@JsonPropertyOrder(value={"code", "msg", "data"})
public class BaseResponse<T>
implements Serializable {
    private Integer code;
    private String msg;
    private T data;

    public BaseResponse() {
        this.setSuccess();
    }

    public BaseResponse(String msg) {
        this.msg = msg;
    }

    public BaseResponse(EnumCode statusCode) {
        this.setStatus(statusCode);
    }

    public BaseResponse(T data) {
        this.data = data;
    }

    public void setFailed() {
        this.setStatus((EnumCode)GlobalStatusCode.FAILED);
    }

    public void setSuccess() {
        this.setStatus((EnumCode)GlobalStatusCode.SUCCESS);
    }

    public void setStatus(EnumCode status) {
        this.code = status.getCode();
        this.msg = status.getText();
    }

    public void setStatus(EnumCode status, String message) {
        this.code = status.getCode();
        this.msg = null != status && StringUtils.hasText((String)message) ? status.getText() + ">>>" + message : status.getText();
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseResponse)) {
            return false;
        }
        BaseResponse other = (BaseResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "BaseResponse(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
    }
}

