/*
 * Decompiled with CFR 0.152.
 */
package top.beanshell.web.config.handler;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.NoHandlerFoundException;
import top.beanshell.common.exception.BaseException;
import top.beanshell.common.exception.code.GlobalStatusCode;
import top.beanshell.common.model.enu.EnumCode;
import top.beanshell.web.vo.BaseResponse;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public BaseResponse defaultErrorHandler(HttpServletRequest req, Exception e) throws Exception {
        BaseResponse r = new BaseResponse();
        if (e instanceof MethodArgumentTypeMismatchException) {
            log.error("Parameter error: {}", (Object)e.getMessage(), (Object)e);
            r.setStatus((EnumCode)GlobalStatusCode.INVALID_PARAMETER_TYPE);
        } else if (e instanceof IllegalArgumentException) {
            log.error("Parameter error: {}", (Object)e.getMessage(), (Object)e);
            r.setStatus((EnumCode)GlobalStatusCode.INVALID_PARAMETER);
        } else if (e instanceof HttpMessageNotReadableException) {
            r.setStatus((EnumCode)GlobalStatusCode.MESSAGE_BODY_INVALID);
        } else {
            log.error("unknown error: {}", (Object)e.getMessage(), (Object)e);
            r.setStatus((EnumCode)GlobalStatusCode.SERVER_ERROR);
        }
        return r;
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    @ResponseBody
    public BaseResponse notFoundErrorHandler(HttpServletRequest req, NoHandlerFoundException e) {
        BaseResponse response = new BaseResponse();
        response.setStatus((EnumCode)GlobalStatusCode.RESOURCE_IS_NOT_EXIST);
        return response;
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseBody
    public BaseResponse bindErrorHandler(HttpServletRequest req, BindException e) {
        log.debug("bind error: {}", (Object)e.getMessage(), (Object)e);
        return this.returnArgumentErrorMsg(e.getBindingResult());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    public BaseResponse argumentNotValidErrorHandler(MethodArgumentNotValidException e) {
        log.debug("argumentNotValid: {}", (Object)e.getMessage(), (Object)e);
        return this.returnArgumentErrorMsg(e.getBindingResult());
    }

    @ExceptionHandler(value={BaseException.class})
    @ResponseBody
    public BaseResponse customErrorHandler(HttpServletRequest req, BaseException e) {
        BaseResponse response = new BaseResponse();
        response.setStatus(e.getStatus(), e.getMessage());
        return response;
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    public BaseResponse requestMethodNotSupportedErrorHandler(HttpRequestMethodNotSupportedException e) {
        BaseResponse response = new BaseResponse((EnumCode)GlobalStatusCode.REQUEST_METHOD_NOT_SUPPORT);
        return response;
    }

    private String handleArgumentErrorMsg(BindingResult bindingResult) {
        List errors = bindingResult.getFieldErrors();
        StringBuilder sb = new StringBuilder();
        if (errors != null) {
            for (FieldError error : errors) {
                String msg = error.getDefaultMessage();
                sb.append(msg).append("\n");
            }
        }
        return sb.toString();
    }

    private BaseResponse returnArgumentErrorMsg(BindingResult bindingResult) {
        String errorMsg = this.handleArgumentErrorMsg(bindingResult);
        log.error("invalid parameter error: {}", (Object)errorMsg);
        BaseResponse<String> response = new BaseResponse<String>();
        response.setStatus((EnumCode)GlobalStatusCode.INVALID_PARAMETER);
        response.setData(errorMsg);
        return response;
    }
}

