/*
 * Decompiled with CFR 0.152.
 */
package top.beanshell.web.config;

import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import top.beanshell.web.config.properties.CorsProperties;

@Configuration
@ConditionalOnProperty(name={"ram.application.cors.enable"}, havingValue="true")
public class CorsConfig {
    @Resource
    private CorsProperties corsProperties;

    @Bean
    public CorsFilter corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(Boolean.valueOf(true));
        if (StringUtils.hasText((String)this.corsProperties.getDomain())) {
            String[] domains;
            for (String domain : domains = this.corsProperties.getDomain().split(";")) {
                config.addAllowedOrigin(domain);
            }
        }
        config.addAllowedHeader("*");
        config.addAllowedMethod("*");
        source.registerCorsConfiguration(this.corsProperties.getPath(), config);
        return new CorsFilter((CorsConfigurationSource)source);
    }
}

