/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.scala.introspect;

import java.io.Serializable;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.util.hashing.MurmurHash3$;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.deser.CreatorProperty;
import tools.jackson.databind.type.CollectionLikeType;
import tools.jackson.databind.type.MapLikeType;
import tools.jackson.databind.type.ReferenceType;
import tools.jackson.databind.type.SimpleType;
import tools.jackson.module.scala.introspect.ClassHolder;
import tools.jackson.module.scala.introspect.WrappedCreatorProperty$;

public class WrappedCreatorProperty
extends CreatorProperty
implements Product,
Serializable {
    private final CreatorProperty creatorProperty;
    private final ClassHolder refHolder;

    public static WrappedCreatorProperty apply(CreatorProperty creatorProperty, ClassHolder classHolder) {
        return WrappedCreatorProperty$.MODULE$.apply(creatorProperty, classHolder);
    }

    public static WrappedCreatorProperty fromProduct(Product product) {
        return WrappedCreatorProperty$.MODULE$.fromProduct(product);
    }

    public static WrappedCreatorProperty unapply(WrappedCreatorProperty wrappedCreatorProperty) {
        return WrappedCreatorProperty$.MODULE$.unapply(wrappedCreatorProperty);
    }

    public WrappedCreatorProperty(CreatorProperty creatorProperty, ClassHolder refHolder) {
        this.creatorProperty = creatorProperty;
        this.refHolder = refHolder;
        super(creatorProperty, creatorProperty.getFullName());
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, -116910899, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof WrappedCreatorProperty)) return false;
        WrappedCreatorProperty wrappedCreatorProperty = (WrappedCreatorProperty)object;
        CreatorProperty creatorProperty = this.creatorProperty();
        CreatorProperty creatorProperty2 = wrappedCreatorProperty.creatorProperty();
        if (creatorProperty == null) {
            if (creatorProperty2 != null) {
                return false;
            }
        } else if (!creatorProperty.equals(creatorProperty2)) return false;
        ClassHolder classHolder = this.refHolder();
        ClassHolder classHolder2 = wrappedCreatorProperty.refHolder();
        if (classHolder == null) {
            if (classHolder2 != null) {
                return false;
            }
        } else if (!((Object)classHolder).equals(classHolder2)) return false;
        if (!wrappedCreatorProperty.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof WrappedCreatorProperty;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "WrappedCreatorProperty";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "creatorProperty";
        }
        if (1 == n2) {
            return "refHolder";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public CreatorProperty creatorProperty() {
        return this.creatorProperty;
    }

    public ClassHolder refHolder() {
        return this.refHolder;
    }

    public JavaType getType() {
        JavaType javaType = super.getType();
        if (javaType instanceof ReferenceType) {
            ReferenceType rt = (ReferenceType)javaType;
            if (this.refHolder().valueClass().isDefined()) {
                return this.updateReferenceType(rt, (Class)this.refHolder().valueClass().get());
            }
        }
        if (javaType instanceof CollectionLikeType) {
            CollectionLikeType ct = (CollectionLikeType)javaType;
            if (this.refHolder().valueClass().isDefined()) {
                return this.updateCollectionType(ct, (Class)this.refHolder().valueClass().get());
            }
        }
        if (javaType instanceof MapLikeType) {
            MapLikeType mt = (MapLikeType)javaType;
            if (this.refHolder().valueClass().isDefined()) {
                return this.updateMapType(mt, (Class)this.refHolder().valueClass().get());
            }
        }
        JavaType other = javaType;
        return other;
    }

    private ReferenceType updateReferenceType(ReferenceType rt, Class<?> newRefClass) {
        JavaType javaType = rt.getContentType();
        if (javaType instanceof ReferenceType) {
            ReferenceType innerRt = (ReferenceType)javaType;
            return ReferenceType.upgradeFrom((JavaType)rt, (JavaType)this.updateReferenceType(innerRt, newRefClass));
        }
        if (javaType instanceof CollectionLikeType) {
            CollectionLikeType innerCt = (CollectionLikeType)javaType;
            return ReferenceType.upgradeFrom((JavaType)rt, (JavaType)this.updateCollectionType(innerCt, newRefClass));
        }
        if (javaType instanceof MapLikeType) {
            MapLikeType innerMt = (MapLikeType)javaType;
            return ReferenceType.upgradeFrom((JavaType)rt, (JavaType)this.updateMapType(innerMt, newRefClass));
        }
        return ReferenceType.upgradeFrom((JavaType)rt, (JavaType)SimpleType.constructUnsafe(newRefClass));
    }

    private CollectionLikeType updateCollectionType(CollectionLikeType ct, Class<?> newRefClass) {
        JavaType javaType = ct.getContentType();
        if (javaType instanceof ReferenceType) {
            ReferenceType innerRt = (ReferenceType)javaType;
            return CollectionLikeType.upgradeFrom((JavaType)ct, (JavaType)this.updateReferenceType(innerRt, newRefClass));
        }
        if (javaType instanceof CollectionLikeType) {
            CollectionLikeType innerCt = (CollectionLikeType)javaType;
            return CollectionLikeType.upgradeFrom((JavaType)ct, (JavaType)this.updateCollectionType(innerCt, newRefClass));
        }
        if (javaType instanceof MapLikeType) {
            MapLikeType innerMt = (MapLikeType)javaType;
            return CollectionLikeType.upgradeFrom((JavaType)ct, (JavaType)this.updateMapType(innerMt, newRefClass));
        }
        return CollectionLikeType.upgradeFrom((JavaType)ct, (JavaType)SimpleType.constructUnsafe(newRefClass));
    }

    private MapLikeType updateMapType(MapLikeType mt, Class<?> newRefClass) {
        JavaType javaType = mt.getContentType();
        if (javaType instanceof ReferenceType) {
            ReferenceType innerRt = (ReferenceType)javaType;
            return MapLikeType.upgradeFrom((JavaType)mt, (JavaType)mt.getKeyType(), (JavaType)this.updateReferenceType(innerRt, newRefClass));
        }
        if (javaType instanceof CollectionLikeType) {
            CollectionLikeType innerCt = (CollectionLikeType)javaType;
            return MapLikeType.upgradeFrom((JavaType)mt, (JavaType)mt.getKeyType(), (JavaType)this.updateCollectionType(innerCt, newRefClass));
        }
        if (javaType instanceof MapLikeType) {
            MapLikeType innerMt = (MapLikeType)javaType;
            return MapLikeType.upgradeFrom((JavaType)mt, (JavaType)mt.getKeyType(), (JavaType)this.updateMapType(innerMt, newRefClass));
        }
        return MapLikeType.upgradeFrom((JavaType)mt, (JavaType)mt.getKeyType(), (JavaType)SimpleType.constructUnsafe(newRefClass));
    }

    public WrappedCreatorProperty copy(CreatorProperty creatorProperty, ClassHolder refHolder) {
        return new WrappedCreatorProperty(creatorProperty, refHolder);
    }

    public CreatorProperty copy$default$1() {
        return this.creatorProperty();
    }

    public ClassHolder copy$default$2() {
        return this.refHolder();
    }

    public CreatorProperty _1() {
        return this.creatorProperty();
    }

    public ClassHolder _2() {
        return this.refHolder();
    }
}

