/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.scala.deser;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.deser.std.StdDeserializer;
import tools.jackson.databind.jsontype.TypeDeserializer;
import tools.jackson.module.scala.deser.TupleDeserializer$;

public class TupleDeserializer
extends StdDeserializer<Product> {
    private final JavaType javaType;
    private final DeserializationConfig deserializationConfig;
    private final Seq<ValueDeserializer<Object>> valueDeserializers;
    private final Seq<TypeDeserializer> typeDeserializers;
    private final Class cls;
    private final Constructor[] ctors;
    private final Constructor ctor;

    public static Seq<ValueDeserializer<Object>> $lessinit$greater$default$3() {
        return TupleDeserializer$.MODULE$.$lessinit$greater$default$3();
    }

    public static Seq<TypeDeserializer> $lessinit$greater$default$4() {
        return TupleDeserializer$.MODULE$.$lessinit$greater$default$4();
    }

    public TupleDeserializer(JavaType javaType, DeserializationConfig deserializationConfig, Seq<ValueDeserializer<Object>> valueDeserializers, Seq<TypeDeserializer> typeDeserializers) {
        this.javaType = javaType;
        this.deserializationConfig = deserializationConfig;
        this.valueDeserializers = valueDeserializers;
        this.typeDeserializers = typeDeserializers;
        super(Product.class);
        this.cls = javaType.getRawClass();
        this.ctors = this.cls().getConstructors();
        if (this.ctors().length != 1) {
            throw new IllegalStateException("Tuple should have exactly one constructor");
        }
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.ctors());
        this.ctor = (Constructor)ArrayOps$.MODULE$.head$extension(object);
    }

    public Class<?> cls() {
        return this.cls;
    }

    public Constructor<?>[] ctors() {
        return this.ctors;
    }

    public Constructor<?> ctor() {
        return this.ctor;
    }

    public TupleDeserializer createContextual(DeserializationContext ctxt, BeanProperty property) {
        IndexedSeq paramTypes = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.javaType.containedTypeCount()).map((Function1 & Serializable)i -> this.$anonfun$1(BoxesRunTime.unboxToInt((Object)i)));
        IndexedSeq paramDesers = (IndexedSeq)paramTypes.map((Function1 & Serializable)_$1 -> ctxt.findContextualValueDeserializer(_$1, property));
        Seq typeDesers = property != null ? (Seq)paramTypes.map((Function1 & Serializable)_$2 -> ctxt.findPropertyTypeDeserializer(_$2, property.getMember())) : (Seq)paramTypes.map((Function1 & Serializable)baseType -> ctxt.findTypeDeserializer(baseType));
        return new TupleDeserializer(this.javaType, this.deserializationConfig, (Seq<ValueDeserializer<Object>>)paramDesers, (Seq<TypeDeserializer>)typeDesers);
    }

    public Product deserialize(JsonParser jp, DeserializationContext ctxt) {
        if (jp.isExpectedStartArrayToken()) {
            JsonToken t;
            Seq params = (Seq)((IterableOps)this.valueDeserializers.zip(this.typeDeserializers)).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    ValueDeserializer deser = (ValueDeserializer)tuple2._1();
                    TypeDeserializer typeDeser = (TypeDeserializer)tuple2._2();
                    jp.nextToken();
                    if (typeDeser == null) {
                        return deser.deserialize(jp, ctxt);
                    }
                    return deser.deserializeWithType(jp, ctxt, typeDeser);
                }
                throw new MatchError((Object)tuple2);
            });
            JsonToken jsonToken = t = jp.nextToken();
            JsonToken jsonToken2 = JsonToken.END_ARRAY;
            if (jsonToken == null ? jsonToken2 != null : !jsonToken.equals(jsonToken2)) {
                ctxt.reportWrongTokenException(ctxt.getContextualType(), JsonToken.END_ARRAY, "expected closing END_ARRAY after deserialized value", new Object[0]);
                return null;
            }
            return (Product)this.ctor().newInstance((Object[])Arrays$.MODULE$.seqToArray(params, Object.class));
        }
        return (Product)ctxt.handleUnexpectedToken(this.javaType, jp);
    }

    private final /* synthetic */ JavaType $anonfun$1(int i) {
        return this.javaType.containedType(i);
    }
}

