/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.guice7;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import com.google.inject.Key;
import jakarta.inject.Qualifier;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.stream.Stream;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.introspect.AnnotatedField;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.introspect.AnnotatedMethod;
import tools.jackson.databind.introspect.AnnotatedParameter;
import tools.jackson.databind.introspect.NopAnnotationIntrospector;

public class GuiceAnnotationIntrospector
extends NopAnnotationIntrospector {
    private static final long serialVersionUID = 1L;

    public JacksonInject.Value findInjectableValue(MapperConfig<?> config, AnnotatedMember m) {
        Object id = this._findGuiceInjectId(m);
        if (id == null) {
            return null;
        }
        return JacksonInject.Value.forId((Object)id);
    }

    private Object _findGuiceInjectId(AnnotatedMember m) {
        Annotation guiceAnnotation;
        AnnotatedMember guiceMember;
        if (m.getAnnotation(JacksonInject.class) == null && m.getAnnotation(jakarta.inject.Inject.class) == null && m.getAnnotation(Inject.class) == null) {
            return null;
        }
        if (m instanceof AnnotatedField || m instanceof AnnotatedParameter) {
            guiceMember = m;
            guiceAnnotation = this.findBindingAnnotation(m.annotations());
        } else if (m instanceof AnnotatedMethod) {
            AnnotatedMethod a = (AnnotatedMethod)m;
            if (a.getParameterCount() != 1) {
                return null;
            }
            guiceMember = a.getParameter(0);
            Annotation[] annotations = a.getMember().getParameterAnnotations()[0];
            guiceAnnotation = this.findBindingAnnotation(Stream.of(annotations));
        } else {
            return null;
        }
        if (guiceAnnotation == null) {
            return Key.get((Type)guiceMember.getRawType());
        }
        return Key.get((Type)guiceMember.getRawType(), (Annotation)guiceAnnotation);
    }

    private Annotation findBindingAnnotation(Stream<Annotation> annotations) {
        return annotations.filter(ann -> {
            Class<? extends Annotation> type = ann.annotationType();
            return type.isAnnotationPresent(BindingAnnotation.class) || type.isAnnotationPresent(Qualifier.class);
        }).findFirst().orElse(null);
    }
}

