/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.afterburner.deser;

import java.util.ArrayList;
import java.util.List;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.io.SerializedString;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.databind.deser.bean.BeanDeserializer;
import tools.jackson.databind.deser.bean.BeanPropertyMap;
import tools.jackson.databind.deser.bean.PropertyBasedCreator;
import tools.jackson.databind.deser.impl.UnwrappedPropertyHandler;

public abstract class SuperSonicBDBase
extends BeanDeserializer {
    protected final SerializedString[] _orderedPropertyNames;
    protected SettableBeanProperty[] _orderedProperties;

    public SuperSonicBDBase(BeanDeserializer src, List<SettableBeanProperty> props) {
        super(src);
        int len = props.size();
        this._orderedPropertyNames = new SerializedString[len];
        for (int i = 0; i < len; ++i) {
            this._orderedPropertyNames[i] = new SerializedString(props.get(i).getName());
        }
    }

    protected SuperSonicBDBase(SuperSonicBDBase src, UnwrappedPropertyHandler unwrapHandler, PropertyBasedCreator propertyBasedCreator, BeanPropertyMap renamedProperties, boolean ignoreAllUnknown) {
        super((BeanDeserializer)src, unwrapHandler, propertyBasedCreator, renamedProperties, ignoreAllUnknown);
        this._orderedPropertyNames = src._orderedPropertyNames;
        this._orderedProperties = src._orderedProperties;
    }

    public void resolve(DeserializationContext ctxt) {
        int i;
        super.resolve(ctxt);
        if (this._externalTypeIdHandler != null || this._unwrappedPropertyHandler != null) {
            return;
        }
        int len = this._orderedPropertyNames.length;
        ArrayList<SettableBeanProperty> props = new ArrayList<SettableBeanProperty>(len);
        for (i = 0; i < len; ++i) {
            SettableBeanProperty prop = this._beanProperties.findDefinition(this._orderedPropertyNames[i].toString());
            if (prop == null) continue;
            props.add(prop);
        }
        if (i == 0) {
            throw new IllegalStateException("Afterburner internal error: BeanDeserializer for " + String.valueOf(this._beanType) + " has no properties that match expected ordering (should have " + len + ") -- can not create optimized deserializer");
        }
        this._orderedProperties = props.toArray(new SettableBeanProperty[0]);
    }

    protected final Object _deserializeDisordered(JsonParser p, DeserializationContext ctxt, Object bean) throws JacksonException {
        int ix = p.currentNameMatch(this._propNameMatcher);
        while (true) {
            if (ix >= 0) {
                p.nextToken();
                SettableBeanProperty prop = this._propsByIndex[ix];
                try {
                    prop.deserializeAndSet(p, ctxt, bean);
                }
                catch (Exception e) {
                    this.wrapAndThrow(e, bean, prop.getName(), ctxt);
                }
            } else {
                if (ix == -1) {
                    return bean;
                }
                if (ix != -2) {
                    return this._handleUnexpectedWithin(p, ctxt, bean);
                }
                p.nextToken();
                this.handleUnknownVanilla(p, ctxt, bean, p.currentName());
            }
            ix = p.nextNameMatch(this._propNameMatcher);
        }
    }
}

